/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.jboss.deployment.remoting.StreamingTarget;
import org.jboss.deployment.spi.DeploymentMetaData;
import org.jboss.deployment.spi.DeploymentWorker;
import org.jboss.deployment.spi.JBossTarget;
import org.jboss.deployment.spi.JMXTarget;
import org.jboss.deployment.spi.JarUtils;
import org.jboss.deployment.spi.LocalhostTarget;
import org.jboss.deployment.spi.TargetModuleIDImpl;
import org.jboss.deployment.spi.configurations.WarConfiguration;
import org.jboss.deployment.spi.status.DeploymentStatusImpl;
import org.jboss.deployment.spi.status.ProgressObjectImpl;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.xml.sax.EntityResolver;

public class DeploymentManagerImpl
implements DeploymentManager {
    private static final Logger log = Logger.getLogger(DeploymentManagerImpl.class);
    public static final String DEPLOYER_URI = "http://org.jboss.deployment/jsr88";
    private Target[] targets;
    private HashMap mapDeploymentPlan;
    private DeploymentMetaData metaData;
    private List tmpFiles = new ArrayList();
    private URI deployURI;
    private boolean isConnected;

    public DeploymentManagerImpl(URI deployURI, boolean isConnected) {
        this(deployURI, isConnected, null, null);
    }

    public DeploymentManagerImpl(URI deployURI, boolean isConnected, String username, String password) {
        this.deployURI = deployURI;
        this.isConnected = isConnected;
        this.targets = null;
    }

    public Target[] getTargets() {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        if (this.targets == null) {
            if (this.deployURI.isOpaque()) {
                log.debug((Object)"Opaque URI seen, defaulting to LocalhostTarget");
                this.targets = new Target[]{new LocalhostTarget()};
            } else {
                log.debug((Object)"Non-Opaque URI seen, checking query for targetType");
                String query = this.deployURI.getQuery();
                String[] params = new String[]{};
                if (query != null) {
                    params = query.split("&|=");
                }
                String targetType = "jmx";
                for (int n = 0; n < params.length; n += 2) {
                    String key = params[n];
                    String value = params[n + 1];
                    if (!key.endsWith("targetType")) continue;
                    targetType = value;
                }
                this.targets = targetType.equals("remote") ? new Target[]{new StreamingTarget(this.deployURI)} : new Target[]{new JMXTarget(this.deployURI)};
            }
        }
        return this.targets;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targets) throws TargetException {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        log.debug((Object)("getRunningModules [type=" + moduleType + ",targets=" + Arrays.asList(targets) + "]"));
        HashSet<TargetModuleIDImpl> moduleSet = new HashSet<TargetModuleIDImpl>();
        TargetModuleID[] availableModules = this.getAvailableModules(moduleType, targets);
        if (availableModules == null) {
            log.debug((Object)"No modules available");
            return null;
        }
        for (int i = 0; i < availableModules.length; ++i) {
            TargetModuleIDImpl moduleID = (TargetModuleIDImpl)availableModules[i];
            if (!moduleID.isRunning()) continue;
            moduleSet.add(moduleID);
        }
        log.debug((Object)("Found [" + moduleSet.size() + "] running modules"));
        TargetModuleID[] idarr = new TargetModuleID[moduleSet.size()];
        moduleSet.toArray(idarr);
        return idarr;
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targets) throws TargetException {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        log.debug((Object)("getNonRunningModules [type=" + moduleType + ",targets=" + Arrays.asList(targets) + "]"));
        HashSet<TargetModuleIDImpl> moduleSet = new HashSet<TargetModuleIDImpl>();
        TargetModuleID[] availableModules = this.getAvailableModules(moduleType, targets);
        if (availableModules == null) {
            log.debug((Object)"No modules available");
            return null;
        }
        for (int i = 0; i < availableModules.length; ++i) {
            TargetModuleIDImpl moduleID = (TargetModuleIDImpl)availableModules[i];
            if (moduleID.isRunning()) continue;
            moduleSet.add(moduleID);
        }
        log.debug((Object)("Found [" + moduleSet.size() + "] non running modules"));
        TargetModuleID[] idarr = new TargetModuleID[moduleSet.size()];
        moduleSet.toArray(idarr);
        return idarr;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targets) throws TargetException {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        log.debug((Object)("getAvailableModules [type=" + moduleType + ",targets=" + Arrays.asList(targets) + "]"));
        ArrayList<TargetModuleID> targetModules = new ArrayList<TargetModuleID>();
        for (int i = 0; i < targets.length; ++i) {
            JBossTarget target = (JBossTarget)targets[i];
            TargetModuleID[] tmids = target.getAvailableModules(moduleType);
            targetModules.addAll(Arrays.asList(tmids));
        }
        log.debug((Object)("Found [" + targetModules.size() + "] available modules"));
        if (targetModules.size() > 0) {
            TargetModuleID[] idarr = new TargetModuleID[targetModules.size()];
            targetModules.toArray(idarr);
            return idarr;
        }
        return null;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject obj) throws InvalidModuleException {
        if (obj.getType().equals(ModuleType.WAR)) {
            return new WarConfiguration(obj);
        }
        throw new InvalidModuleException("CreateConfiguration: Module type not yet supported");
    }

    public ProgressObject distribute(Target[] targets, File moduleArchive, File deploymentPlan) {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        FileInputStream isModuleArchive = null;
        FileInputStream isDeploymentPlan = null;
        try {
            isModuleArchive = new FileInputStream(moduleArchive);
            isDeploymentPlan = new FileInputStream(deploymentPlan);
            return this.distribute(targets, isModuleArchive, isDeploymentPlan);
        }
        catch (FileNotFoundException e) {
            String message = "Cannot find deployment file" + e.getMessage();
            log.error((Object)message, (Throwable)e);
            DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, ActionType.EXECUTE, message);
            return new ProgressObjectImpl(status, null);
        }
    }

    public ProgressObject distribute(Target[] targets, InputStream moduleArchive, InputStream deploymentPlan) {
        return this.doDistribute(targets, null, moduleArchive, deploymentPlan);
    }

    public ProgressObject distribute(Target[] targets, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        return this.doDistribute(targets, type, moduleArchive, deploymentPlan);
    }

    private ProgressObject doDistribute(Target[] targets, ModuleType type, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        TargetModuleID[] targetModuleIDs = new TargetModuleID[targets.length];
        try {
            int i;
            this.mapDeploymentPlan = this.unpackDeploymentPlan(deploymentPlan);
            this.initDeploymentMetaData();
            TargetModuleInfo moduleInfo = this.createDeployment(moduleArchive, this.metaData.getDeploymentName());
            URL deployment = moduleInfo.getModuleID();
            if (type == null) {
                type = moduleInfo.getModuleType();
            }
            for (i = 0; i < targets.length; ++i) {
                JBossTarget target = (JBossTarget)targets[i];
                String moduleID = deployment.toExternalForm();
                targetModuleIDs[i] = new TargetModuleIDImpl(target, moduleID, null, false, type);
            }
            for (i = 0; i < this.tmpFiles.size(); ++i) {
                File file = (File)this.tmpFiles.get(i);
                if (file.equals(deployment)) continue;
                file.delete();
            }
        }
        catch (IOException e) {
            String message = "Exception during deployment validation";
            log.error((Object)message, (Throwable)e);
            DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.FAILED, CommandType.DISTRIBUTE, ActionType.EXECUTE, message);
            return new ProgressObjectImpl(status, targetModuleIDs);
        }
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.DISTRIBUTE, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress);
        worker.start();
        return progress;
    }

    private void initDeploymentMetaData() throws IOException {
        File metaTmpFile = (File)this.mapDeploymentPlan.get("deployment-plan.xml");
        if (metaTmpFile == null) {
            throw new IOException("Deployment plan does not contain an entry: deployment-plan.xml");
        }
        try {
            SAXReader reader = new SAXReader();
            reader.setEntityResolver((EntityResolver)new JBossEntityResolver());
            Document metaDoc = reader.read(metaTmpFile);
            this.metaData = new DeploymentMetaData(metaDoc);
            log.debug((Object)("deployment-plan.xml\n" + this.metaData.toXMLString()));
        }
        catch (Exception e) {
            log.error((Object)("Cannot obtain meta data: " + e));
        }
    }

    private TargetModuleInfo createDeployment(InputStream moduleArchive, String moduleName) throws IOException {
        File tmpFile = File.createTempFile("jboss_deployment_", ".zip");
        log.debug((Object)("temporary deployment file: " + tmpFile));
        JarInputStream jis = new JarInputStream(moduleArchive);
        JarOutputStream jos = null;
        FileOutputStream fos = new FileOutputStream(tmpFile);
        Manifest manifest = jis.getManifest();
        jos = manifest != null ? new JarOutputStream((OutputStream)fos, manifest) : new JarOutputStream(fos);
        TargetModuleInfo moduleInfo = new TargetModuleInfo();
        ModuleType moduleType = null;
        JarEntry entry = jis.getNextJarEntry();
        while (entry != null) {
            String entryName = entry.getName();
            if (!entryName.endsWith("/")) {
                if (entryName.endsWith("/application.xml")) {
                    moduleType = ModuleType.EAR;
                } else if (entryName.endsWith("/application-client.xml")) {
                    moduleType = ModuleType.CAR;
                } else if (entryName.endsWith("/ra.xml")) {
                    moduleType = ModuleType.RAR;
                } else if (entryName.endsWith("/web.xml")) {
                    moduleType = ModuleType.WAR;
                } else if (entryName.endsWith("/ejb-jar.xml")) {
                    moduleType = ModuleType.EJB;
                }
                if (entryName.endsWith(".jar") || entryName.endsWith(".war")) {
                    File tmpSubModule = this.processSubModule(entryName, jis);
                    FileInputStream fis = new FileInputStream(tmpSubModule);
                    JarUtils.addJarEntry(jos, entryName, fis);
                    fis.close();
                } else if (this.mapDeploymentPlan.get("!/" + entryName) == null) {
                    JarUtils.addJarEntry(jos, entryName, jis);
                } else {
                    log.debug((Object)("Skip entry found in deployment plan: " + entryName));
                }
            }
            entry = jis.getNextJarEntry();
        }
        if (moduleType == null) {
            if (moduleName.endsWith(ModuleType.EAR.getModuleExtension())) {
                moduleType = ModuleType.EAR;
            } else {
                throw new RuntimeException("cannot obtain module type");
            }
        }
        moduleInfo.setModuleType(moduleType);
        this.addDeploymentPlanEntry(jos, null);
        jos.close();
        String deploymentName = tmpFile.getParent() + File.separator + this.metaData.getDeploymentName();
        File deployment = new File(deploymentName);
        if (deployment.exists() && !deployment.delete()) {
            throw new IOException("Cannot delete existing deployment: " + deployment);
        }
        tmpFile.renameTo(deployment);
        moduleInfo.setModuleID(deployment.toURL());
        return moduleInfo;
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, File file, File file1) throws UnsupportedOperationException, IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        throw new UnsupportedOperationException("redeploy");
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleIDs, InputStream inputStream, InputStream inputStream1) throws UnsupportedOperationException, IllegalStateException {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        throw new UnsupportedOperationException("redeploy");
    }

    public ProgressObject start(TargetModuleID[] targetModuleIDs) {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        log.debug((Object)("start " + Arrays.asList(targetModuleIDs)));
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.START, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress);
        worker.start();
        return progress;
    }

    public ProgressObject stop(TargetModuleID[] targetModuleIDs) {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        log.debug((Object)("stop " + Arrays.asList(targetModuleIDs)));
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.STOP, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress);
        worker.start();
        return progress;
    }

    public ProgressObject undeploy(TargetModuleID[] targetModuleIDs) {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        log.debug((Object)("undeploy " + Arrays.asList(targetModuleIDs)));
        DeploymentStatusImpl status = new DeploymentStatusImpl(StateType.RUNNING, CommandType.UNDEPLOY, ActionType.EXECUTE, null);
        ProgressObjectImpl progress = new ProgressObjectImpl(status, targetModuleIDs);
        DeploymentWorker worker = new DeploymentWorker(progress);
        worker.start();
        return progress;
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList) {
        if (!this.isConnected) {
            throw new IllegalStateException("DeploymentManager is not connected");
        }
        throw new UnsupportedOperationException("redeploy");
    }

    public void release() {
        this.isConnected = false;
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public Locale getCurrentLocale() {
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException("setLocale");
    }

    public boolean isLocaleSupported(Locale locale) {
        return Locale.getDefault().equals(locale);
    }

    public Locale[] getSupportedLocales() {
        return new Locale[]{Locale.getDefault()};
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("setDConfigBeanVersion");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        return dConfigBeanVersionType == DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionTypeSupported(DConfigBeanVersionType version) {
        return version == DConfigBeanVersionType.V1_4;
    }

    public void setDConfigBeanVersionType(DConfigBeanVersionType version) {
        throw new UnsupportedOperationException("setDConfigBeanVersionType");
    }

    private File processSubModule(String entryName, JarInputStream jis) throws IOException {
        File tmpModule = this.getTempFile(entryName);
        this.tmpFiles.add(tmpModule);
        FileOutputStream fos = new FileOutputStream(tmpModule);
        JarUtils.copyStream(fos, jis);
        fos.close();
        JarInputStream jisModule = new JarInputStream(new FileInputStream(tmpModule));
        File tmpJBossModule = this.getTempFile("jboss_" + entryName);
        this.tmpFiles.add(tmpJBossModule);
        JarOutputStream jos = null;
        fos = new FileOutputStream(tmpJBossModule);
        Manifest manifest = jisModule.getManifest();
        jos = manifest != null ? new JarOutputStream((OutputStream)fos, manifest) : new JarOutputStream(fos);
        JarEntry entry = jisModule.getNextJarEntry();
        while (entry != null) {
            String subEntryName = entry.getName();
            if (this.mapDeploymentPlan.get(entryName + "!/" + subEntryName) == null) {
                JarUtils.addJarEntry(jos, subEntryName, jisModule);
            } else {
                log.debug((Object)("Skip entry found in deployment plan: " + subEntryName));
            }
            entry = jisModule.getNextJarEntry();
        }
        jisModule.close();
        this.addDeploymentPlanEntry(jos, entryName);
        jos.close();
        return tmpJBossModule;
    }

    private void addDeploymentPlanEntry(JarOutputStream jos, String moduleName) throws IOException {
        if (moduleName == null) {
            moduleName = "";
        }
        String moduleKey = moduleName + "!/";
        for (String key : this.mapDeploymentPlan.keySet()) {
            if (!key.startsWith(moduleKey)) continue;
            String dpName = key.substring(moduleKey.length());
            log.debug((Object)("found deployment plan entry: " + dpName));
            File dpFile = (File)this.mapDeploymentPlan.get(key);
            FileInputStream dpin = new FileInputStream(dpFile);
            JarUtils.addJarEntry(jos, dpName, dpin);
            dpin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap unpackDeploymentPlan(InputStream deploymentPlan) throws IOException {
        HashMap<String, File> dpMap = new HashMap<String, File>();
        if (deploymentPlan == null) {
            return dpMap;
        }
        try {
            JarInputStream jarDeploymentPlan = new JarInputStream(deploymentPlan);
            JarEntry entry = jarDeploymentPlan.getNextJarEntry();
            while (entry != null) {
                String entryName = entry.getName();
                log.debug((Object)("unpack deployment plan entry: " + entryName));
                File tempFile = this.getTempFile(entryName);
                dpMap.put(entryName, tempFile);
                FileOutputStream out = new FileOutputStream(tempFile);
                JarUtils.copyStream(out, jarDeploymentPlan);
                out.close();
                entry = jarDeploymentPlan.getNextJarEntry();
            }
        }
        finally {
            deploymentPlan.close();
        }
        return dpMap;
    }

    private File getTempFile(String entryName) throws IOException {
        entryName = entryName.replace('/', '_');
        int index = entryName.lastIndexOf(".");
        String prefix = entryName.substring(0, index);
        String suffix = entryName.substring(index);
        File tempFile = File.createTempFile(prefix, suffix);
        this.tmpFiles.add(tempFile);
        return tempFile;
    }

    private static class TargetModuleInfo {
        URL moduleID = null;
        ModuleType moduleType = null;

        private TargetModuleInfo() {
        }

        public URL getModuleID() {
            return this.moduleID;
        }

        public void setModuleID(URL url) {
            this.moduleID = url;
        }

        public ModuleType getModuleType() {
            return this.moduleType;
        }

        public void setModuleType(ModuleType type) {
            this.moduleType = type;
        }
    }
}

