/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message;

import javax.security.auth.message.MessageInfo;

public class MessagePolicy {
    protected TargetPolicy[] targetPolicies = null;
    private boolean mandatory;

    public MessagePolicy(TargetPolicy[] targetPolicies, boolean mandatory) {
        if (targetPolicies == null) {
            throw new IllegalArgumentException("specified targetPolicies is null");
        }
        this.targetPolicies = targetPolicies;
        this.mandatory = mandatory;
    }

    public TargetPolicy[] getTargetPolicies() {
        if (this.targetPolicies != null && this.targetPolicies.length == 0) {
            throw new IllegalStateException("Target Policies should not be of zero length");
        }
        return this.targetPolicies;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public static interface ProtectionPolicy {
        public static final String AUTHENTICATE_SENDER = "http://jboss.org/security/auth/container/auth_sender";
        public static final String AUTHENTICATE_RECIPIENT = "http://jboss.org/security/auth/container/auth_recipient";
        public static final String AUTHENTICATE_CONTENT = "http://jboss.org/security/auth/container/auth_content";

        public String getID();
    }

    public static class TargetPolicy {
        protected ProtectionPolicy protectionPolicy;
        protected Target[] targets;

        public TargetPolicy(Target[] targets, ProtectionPolicy protectionPolicy) {
            this.targets = targets;
            this.protectionPolicy = protectionPolicy;
        }

        public ProtectionPolicy getProtectionPolicy() {
            return this.protectionPolicy;
        }

        public Target[] getTargets() {
            if (this.targets != null && this.targets.length == 0) {
                throw new IllegalStateException(" Targets cannot be of length zero");
            }
            return this.targets;
        }
    }

    public static interface Target {
        public Object get(MessageInfo var1);

        public void put(MessageInfo var1, Object var2);

        public void remove(MessageInfo var1);
    }
}

