/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message.callback;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.x500.X500Principal;

public class PrivateKeyCallback
implements Callback {
    private Request request = null;
    private Certificate[] chain = null;
    private PrivateKey key = null;

    public PrivateKeyCallback(Request request) {
        this.request = request;
    }

    public Certificate[] getChain() {
        return this.chain;
    }

    public PrivateKey getKey() {
        return this.key;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setKey(PrivateKey key, Certificate[] chain) {
        this.key = key;
        this.chain = chain;
    }

    public static class SubjectKeyIDRequest {
        private byte[] subjectKeyID;

        public SubjectKeyIDRequest(byte[] keyID) {
            this.subjectKeyID = keyID;
        }

        public byte[] getSubjectKeyID() {
            return this.subjectKeyID;
        }
    }

    public static class IssuerSerialNumRequest {
        private X500Principal issuer;
        private BigInteger serialNumber;

        public IssuerSerialNumRequest(X500Principal issuer, BigInteger serialNumber) {
            this.issuer = issuer;
            this.serialNumber = serialNumber;
        }

        public X500Principal getIssuer() {
            return this.issuer;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }
    }

    public static class AliasRequest
    implements Request {
        private String alias = null;

        public AliasRequest(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    public static interface Request {
    }
}

