/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.lang.reflect.Method;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.threads.ThreadPoolExecutorMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBossThreadPoolExecutor
extends ThreadPoolExecutor
implements ThreadPoolExecutorMBean {
    private final String name;
    private final AtomicInteger rejectCount = new AtomicInteger();
    private static final Method GET_ALLOW_CORE_THREAD_TIMEOUT;
    private static final Method SET_ALLOW_CORE_THREAD_TIMEOUT;

    public JBossThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.name = name;
    }

    public JBossThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.name = name;
    }

    public JBossThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.setRejectedExecutionHandler(handler);
        this.name = name;
    }

    public JBossThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.setRejectedExecutionHandler(handler);
        this.name = name;
    }

    public void stop() {
        this.shutdown();
        try {
            this.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void destroy() {
        this.shutdownNow();
        try {
            this.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAllowCoreThreadTimeout() {
        Method method = GET_ALLOW_CORE_THREAD_TIMEOUT;
        try {
            return method != null ? (Boolean)method.invoke((Object)this, new Object[0]) : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setAllowCoreThreadTimeout(boolean allow) {
        Method method = SET_ALLOW_CORE_THREAD_TIMEOUT;
        try {
            if (method != null) {
                method.invoke((Object)this, allow);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxPoolSize() {
        return this.getMaximumPoolSize();
    }

    @Override
    public void setMaxPoolSize(int newSize) {
        this.setMaximumPoolSize(newSize);
    }

    @Override
    public long getKeepAliveTime() {
        return this.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long milliseconds) {
        this.setKeepAliveTime(milliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getCurrentPoolSize() {
        return this.getPoolSize();
    }

    @Override
    public int getRejectedCount() {
        return this.rejectCount.get();
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return ((CountingRejectHandler)super.getRejectedExecutionHandler()).getDelegate();
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        super.setRejectedExecutionHandler(new CountingRejectHandler(handler));
    }

    static {
        Method method = null;
        try {
            method = ThreadPoolExecutor.class.getMethod("allowsCoreThreadTimeOut", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        GET_ALLOW_CORE_THREAD_TIMEOUT = method;
        try {
            method = ThreadPoolExecutor.class.getMethod("allowCoreThreadTimeOut", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SET_ALLOW_CORE_THREAD_TIMEOUT = method;
    }

    private final class CountingRejectHandler
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public CountingRejectHandler(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        public RejectedExecutionHandler getDelegate() {
            return this.delegate;
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            JBossThreadPoolExecutor.this.rejectCount.incrementAndGet();
            this.delegate.rejectedExecution(r, executor);
        }
    }
}

