/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;

public abstract class SimpleSubDeployerSupport
extends SubDeployerSupport {
    private ServiceControllerMBean serviceController;
    private boolean registeredClassLoader = false;

    public abstract String getExtension();

    public abstract String getMetaDataURL();

    public abstract String getObjectName(DeploymentInfo var1) throws DeploymentException;

    public abstract String getDeploymentClass();

    public boolean accepts(DeploymentInfo di) {
        String extension;
        String urlStr = di.url.toString();
        return urlStr.endsWith(extension = this.getExtension()) || urlStr.endsWith(extension + '/');
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        URL url = this.getMetaDataResource(di);
        this.parseMetaData(di, url);
        this.resolveWatch(di, url);
        super.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        this.determineObjectName(di);
        ObjectName uclName = this.registerClassLoader(di);
        try {
            this.registerDeployment(di, uclName);
            try {
                this.createService(di);
                try {
                    super.create(di);
                }
                catch (Throwable t) {
                    this.destroyService(di);
                }
            }
            catch (Throwable t) {
                this.unregisterDeployment(di);
                throw t;
            }
        }
        catch (Throwable t) {
            this.unregisterClassLoader(di);
            DeploymentException.rethrowAsDeploymentException("Error creating deployment " + di.url, t);
        }
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        this.startService(di);
        try {
            super.start(di);
        }
        catch (Throwable t) {
            this.stopService(di);
            DeploymentException.rethrowAsDeploymentException("Error in start for deployment " + di.url, t);
        }
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        this.stopService(di);
        super.stop(di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(DeploymentInfo di) throws DeploymentException {
        try {
            this.destroyService(di);
            super.destroy(di);
            Object var3_2 = null;
            this.unregisterDeployment(di);
            this.unregisterClassLoader(di);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unregisterDeployment(di);
            this.unregisterClassLoader(di);
            throw throwable;
        }
    }

    public void postRegister(Boolean done) {
        super.postRegister(done);
        if (done.booleanValue()) {
            this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        }
    }

    protected URL getMetaDataResource(DeploymentInfo di) throws DeploymentException {
        URL url = di.localCl.findResource(this.getMetaDataURL());
        if (url == null) {
            throw new DeploymentException("Could not find meta data " + this.getMetaDataURL() + " for deployment " + di.url);
        }
        return url;
    }

    protected abstract void parseMetaData(DeploymentInfo var1, URL var2) throws DeploymentException;

    protected void resolveWatch(DeploymentInfo di, URL url) throws DeploymentException {
        File file;
        di.watch = di.url;
        if (di.url.getProtocol().equals("file") && (file = new File(di.url.getFile())).isDirectory()) {
            di.watch = url;
        }
    }

    protected void determineObjectName(DeploymentInfo di) throws DeploymentException {
        String objectName = this.getObjectName(di);
        try {
            di.deployedObject = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("INTERNAL ERROR: Bad object name. " + objectName);
        }
    }

    protected ObjectName registerClassLoader(DeploymentInfo di) throws DeploymentException {
        ObjectName uclName = null;
        try {
            RepositoryClassLoader ucl = di.ucl;
            uclName = ucl.getObjectName();
            if (!this.server.isRegistered(uclName)) {
                this.server.registerMBean(di.ucl, uclName);
                this.registeredClassLoader = true;
            }
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error registering classloader " + uclName, t);
        }
        return uclName;
    }

    protected void unregisterClassLoader(DeploymentInfo di) {
        ObjectName uclName = null;
        try {
            RepositoryClassLoader ucl = di.ucl;
            if (ucl != null) {
                uclName = ucl.getObjectName();
                if (this.registeredClassLoader && this.server.isRegistered(uclName)) {
                    this.server.unregisterMBean(uclName);
                    this.registeredClassLoader = false;
                }
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error unregistering classloader " + uclName), t);
        }
    }

    protected void registerDeployment(DeploymentInfo di, ObjectName uclName) throws DeploymentException {
        try {
            String deploymentClass = this.getDeploymentClass();
            this.server.createMBean(deploymentClass, di.deployedObject, uclName, new Object[]{di}, new String[]{DeploymentInfo.class.getName()});
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error registering deployment " + di.url, t);
        }
    }

    protected void unregisterDeployment(DeploymentInfo di) {
        try {
            if (this.server.isRegistered(di.deployedObject)) {
                this.server.unregisterMBean(di.deployedObject);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error unregistering deployment " + di.deployedObject), t);
        }
    }

    protected void createService(DeploymentInfo di) throws DeploymentException {
        try {
            this.serviceController.create(di.deployedObject);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error in create for deployment " + di.url, t);
        }
    }

    protected void startService(DeploymentInfo di) throws DeploymentException {
        try {
            this.serviceController.start(di.deployedObject);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error in start for deployment " + di.url, t);
        }
    }

    protected void stopService(DeploymentInfo di) {
        try {
            if (di.deployedObject != null) {
                this.serviceController.stop(di.deployedObject);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in stop for deployment " + di.url), t);
        }
    }

    protected void destroyService(DeploymentInfo di) throws DeploymentException {
        try {
            if (di.deployedObject != null) {
                this.serviceController.destroy(di.deployedObject);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in destroy for deployment " + di.url), t);
        }
        try {
            if (di.deployedObject != null) {
                this.serviceController.remove(di.deployedObject);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error in remove for deployment " + di.url), t);
        }
    }
}

