/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.dependency;

import java.util.HashSet;
import java.util.Set;
import org.jboss.deployment.dependency.JndiDependencyMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerDependencyMetaData
extends JBossObject {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ContainerDependencyMetaData.class);
    private String deploymentRootName;
    private String deploymentPath;
    private String componentName;
    private Set<String> jndiNames = new HashSet<String>();
    private String containerName;
    private Set<ResourceInjectionTargetMetaData> targets = new HashSet<ResourceInjectionTargetMetaData>();
    private Set<JndiDependencyMetaData> jndiDepends = new HashSet<JndiDependencyMetaData>();
    private Set<String> jndiAliasDepends = new HashSet<String>();
    private DefaultJndiBindingPolicy jndiPolicy;
    private boolean isEjb3X;
    private EjbDeploymentSummary unitSummary;

    public ContainerDependencyMetaData(String containerName, String componentName, String deploymentPath) {
        this.containerName = containerName;
        this.componentName = componentName;
        this.deploymentPath = deploymentPath;
        this.addJndiName(containerName);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentID() {
        return this.deploymentPath + "#" + this.componentName;
    }

    public String getDeploymentPath() {
        return this.deploymentPath;
    }

    public String getDeploymentRootName() {
        return this.deploymentRootName;
    }

    public void setDeploymentRootName(String deploymentRootName) {
        this.deploymentRootName = deploymentRootName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public JBossEnterpriseBeanMetaData getBeanMetaData() {
        return this.unitSummary.getBeanMD();
    }

    public EjbDeploymentSummary getUnitSummary() {
        return this.unitSummary;
    }

    public void setUnitSummary(EjbDeploymentSummary unitSummary) {
        this.unitSummary = unitSummary;
    }

    public boolean isEjb3X() {
        return this.isEjb3X;
    }

    public void setEjb3X(boolean isEjb3X) {
        this.isEjb3X = isEjb3X;
    }

    public void addDependency(ContainerDependencyMetaData endpointCDMD) {
        this.jndiAliasDepends.add(endpointCDMD.getContainerName());
    }

    public void addInjectionTargets(Set<ResourceInjectionTargetMetaData> injectionTargets) {
        log.info((Object)("addInjectionTargets, " + injectionTargets));
        this.targets.addAll(injectionTargets);
    }

    public Set<ResourceInjectionTargetMetaData> getInjectionTargets() {
        return this.targets;
    }

    public void addJndiDependency(JndiDependencyMetaData jdmd) {
        log.info((Object)("addJndiDependency, " + (Object)((Object)jdmd)));
        this.jndiDepends.add(jdmd);
    }

    public Set<JndiDependencyMetaData> getJndiDepends() {
        return this.jndiDepends;
    }

    public void addJndiName(String jndiName) {
        this.jndiNames.add(jndiName);
    }

    public Set<String> getJndiNames() {
        return this.jndiNames;
    }

    public String toShortString() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        this.toShortString(buffer);
        return buffer.toString();
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.containerName);
    }

    protected int getHashCode() {
        return super.getHashCode();
    }

    protected String toStringImplementation() {
        StringBuilder tmp = new StringBuilder("ContainerDependencyMetaData(");
        tmp.append("deploymentPath=");
        tmp.append(this.deploymentPath);
        tmp.append(",componentName=");
        tmp.append(this.componentName);
        tmp.append(",containerName=");
        tmp.append(this.containerName);
        tmp.append(",jndiNames=");
        tmp.append(this.jndiNames);
        tmp.append(",jndiAliasDepends=");
        tmp.append(this.jndiAliasDepends);
        tmp.append(",targets=");
        tmp.append(this.targets);
        tmp.append(",jndiDepends=");
        tmp.append(this.jndiDepends);
        tmp.append(")");
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

