/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.profileservice.spi.NoSuchDeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManagedDeploymentView {
    private static final Logger log = Logger.getLogger(AbstractManagedDeploymentView.class);
    private Map<ComponentType, Set<ManagedComponent>> compByCompType = new HashMap<ComponentType, Set<ManagedComponent>>();
    private Map<String, ManagedObject> moRegistry = new HashMap<String, ManagedObject>();
    private Map<String, Set<ManagedProperty>> unresolvedRefs = new HashMap<String, Set<ManagedProperty>>();
    private Map<String, ManagedObject> runtimeMOs = new HashMap<String, ManagedObject>();
    private Map<String, ManagedDeployment> managedDeployments = new TreeMap<String, ManagedDeployment>();
    private List<String> rootDeployments = new ArrayList<String>();

    protected void processManagedDeployment(ManagedDeployment md, DeploymentState state, int level, boolean trace) throws Exception {
        List mdChildren;
        String name = md.getName();
        if (trace) {
            log.trace((Object)(name + " ManagedDeployment_" + level + ": " + md));
        }
        Map mos = md.getManagedObjects();
        if (trace) {
            log.trace((Object)(name + " ManagedObjects_ " + level + ": " + mos));
        }
        if (state != null && md instanceof ManagedDeploymentImpl) {
            ((ManagedDeploymentImpl)md).setDeploymentState(state);
        }
        for (ManagedObject mo : mos.values()) {
            this.processManagedObject(mo, md);
        }
        this.managedDeployments.put(name, md);
        if (level == 0) {
            this.rootDeployments.add(name);
        }
        if ((mdChildren = md.getChildren()) != null && !mdChildren.isEmpty()) {
            for (ManagedDeployment mdChild : mdChildren) {
                this.processManagedDeployment(mdChild, state, level + 1, trace);
            }
        }
    }

    public Set<String> getDeploymentNamesForType(String type) {
        boolean trace = log.isTraceEnabled();
        HashSet<String> matches = new HashSet<String>();
        for (ManagedDeployment md : this.managedDeployments.values()) {
            String name = md.getName();
            Set types = md.getTypes();
            if (types == null || !types.contains(type)) continue;
            if (trace) {
                log.trace((Object)(name + " matches type: " + type + ", types:" + types));
            }
            matches.add(name);
        }
        return matches;
    }

    public Set<ManagedDeployment> getDeploymentsForType(String type) {
        Set<String> names = this.getDeploymentNamesForType(type);
        HashSet<ManagedDeployment> mds = new HashSet<ManagedDeployment>();
        for (String name : names) {
            ManagedDeployment md = this.managedDeployments.get(name);
            mds.add(md);
        }
        return mds;
    }

    public Set<ComponentType> getComponentTypes() {
        return this.compByCompType.keySet();
    }

    public Set<ManagedComponent> getComponentsForType(ComponentType type) {
        Set<Object> comps = this.compByCompType.get(type);
        if (comps == null) {
            comps = Collections.emptySet();
        }
        return comps;
    }

    public Set<String> getDeploymentNames() {
        return this.managedDeployments.keySet();
    }

    public Collection<ManagedDeployment> getDeployment(String name) throws NoSuchDeploymentException {
        if (name == null) {
            throw new IllegalArgumentException("Null deployment name");
        }
        ArrayList<ManagedDeployment> deployments = new ArrayList<ManagedDeployment>();
        if (this.managedDeployments.containsKey(name)) {
            ManagedDeployment md = this.managedDeployments.get(name);
            if (md != null) {
                deployments.add(md);
            }
        } else {
            Iterator<String> i$ = this.rootDeployments.iterator();
            while (i$.hasNext()) {
                ManagedDeployment md;
                String deployment;
                String fixedDeploymentName = deployment = i$.next();
                if (deployment.endsWith("/")) {
                    fixedDeploymentName = deployment.substring(0, deployment.length() - 1);
                }
                if (!fixedDeploymentName.endsWith(name) || (md = this.managedDeployments.get(deployment)) == null) continue;
                deployments.add(md);
            }
        }
        return deployments;
    }

    protected abstract void mergeRuntimeMO(ManagedObject var1, ManagedObject var2) throws Exception;

    protected abstract Set<ManagedOperation> createOperationProxies(ManagedObject var1, Set<ManagedOperation> var2) throws Exception;

    protected abstract RunState updateRunState(ManagedObject var1, ManagedComponent var2) throws Exception;

    protected void processManagedObject(ManagedObject mo, ManagedDeployment md) throws Exception {
        Set<ManagedComponent> typeComps;
        String key = mo.getName() + "/" + mo.getNameType();
        if (mo.getName().equals("org.jboss.security.plugins.SecurityConfig")) {
            log.info((Object)"Saw SecurityConfig MO");
        }
        log.debug((Object)("ID for ManagedObject: " + key + ", attachmentName: " + mo.getAttachmentName()));
        Map moAnns = mo.getAnnotations();
        ManagementObject managementObject = (ManagementObject)moAnns.get(ManagementObject.class.getName());
        if (managementObject.isRuntime()) {
            boolean merged = false;
            ManagementComponent mc = managementObject.componentType();
            boolean isMC = mc.type().length() != 0 || mc.subtype().length() != 0;
            ManagedObject parentMO = this.moRegistry.get(key);
            if (parentMO == null && !isMC) {
                log.debug((Object)("Deferring resolution of runtime ManagedObject: " + managementObject));
                this.runtimeMOs.put(key, mo);
            } else {
                this.mergeRuntimeMO(parentMO, mo);
                merged = true;
                this.runtimeMOs.remove(key);
            }
            ManagedComponent comp = md.getComponent(mo.getName());
            if (comp != null) {
                RunState state = this.updateRunState(mo, comp);
                log.debug((Object)("Updated component: " + comp + " run state to: " + state));
            }
            if (!isMC) {
                return;
            }
            if (!merged) {
                Set<ManagedOperation> runtimeOps = mo.getOperations();
                runtimeOps = this.createOperationProxies(mo, runtimeOps);
                MutableManagedObject moi = (MutableManagedObject)mo;
                moi.setOperations(runtimeOps);
            }
        } else {
            ManagedObject runtimeMO = this.runtimeMOs.get(key);
            if (runtimeMO != null) {
                this.mergeRuntimeMO(mo, runtimeMO);
                this.runtimeMOs.remove(key);
                ManagedComponent comp = md.getComponent(mo.getName());
                if (comp != null) {
                    RunState state = this.updateRunState(runtimeMO, comp);
                    log.debug((Object)("Updated component: " + comp + " run state to: " + state));
                }
            }
        }
        this.checkForReferences(key, mo);
        for (ManagedComponent comp : md.getComponents().values()) {
            log.debug((Object)("Updating ManagementComponent: " + comp));
            ComponentType type = comp.getType();
            typeComps = this.compByCompType.get(type);
            if (typeComps == null) {
                typeComps = new HashSet<ManagedComponent>();
                this.compByCompType.put(type, typeComps);
            }
            typeComps.add(comp);
        }
        ManagementComponent mc = (ManagementComponent)moAnns.get(ManagementComponent.class.getName());
        if (mc != null && md.getComponent(mo.getName()) == null) {
            ComponentType type = new ComponentType(mc.type(), mc.subtype());
            ManagedComponentImpl comp = new ManagedComponentImpl(type, md, mo);
            md.addComponent(mo.getName(), (ManagedComponent)comp);
            log.debug((Object)("Processing ManagementComponent(" + mo.getName() + "): " + comp));
            typeComps = this.compByCompType.get(type);
            if (typeComps == null) {
                typeComps = new HashSet<ManagedComponent>();
                this.compByCompType.put(type, typeComps);
            }
            typeComps.add((ManagedComponent)comp);
            this.updateRunState(null, (ManagedComponent)comp);
        }
        for (ManagedProperty prop : mo.getProperties().values()) {
            ArrayValue avalue;
            MetaType etype;
            ArrayMetaType amt;
            MetaType propType;
            log.debug((Object)("Checking property: " + prop));
            Map pannotations = prop.getAnnotations();
            if (pannotations != null && !pannotations.isEmpty()) {
                ManagementObjectRef ref;
                ManagementObjectID id = (ManagementObjectID)pannotations.get(ManagementObjectID.class.getName());
                if (id != null) {
                    Object refName = this.getRefName(prop.getValue());
                    if (refName == null) {
                        refName = id.name();
                    }
                    String propKey = refName + "/" + id.type();
                    log.debug((Object)("ManagedProperty level ID for ManagedObject: " + propKey + ", attachmentName: " + mo.getAttachmentName()));
                    this.moRegistry.put(propKey, mo);
                    this.checkForReferences(propKey, mo);
                }
                if ((ref = (ManagementObjectRef)pannotations.get(ManagementObjectRef.class.getName())) != null) {
                    String targetKey;
                    ManagedObject target;
                    log.debug((Object)("Property(" + prop.getName() + ") references: " + ref));
                    Object refName = this.getRefName(prop.getValue());
                    if (refName == null) {
                        refName = ref.name();
                    }
                    if ((target = this.moRegistry.get(targetKey = refName + "/" + ref.type())) != null) {
                        log.debug((Object)("Resolved property(" + prop.getName() + ") reference to: " + targetKey));
                        prop.setTargetManagedObject(target);
                    } else {
                        Set<ManagedProperty> referers = this.unresolvedRefs.get(targetKey);
                        if (referers == null) {
                            referers = new HashSet<ManagedProperty>();
                            this.unresolvedRefs.put(targetKey, referers);
                        }
                        referers.add(prop);
                    }
                }
            }
            if ((propType = prop.getMetaType()) == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) {
                this.processGenericValue((GenericValue)prop.getValue(), md);
                continue;
            }
            if (propType.isArray()) {
                amt = (ArrayMetaType)propType;
                etype = amt.getElementType();
                if (etype != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) continue;
                avalue = (ArrayValue)prop.getValue();
                int length = avalue != null ? avalue.getLength() : 0;
                for (int n = 0; n < length; ++n) {
                    this.processGenericValue((GenericValue)avalue.getValue(n), md);
                }
                continue;
            }
            if (!propType.isCollection() || (etype = (amt = (CollectionMetaType)propType).getElementType()) != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE || (avalue = (CollectionValue)prop.getValue()) == null) continue;
            MetaValue[] elements = avalue.getElements();
            for (int n = 0; n < avalue.getSize(); ++n) {
                GenericValue gv = (GenericValue)elements[n];
                ManagedObject propMO = (ManagedObject)gv.getValue();
                if (propMO == null) continue;
                this.processManagedObject(propMO, md);
            }
        }
    }

    protected Object getRefName(Object value) {
        if (value instanceof MetaValue) {
            MetaValue metaValue = (MetaValue)value;
            if (!metaValue.getMetaType().isSimple()) {
                throw new IllegalArgumentException("Can only get ref from simple value: " + value);
            }
            SimpleValue svalue = (SimpleValue)metaValue;
            return svalue.getValue();
        }
        return value;
    }

    protected void checkForReferences(String key, ManagedObject mo) {
        Set<ManagedProperty> referers = this.unresolvedRefs.get(key);
        log.debug((Object)("checkForReferences, " + key + " has referers: " + referers));
        if (referers != null) {
            for (ManagedProperty prop : referers) {
                prop.setTargetManagedObject(mo);
            }
            this.unresolvedRefs.remove(key);
        }
    }

    protected void processGenericValue(GenericValue genericValue, ManagedDeployment md) throws Exception {
        ManagedObject propMO;
        if (genericValue != null && (propMO = (ManagedObject)genericValue.getValue()) != null) {
            this.processManagedObject(propMO, md);
        }
    }
}

