/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.common.metadata.MetadataUtil;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.chain.ProcessorChain;

public class Ejb3MetadataProcessingDeployer
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(Ejb3MetadataProcessingDeployer.class);
    private static final String INPUT = AttachmentNames.MERGED_METADATA;
    public static final String OUTPUT = AttachmentNames.PROCESSED_METADATA;

    public Ejb3MetadataProcessingDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(INPUT);
        this.addOutput(OUTPUT);
    }

    public void deploy(DeploymentUnit du) throws DeploymentException {
        JBossMetaData md = (JBossMetaData)du.getAttachment(INPUT, JBossMetaData.class);
        if (md == null) {
            return;
        }
        if (!md.isEJB3x()) {
            return;
        }
        ProcessorChain chain = MetadataUtil.getPostMergeMetadataProcessorChain((ClassLoader)du.getClassLoader());
        JBossMetaData processedMetadata = chain.process(md);
        du.addAttachment(OUTPUT, (Object)processedMetadata, JBossMetaData.class);
    }
}

