/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management.recording;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.wsf.spi.management.recording.Record;
import org.jboss.wsf.spi.management.recording.RecordFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostFilter
implements RecordFilter {
    private static final long serialVersionUID = -5935962601380315102L;
    private List<String> hosts = new LinkedList<String>();
    private boolean source;

    public HostFilter(String host, boolean source) {
        this.hosts.add(host);
        this.source = source;
    }

    public HostFilter(Collection<String> hosts, boolean source) {
        this.hosts.addAll(hosts);
        this.source = source;
    }

    public boolean match(Record record) {
        for (String host : this.hosts) {
            if ((!this.source || !host.equalsIgnoreCase(record.getSourceHost())) && (this.source || !host.equalsIgnoreCase(record.getDestinationHost()))) continue;
            return true;
        }
        return false;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public boolean isSource() {
        return this.source;
    }

    public Object clone() throws CloneNotSupportedException {
        HostFilter retObj = (HostFilter)super.clone();
        retObj.hosts = new LinkedList<String>(this.hosts);
        retObj.source = this.source;
        return retObj;
    }
}

