/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.HashMap;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.GetTCLAction;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCEntityCommandMetaData {
    private final String commandName;
    private final Class commandClass;
    private final HashMap attributes = new HashMap();

    public JDBCEntityCommandMetaData(Element element) throws DeploymentException {
        this.commandName = element.getAttribute("name");
        if (this.commandName.trim().length() < 1) {
            throw new DeploymentException("entity-command element must have  not empty name attribute");
        }
        String commandClassStr = element.getAttribute("class");
        if (commandClassStr != null) {
            try {
                this.commandClass = GetTCLAction.getContextClassLoader().loadClass(commandClassStr);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load class: " + commandClassStr);
            }
        } else {
            this.commandClass = null;
        }
        Iterator iter = MetaData.getChildrenByTagName((Element)element, (String)"attribute");
        while (iter.hasNext()) {
            Element attrEl = (Element)iter.next();
            String attrName = attrEl.getAttribute("name");
            if (attrName == null) {
                throw new DeploymentException("entity-command " + this.commandName + " has an attribute with no name");
            }
            String attrValue = MetaData.getElementContent((Element)attrEl);
            this.attributes.put(attrName, attrValue);
        }
    }

    public JDBCEntityCommandMetaData(Element element, JDBCEntityCommandMetaData defaultValues) throws DeploymentException {
        this.commandName = defaultValues.getCommandName();
        String commandClassStr = element.getAttribute("class");
        if (commandClassStr != null && commandClassStr.trim().length() > 0) {
            try {
                this.commandClass = GetTCLAction.getContextClassLoader().loadClass(commandClassStr);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load class: " + commandClassStr);
            }
        } else {
            this.commandClass = defaultValues.getCommandClass();
        }
        this.attributes.putAll(defaultValues.attributes);
        Iterator iter = MetaData.getChildrenByTagName((Element)element, (String)"attribute");
        while (iter.hasNext()) {
            Element attrEl = (Element)iter.next();
            String attrName = attrEl.getAttribute("name");
            if (attrName == null) {
                throw new DeploymentException("entity-command " + this.commandName + " has an attribute with no name");
            }
            String attrValue = MetaData.getElementContent((Element)attrEl);
            this.attributes.put(attrName, attrValue);
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public Class getCommandClass() {
        return this.commandClass;
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public String toString() {
        return new StringBuffer("[commandName=").append(this.commandName).append(",commandClass=").append(this.commandClass).append(",attributes=").append(this.attributes.toString()).append("]").toString();
    }
}

