/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

interface SecurityActions {
    public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

        public Principal getPrincipal() {
            Principal p = null;
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc != null) {
                p = sc.getUtil().getUserPrincipal();
            }
            if (p == null && SecurityContextAssociation.isClient()) {
                p = SecurityAssociation.getPrincipal();
            }
            return p;
        }

        public Object getCredential() {
            Object cred = null;
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if (sc != null) {
                cred = sc.getUtil().getCredential();
            }
            if (cred == null && SecurityContextAssociation.isClient()) {
                cred = SecurityAssociation.getCredential();
            }
            return cred;
        }
    };
    public static final SecurityActions PRIVILEGED = new SecurityActions(){
        private final PrivilegedAction<Principal> getPrincipalAction = new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                Principal p = null;
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc != null) {
                    p = sc.getUtil().getUserPrincipal();
                }
                return p;
            }
        };
        private final PrivilegedAction<Object> getCredentialAction = new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object cred = null;
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc != null) {
                    cred = sc.getUtil().getCredential();
                }
                return cred;
            }
        };

        public Principal getPrincipal() {
            return AccessController.doPrivileged(this.getPrincipalAction);
        }

        public Object getCredential() {
            return AccessController.doPrivileged(this.getCredentialAction);
        }
    };

    public Principal getPrincipal();

    public Object getCredential();

    public static class UTIL {
        static SecurityActions getSecurityActions() {
            return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
        }
    }
}

