/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.capability;

import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import org.jboss.mx.capability.OptimizedMBeanDispatcher;
import org.jboss.mx.capability.ReflectedMBeanDispatcher;
import org.jboss.mx.metadata.AttributeOperationResolver;
import org.jboss.mx.metadata.MethodMapper;
import org.jboss.mx.server.ServerConstants;
import org.jboss.mx.util.PropertyAccess;

public class DispatcherFactory
implements ServerConstants {
    public static DynamicMBean create(MBeanInfo info, Object resource) throws IntrospectionException {
        return DispatcherFactory.create(info, resource, new AttributeOperationResolver(info));
    }

    public static DynamicMBean create(MBeanInfo info, Object resource, AttributeOperationResolver resolver) throws IntrospectionException {
        if (null == info) {
            throw new IllegalArgumentException("info cannot be null");
        }
        if (null == resolver) {
            throw new IllegalArgumentException("resolver cannot be null");
        }
        if (null == resource) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        MethodMapper mmap = new MethodMapper(resource.getClass());
        ReflectedMBeanDispatcher dispatcher = new ReflectedMBeanDispatcher(info, resolver, resource);
        String flag = PropertyAccess.getProperty((String)"jbossmx.optimized.dispatcher", (String)"false");
        if (flag.equalsIgnoreCase("true")) {
            dispatcher = OptimizedMBeanDispatcher.create(info, resource);
        }
        MBeanAttributeInfo[] attributes = info.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            ModelMBeanAttributeInfo mmbAttribute;
            Descriptor desc;
            MBeanAttributeInfo attribute = attributes[i];
            Method getter = null;
            Method setter = null;
            if (attribute.isReadable() && (attribute instanceof ModelMBeanAttributeInfo ? (desc = (mmbAttribute = (ModelMBeanAttributeInfo)attribute).getDescriptor()) != null && desc.getFieldValue("getMethod") != null && (getter = mmap.lookupGetter(mmbAttribute)) == null : (getter = mmap.lookupGetter(attribute)) == null)) {
                throw new IntrospectionException("no getter method found for attribute: " + attribute.getName());
            }
            if (attribute.isWritable() && (attribute instanceof ModelMBeanAttributeInfo ? (desc = (mmbAttribute = (ModelMBeanAttributeInfo)attribute).getDescriptor()) != null && desc.getFieldValue("setMethod") != null && (setter = mmap.lookupSetter(mmbAttribute)) == null : (setter = mmap.lookupSetter(attribute)) == null)) {
                throw new IntrospectionException("no setter method found for attribute: " + attribute.getName());
            }
            dispatcher.bindAttributeAt(i, getter, setter);
        }
        MBeanOperationInfo[] operations = info.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            MBeanOperationInfo operation = operations[i];
            Method method = mmap.lookupOperation(operation);
            if (method == null) {
                throw new IntrospectionException("no method found for operation: " + operation.getName());
            }
            dispatcher.bindOperationAt(i, method);
        }
        return dispatcher;
    }
}

