/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import java.io.Serializable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.mx.remoting.MBeanServerLocator;
import org.jboss.mx.remoting.MoveableMBean;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.loading.ClassUtil;

public class MBeanLocator
implements Serializable {
    static final long serialVersionUID = -95280512054710509L;
    private final Identity identity;
    private final ObjectName objectName;
    private final MBeanServerLocator locator;

    public MBeanLocator(MBeanServerLocator sl, ObjectName obj) {
        this.identity = sl.getIdentity();
        this.locator = sl;
        this.objectName = obj;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MBeanLocator)) {
            return false;
        }
        MBeanLocator mBeanLocator = (MBeanLocator)o;
        if (this.identity != null ? !this.identity.equals((Object)mBeanLocator.identity) : mBeanLocator.identity != null) {
            return false;
        }
        if (this.locator != null ? !this.locator.equals(mBeanLocator.locator) : mBeanLocator.locator != null) {
            return false;
        }
        return !(this.objectName != null ? !this.objectName.equals(mBeanLocator.objectName) : mBeanLocator.objectName != null);
    }

    public int hashCode() {
        int result = this.identity != null ? this.identity.hashCode() : 0;
        result = 29 * result + (this.objectName != null ? this.objectName.hashCode() : 0);
        result = 29 * result + (this.locator != null ? this.locator.hashCode() : 0);
        return result;
    }

    public MBeanServerLocator getServerLocator() {
        return this.locator;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public final ObjectName getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return "MBeanLocator [server:" + this.locator + ",mbean:" + this.objectName + "]";
    }

    public boolean isSameJVM(MBeanLocator locator) {
        return locator != null && locator.locator.equals(this.locator);
    }

    public Object narrow(Class interfaceCl) {
        Class[] cl = ClassUtil.getInterfacesFor((Class)interfaceCl);
        return this.narrow(cl);
    }

    public MBeanServer getMBeanServer() throws ConnectionFailedException {
        return this.locator.getMBeanServer();
    }

    public Object narrow(Class[] interfaces) {
        return MoveableMBean.create(this, interfaces);
    }
}

