/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.resource.adaptor.jdbc.vendor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.jboss.resource.adapter.jdbc.vendor.OracleValidConnectionChecker;
import org.jboss.util.NestedRuntimeException;

public class CMSValidConnectionChecker
extends OracleValidConnectionChecker {
    private static Object[] params = new Object[]{new Integer(0)};
    private transient Method ping;
    private static final long serialVersionUID = 5199234739135512329L;
    private static transient Logger log;

    public CMSValidConnectionChecker() {
        try {
            this.initPing();
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Unable to resolve pingDatabase method:", (Throwable)e);
        }
    }

    private void initPing() throws ClassNotFoundException, NoSuchMethodException {
        log = Logger.getLogger(CMSValidConnectionChecker.class);
        Class<?> oracleConnection = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.driver.OracleConnection");
        this.ping = oracleConnection.getMethod("pingDatabase", Integer.TYPE);
    }

    public SQLException isValidConnection(Connection c) {
        try {
            Integer status = (Integer)this.ping.invoke((Object)c, params);
            if (status == null || status < 0) {
                return new SQLException("pingDatabase failed status=" + status);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected error in pingDatabase", (Throwable)e);
        }
        return null;
    }
}

