/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.AccessControlContext;
import java.security.PrivilegedExceptionAction;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.action.SimpleControllerContextAction;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.dependency.BeanValidatorBridge;
import org.jboss.kernel.plugins.dependency.DispatchJoinPoint;
import org.jboss.kernel.plugins.dependency.ExecutionWrapper;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.stack.MetaDataStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelControllerContextAction
extends SimpleControllerContextAction<KernelControllerContext> {
    private static final Logger staticLog = Logger.getLogger(KernelControllerContextAction.class);
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    static Object dispatchJoinPoint(KernelControllerContext context, Joinpoint joinpoint) throws Throwable {
        JoinpointDispatchWrapper wrapper = new JoinpointDispatchWrapper(joinpoint);
        return KernelControllerContextAction.dispatchExecutionWrapper(context, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object dispatchExecutionWrapper(KernelControllerContext context, ExecutionWrapper wrapper) throws Throwable {
        KernelController controller;
        KernelMetaDataRepository repository;
        MetaData md;
        BeanMetaData metaData = context.getBeanMetaData();
        ClassLoader cl = Configurator.getClassLoader(metaData);
        AccessControlContext access = null;
        if (context instanceof AbstractKernelControllerContext) {
            AbstractKernelControllerContext theContext = (AbstractKernelControllerContext)context;
            access = theContext.getAccessControlContext();
        }
        if ((md = (repository = (controller = (KernelController)context.getController()).getKernel().getMetaDataRepository()).getMetaData(context)) != null) {
            MetaDataStack.push((MetaData)md);
        } else {
            staticLog.warn((Object)("NO METADATA! for " + context.getName() + " with scope " + context.getScopeInfo().getScope()));
        }
        try {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            try {
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                Object object = wrapper.execute(access);
                Thread.currentThread().setContextClassLoader(tcl);
                return object;
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(tcl);
                throw throwable;
            }
        }
        finally {
            if (md != null) {
                MetaDataStack.pop();
            }
        }
    }

    protected boolean validateContext(ControllerContext context) {
        return context instanceof AbstractKernelControllerContext;
    }

    protected KernelControllerContext contextCast(ControllerContext context) {
        return (KernelControllerContext)KernelControllerContext.class.cast(context);
    }

    public void installAction(KernelControllerContext context) throws Throwable {
        this.installActionInternal(context);
        this.setKernelControllerContext(context);
    }

    protected void setKernelControllerContext(KernelControllerContext context) throws Throwable {
        Class<? extends KernelControllerContextAware> awareInterface;
        Object target = context.getTarget();
        if (target != null && (awareInterface = this.getActionAwareInterface()) != null && !awareInterface.equals(KernelControllerContextAware.class) && awareInterface.isAssignableFrom(target.getClass())) {
            ((KernelControllerContextAware)target).setKernelControllerContext(context);
        }
    }

    protected void installActionInternal(KernelControllerContext context) throws Throwable {
    }

    protected Class<? extends KernelControllerContextAware> getActionAwareInterface() {
        return null;
    }

    public void uninstallAction(KernelControllerContext context) {
        this.unsetKernelControllerContext(context);
        this.uninstallActionInternal(context);
    }

    protected void uninstallActionInternal(KernelControllerContext context) {
    }

    protected void unsetKernelControllerContext(KernelControllerContext context) {
        Class<? extends KernelControllerContextAware> awareInterface;
        Object target = context.getTarget();
        if (target != null && (awareInterface = this.getActionAwareInterface()) != null && !awareInterface.equals(KernelControllerContextAware.class) && awareInterface.isAssignableFrom(target.getClass())) {
            try {
                ((KernelControllerContextAware)target).unsetKernelControllerContext(context);
            }
            catch (Exception ignored) {
                this.log.debug((Object)("Ignored error unsetting context " + context.getName()), (Throwable)ignored);
            }
        }
    }

    static BeanValidatorBridge getBeanValidatorBridge(KernelControllerContext context) {
        Controller controller = context.getController();
        if (controller == null) {
            return null;
        }
        ControllerContext bridge = controller.getInstalledContext(BeanValidatorBridge.class);
        return bridge != null ? (BeanValidatorBridge)BeanValidatorBridge.class.cast(bridge.getTarget()) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JoinpointDispatchWrapper
    extends ExecutionWrapper {
        private Joinpoint joinpoint;

        public JoinpointDispatchWrapper(Joinpoint joinpoint) {
            if (joinpoint == null) {
                throw new IllegalArgumentException("Null joinpoint");
            }
            this.joinpoint = joinpoint;
        }

        @Override
        protected Object execute() throws Throwable {
            return this.joinpoint.dispatch();
        }

        @Override
        protected PrivilegedExceptionAction<Object> getAction() {
            return new DispatchJoinPoint(this.joinpoint);
        }
    }
}

