/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss;

import java.util.HashSet;
import java.util.Set;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.CommitOption;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerConfigurationMetaDataWrapper
extends ContainerConfigurationMetaData {
    private static final long serialVersionUID = 1L;
    private transient ContainerConfigurationMetaData primary;
    private transient ContainerConfigurationMetaData defaults;

    ContainerConfigurationMetaDataWrapper(ContainerConfigurationMetaData primary, ContainerConfigurationMetaData defaults) {
        this.primary = primary;
        this.defaults = defaults;
    }

    @Override
    public Descriptions getDescriptions() {
        return this.primary.getDescriptions();
    }

    @Override
    public String getKey() {
        return this.primary.getKey();
    }

    @Override
    public String getName() {
        return this.primary.getName();
    }

    @Override
    public String getId() {
        return this.primary.getId();
    }

    @Override
    public ClusterConfigMetaData getClusterConfig() {
        ClusterConfigMetaData md = this.primary.getClusterConfig();
        if (md == null && this.defaults != null) {
            md = this.defaults.getClusterConfig();
        } else if (this.defaults != null) {
            md = new ClusterConfigMetaData();
            md.merge(this.primary.getClusterConfig(), this.defaults.getClusterConfig());
        }
        return md;
    }

    @Override
    public CommitOption getCommitOption() {
        CommitOption co;
        CommitOption commitOption = co = this.defaults != null ? this.defaults.getCommitOption() : CommitOption.A;
        if (this.primary.commitOptionWasSet()) {
            co = this.primary.getCommitOption();
        }
        return co;
    }

    @Override
    public Element getContainerCacheConf() {
        Element conf = this.primary.getContainerCacheConf();
        if (conf == null && this.defaults != null) {
            conf = this.defaults.getContainerCacheConf();
        }
        return conf;
    }

    @Override
    public Element getContainerInterceptors() {
        Element conf = this.primary.getContainerInterceptors();
        if (conf == null && this.defaults != null) {
            conf = this.defaults.getContainerInterceptors();
        }
        return conf;
    }

    @Override
    public String getContainerName() {
        return this.primary.getContainerName();
    }

    @Override
    public Element getContainerPoolConf() {
        Element conf = this.primary.getContainerPoolConf();
        if (conf == null && this.defaults != null) {
            conf = this.defaults.getContainerPoolConf();
        }
        return conf;
    }

    @Override
    public String getDefaultInvokerName() {
        String name = this.primary.getDefaultInvokerName();
        if (name == null && this.defaults != null) {
            name = this.defaults.getDefaultInvokerName();
        }
        if (name == null) {
            throw new IllegalStateException("No invokers defined");
        }
        return name;
    }

    @Override
    public Set<String> getDepends() {
        HashSet<String> depends = new HashSet<String>();
        if (this.primary.getDepends() != null) {
            depends.addAll(this.primary.getDepends());
        }
        if (this.defaults != null && this.defaults.getDepends() != null) {
            depends.addAll(this.defaults.getDepends());
        }
        return depends;
    }

    @Override
    public String getExtendsName() {
        return this.primary.getExtendsName();
    }

    @Override
    public String getInstanceCache() {
        String name = this.primary.getInstanceCache();
        if (name == null && this.defaults != null) {
            name = this.defaults.getInstanceCache();
        }
        return name;
    }

    @Override
    public String getInstancePool() {
        String name = this.primary.getInstancePool();
        if (name == null && this.defaults != null) {
            name = this.defaults.getInstancePool();
        }
        return name;
    }

    @Override
    public Set<String> getInvokerProxyBindingNames() {
        Set<String> names = this.primary.getInvokerProxyBindingNames();
        if ((names == null || names.isEmpty()) && this.defaults != null) {
            names = this.defaults.getInvokerProxyBindingNames();
        }
        return names;
    }

    @Override
    public String getLockingPolicy() {
        String name = this.primary.getLockingPolicy();
        if (name == null && this.defaults != null) {
            name = this.defaults.getLockingPolicy();
        }
        if (name == null) {
            name = "org.jboss.ejb.plugins.lock.QueuedPessimisticEJBLock";
        }
        return name;
    }

    @Override
    public int getOptiondRefreshRate() {
        int rate = (int)this.getOptiondRefreshRateMillis() / 1000;
        return rate;
    }

    @Override
    public long getOptiondRefreshRateMillis() {
        long rate = this.primary.getOptiondRefreshRateMillis();
        if (rate <= 0L && this.defaults != null) {
            rate = this.defaults.getOptiondRefreshRateMillis();
        }
        if (rate <= 0L) {
            rate = 30000L;
        }
        return rate;
    }

    @Override
    public String getPersistenceManager() {
        String name = this.primary.getPersistenceManager();
        if (name == null && this.defaults != null) {
            name = this.defaults.getPersistenceManager();
        }
        return name;
    }

    @Override
    public String getSecurityDomain() {
        String name = this.primary.getSecurityDomain();
        if (name == null && this.defaults != null) {
            name = this.defaults.getSecurityDomain();
        }
        return name;
    }

    @Override
    public String getWebClassLoader() {
        String name = this.primary.getWebClassLoader();
        if (name == null && this.defaults != null) {
            name = this.defaults.getWebClassLoader();
        }
        if (name == null) {
            name = "org.jboss.web.WebClassLoader";
        }
        return name;
    }

    @Override
    public boolean isCallLogging() {
        boolean flag;
        boolean bl = flag = this.defaults != null ? this.defaults.isCallLogging() : false;
        if (this.primary.callLoggingWasSet()) {
            flag = this.primary.isCallLogging();
        }
        return flag;
    }

    @Override
    public boolean isEjbStoreOnClean() {
        boolean flag;
        boolean bl = flag = this.defaults != null ? this.defaults.isEjbStoreOnClean() : false;
        if (this.primary.ejbStoreOnCleanWasSet()) {
            flag = this.primary.isEjbStoreOnClean();
        }
        return flag;
    }

    @Override
    public boolean isInsertAfterEjbPostCreate() {
        boolean flag;
        boolean bl = flag = this.defaults != null ? this.defaults.isInsertAfterEjbPostCreate() : false;
        if (this.primary.insertAfterEjbPostCreateWasSet()) {
            flag = this.primary.isInsertAfterEjbPostCreate();
        }
        return flag;
    }

    @Override
    public boolean isStoreNotFlushed() {
        boolean flag;
        boolean bl = flag = this.defaults != null ? this.defaults.isStoreNotFlushed() : true;
        if (this.primary.storeNotFlushedWasSet()) {
            flag = this.primary.isStoreNotFlushed();
        }
        return flag;
    }

    @Override
    public boolean isSyncOnCommitOnly() {
        boolean flag;
        boolean bl = flag = this.defaults != null ? this.defaults.isSyncOnCommitOnly() : false;
        if (this.primary.syncOnCommitOnlyWasSet()) {
            flag = this.primary.isSyncOnCommitOnly();
        }
        return flag;
    }
}

