/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitVisitor;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.helpers.ClassPathVisitor;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSClassLoaderClassPathDeployer
extends AbstractOptionalVFSRealDeployer<ClassLoadingMetaData> {
    public static String VFS_CLASS_PATH = "org.jboss.deployers.vfs.plugins.classloader.VFS_CLASS_PATH";
    public static String VFS_EXCLUDES = "org.jboss.deployers.vfs.plugins.classloader.VFS_EXCLUDES";

    public VFSClassLoaderClassPathDeployer() {
        super(ClassLoadingMetaData.class);
        this.setOutput(ClassLoadingMetaData.class);
        this.setStage(DeploymentStages.DESCRIBE);
    }

    public void deploy(VFSDeploymentUnit unit, ClassLoadingMetaData deployment) throws DeploymentException {
        boolean canSeeParent;
        if (!unit.isTopLevel() && deployment == null) {
            return;
        }
        List parentClassPath = null;
        Set parentExcludes = null;
        for (VFSDeploymentUnit parent = unit.getParent(); parent != null; parent = parent.getParent()) {
            parentClassPath = (List)parent.getAttachment(VFS_CLASS_PATH, List.class);
            if (parentClassPath == null) continue;
            parentExcludes = (Set)parent.getAttachment(VFS_EXCLUDES, Set.class);
            break;
        }
        ClassPathVisitor visitor = new ClassPathVisitor((DeploymentUnit)unit);
        unit.visit((DeploymentUnitVisitor)visitor);
        Set rawClassPath = visitor.getClassPath();
        ArrayList<VirtualFile> vfsClassPath = new ArrayList<VirtualFile>();
        unit.addAttachment(VFS_CLASS_PATH, vfsClassPath, List.class);
        HashSet vfsExcludes = new HashSet();
        unit.addAttachment(VFS_EXCLUDES, vfsExcludes, Set.class);
        boolean bl = canSeeParent = parentClassPath != null && deployment.getParentDomain() == null;
        if (rawClassPath != null) {
            for (VirtualFile file : rawClassPath) {
                if (vfsClassPath.contains(file) || canSeeParent && (!canSeeParent || parentClassPath.contains(file))) continue;
                vfsClassPath.add(file);
            }
        }
        if (parentClassPath != null) {
            VirtualFile root = unit.getRoot();
            if (root != null && !parentClassPath.contains(root)) {
                parentExcludes.add(root);
            }
            for (VirtualFile file : vfsClassPath) {
                if (parentClassPath.contains(file)) continue;
                parentExcludes.add(file);
            }
        }
    }

    public void undeploy(VFSDeploymentUnit unit, ClassLoadingMetaData deployment) {
        unit.removeAttachment(VFS_CLASS_PATH);
        unit.removeAttachment(VFS_EXCLUDES);
    }
}

