/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.CachedRecoveredTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.Enumeration;
import org.omg.CosTransactions.Status;

public class ServerTransactionRecoveryModule
extends TransactionRecoveryModule
implements RecoveryModule {
    public ServerTransactionRecoveryModule() {
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_1");
        }
        if (this._transactionType == null) {
            this._transactionType = ServerTransaction.typeName();
        }
    }

    public void periodicWorkFirstPass() {
        if (jtsLogger.loggerI18N.isInfoEnabled()) {
            jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_3");
        }
        super.periodicWorkFirstPass();
    }

    public void periodicWorkSecondPass() {
        if (jtsLogger.loggerI18N.isInfoEnabled()) {
            jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_4");
        }
        Enumeration transactionUidEnum = this._transactionUidVector.elements();
        while (transactionUidEnum.hasMoreElements()) {
            Uid currentUid = (Uid)transactionUidEnum.nextElement();
            try {
                if (_transactionStore.currentState(currentUid, this._transactionType) != 0) {
                    if (jtsLogger.loggerI18N.isInfoEnabled()) {
                        jtsLogger.loggerI18N.info("com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_5", new Object[]{currentUid});
                    }
                    this.recoverTransaction(currentUid);
                    continue;
                }
                if (!jtsLogger.loggerI18N.isDebugEnabled()) continue;
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_6", new Object[]{currentUid});
            }
            catch (ObjectStoreException e4) {
                if (!jtsLogger.loggerI18N.isDebugEnabled()) continue;
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_7", new Object[]{currentUid});
            }
        }
    }

    protected void initialise() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 2048L, "ServerTransactionRecoveryModule.initialise()");
        }
        super.initialise();
    }

    protected void recoverTransaction(Uid tranUid) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 2048L, "ServerTransactionRecoveryModule.recoverTransaction()" + tranUid + ")");
        }
        Status currentStatus = Status.StatusUnknown;
        CachedRecoveredTransaction cachedRecoveredTransaction = new CachedRecoveredTransaction(tranUid, this._transactionType);
        currentStatus = cachedRecoveredTransaction.get_status();
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_8", new Object[]{tranUid, Utility.stringStatus(currentStatus)});
        }
        if (cachedRecoveredTransaction.originalBusy() && currentStatus != Status.StatusPrepared) {
            if (jtsLogger.loggerI18N.isDebugEnabled()) {
                jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule_9", new Object[]{tranUid});
            }
            return;
        }
        cachedRecoveredTransaction.replayPhase2();
        cachedRecoveredTransaction = null;
    }
}

