/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.jpa.deployment.ManagedEntityManagerFactory;
import org.jboss.jpa.util.ManagedEntityManagerFactoryHelper;
import org.jboss.logging.Logger;

public class ExtendedPersistenceContextPropagationInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(ExtendedPersistenceContextPropagationInterceptor.class);

    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        log.debug((Object)"++++ LongLivedSessionPropagationInterceptor");
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
        Map<String, EntityManager> extendedPCs = ctx.getExtendedPersistenceContexts();
        if (extendedPCs == null || extendedPCs.size() == 0) {
            return invocation.invokeNext();
        }
        TransactionManager tm = TxUtil.getTransactionManager();
        if (tm.getTransaction() != null) {
            for (String kernelname : extendedPCs.keySet()) {
                EntityManager manager = extendedPCs.get(kernelname);
                ManagedEntityManagerFactory factory = ManagedEntityManagerFactoryHelper.getManagedEntityManagerFactory((String)kernelname);
                factory.registerExtendedWithTransaction(manager);
            }
        }
        return invocation.invokeNext();
    }
}

