/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.naming.InitialContext;
import org.jboss.aop.Advisor;
import org.jboss.aop.metadata.ClassMetaDataBinding;
import org.jboss.aop.metadata.ClassMetaDataLoader;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aop.util.XmlHelper;
import org.jboss.aspects.security.SecurityClassMetaDataBinding;
import org.jboss.aspects.security.SecurityConstructorConfig;
import org.jboss.aspects.security.SecurityMethodConfig;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;
import org.w3c.dom.Element;

public class SecurityClassMetaDataLoader
implements ClassMetaDataLoader {
    public ClassMetaDataBinding importMetaData(Element element, String name, String group, String classExpr) throws Exception {
        SecurityClassMetaDataBinding data = new SecurityClassMetaDataBinding(this, name, group, classExpr);
        ArrayList securityRoles = this.loadSecurityRoles(element);
        ArrayList methodPermissions = this.loadMethodPermissions(element);
        ArrayList methodExcludeList = this.loadMethodExcludeList(element);
        HashMap fieldPermissions = this.loadFieldPermissions(element);
        ArrayList fieldExcludeList = this.loadFieldExcludeList(element);
        ArrayList constructorPermissions = this.loadConstructorPermissions(element);
        ArrayList constructorExcludeList = this.loadConstructorExcludeList(element);
        String runAs = this.loadRunAs(element);
        String securityDomain = XmlHelper.getOptionalChildContent((Element)element, (String)"security-domain");
        if (securityDomain == null) {
            throw new RuntimeException("you must define a security-domain");
        }
        data.setSecurityDomain(securityDomain);
        data.setSecurityRoles(securityRoles);
        data.setMethodPermissions(methodPermissions);
        data.setMethodExcludeList(methodExcludeList);
        data.setFieldPermissions(fieldPermissions);
        data.setFieldExcludeList(fieldExcludeList);
        data.setConstructorPermissions(constructorPermissions);
        data.setConstructorExcludeList(constructorExcludeList);
        data.setRunAs(runAs);
        return data;
    }

    public void bind(Advisor advisor, ClassMetaDataBinding data, Method[] methods, Field[] fields, Constructor[] constructors) throws Exception {
        Set permissions;
        int i;
        SecurityClassMetaDataBinding meta = (SecurityClassMetaDataBinding)data;
        try {
            String securityDomain = "java:/jaas/" + meta.getSecurityDomain();
            Object domain = new InitialContext().lookup(securityDomain);
            advisor.getDefaultMetaData().addMetaData((Object)"security", (Object)"authentication-manager", domain, PayloadKey.TRANSIENT);
            advisor.getDefaultMetaData().addMetaData((Object)"security", (Object)"realm-mapping", domain, PayloadKey.TRANSIENT);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to load security domain: " + meta.getSecurityDomain(), ex);
        }
        for (i = 0; i < methods.length; ++i) {
            permissions = this.getMethodPermissions(methods[i], meta);
            if (permissions == null) continue;
            advisor.getMethodMetaData().addMethodMetaData(methods[i], (Object)"security", (Object)"roles", (Object)permissions, PayloadKey.TRANSIENT);
        }
        for (i = 0; i < fields.length; ++i) {
            permissions = this.getFieldPermissions(fields[i], meta);
            if (permissions == null) continue;
            advisor.getFieldMetaData().addFieldMetaData(fields[i], (Object)"security", (Object)"roles", (Object)permissions, PayloadKey.TRANSIENT);
        }
        for (i = 0; i < constructors.length; ++i) {
            permissions = this.getConstructorPermissions(constructors[i], meta);
            if (permissions == null) continue;
            advisor.getConstructorMetaData().addConstructorMetaData(constructors[i], (Object)"security", (Object)"roles", (Object)permissions, PayloadKey.TRANSIENT);
        }
        if (meta.getRunAs() != null) {
            advisor.getDefaultMetaData().addMetaData((Object)"security", (Object)"run-as", (Object)new RunAsIdentity(meta.getRunAs(), null), PayloadKey.TRANSIENT);
        }
    }

    public Set getMethodPermissions(Method method, SecurityClassMetaDataBinding meta) {
        HashSet<Object> result = new HashSet<Object>();
        for (SecurityMethodConfig m : meta.getMethodExcludeList()) {
            if (!m.patternMatches(method)) continue;
            result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            return result;
        }
        for (SecurityMethodConfig m : meta.getMethodPermissions()) {
            if (!m.patternMatches(method)) continue;
            if (m.isUnchecked()) {
                result.clear();
                result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
                break;
            }
            for (String roleName : m.getRoles()) {
                result.add(new SimplePrincipal(roleName));
            }
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    public Set getFieldPermissions(Field field, SecurityClassMetaDataBinding meta) {
        String fieldName = field.getName();
        HashSet<Object> result = new HashSet<Object>();
        for (String expr : meta.getFieldExcludeList()) {
            if (!expr.equals("*") && !expr.equals(fieldName)) continue;
            result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            return result;
        }
        for (String expr : meta.getFieldPermissions().keySet()) {
            if (!expr.equals("*") && !expr.equals(fieldName)) continue;
            Object permission = meta.getFieldPermissions().get(expr);
            if (permission instanceof Boolean) {
                result.clear();
                result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
                break;
            }
            Set roles = (Set)permission;
            for (String roleName : roles) {
                result.add(new SimplePrincipal(roleName));
            }
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    protected String loadRunAs(Element element) throws Exception {
        Element securityIdentityElement = XmlHelper.getOptionalChild((Element)element, (String)"security-identity");
        if (securityIdentityElement == null) {
            return null;
        }
        Element callerIdent = XmlHelper.getOptionalChild((Element)securityIdentityElement, (String)"use-caller-identity");
        Element runAs = XmlHelper.getOptionalChild((Element)securityIdentityElement, (String)"run-as");
        if (callerIdent == null && runAs == null) {
            throw new RuntimeException("security-identity: either use-caller-identity or run-as must be specified");
        }
        if (callerIdent != null && runAs != null) {
            throw new RuntimeException("security-identity: only one of use-caller-identity or run-as can be specified");
        }
        String runAsRoleName = null;
        if (runAs != null) {
            runAsRoleName = XmlHelper.getElementContent((Element)XmlHelper.getUniqueChild((Element)runAs, (String)"role-name"));
        }
        return runAsRoleName;
    }

    protected ArrayList loadSecurityRoles(Element assemblyDescriptor) throws Exception {
        ArrayList<String> securityRoles = new ArrayList<String>();
        Iterator iterator = XmlHelper.getChildrenByTagName((Element)assemblyDescriptor, (String)"security-role");
        while (iterator.hasNext()) {
            Element securityRole = (Element)iterator.next();
            try {
                String role = XmlHelper.getUniqueChildContent((Element)securityRole, (String)"role-name");
                securityRoles.add(role);
            }
            catch (Exception e) {
                throw new RuntimeException("Error in metadata for security-role: ", e);
            }
        }
        return securityRoles;
    }

    protected ArrayList loadMethodPermissions(Element assemblyDescriptor) throws Exception {
        ArrayList<SecurityMethodConfig> permissionMethods = new ArrayList<SecurityMethodConfig>();
        Iterator iterator = XmlHelper.getChildrenByTagName((Element)assemblyDescriptor, (String)"method-permission");
        while (iterator.hasNext()) {
            Element methodPermission = (Element)iterator.next();
            Element unchecked = XmlHelper.getOptionalChild((Element)methodPermission, (String)"unchecked");
            boolean isUnchecked = false;
            HashSet<String> roles = null;
            if (unchecked != null) {
                isUnchecked = true;
            } else {
                roles = new HashSet<String>();
                Iterator rolesIterator = XmlHelper.getChildrenByTagName((Element)methodPermission, (String)"role-name");
                while (rolesIterator.hasNext()) {
                    roles.add(XmlHelper.getElementContent((Element)((Element)rolesIterator.next())));
                }
                if (roles.size() == 0) {
                    throw new RuntimeException("An unchecked element in security metadata or one or more role-name elements must be specified in method-permission");
                }
            }
            Iterator methods = XmlHelper.getChildrenByTagName((Element)methodPermission, (String)"method");
            while (methods.hasNext()) {
                SecurityMethodConfig method = new SecurityMethodConfig();
                method.importXml((Element)methods.next());
                if (isUnchecked) {
                    method.setUnchecked();
                    permissionMethods.add(0, method);
                    continue;
                }
                method.setRoles(roles);
                permissionMethods.add(method);
            }
        }
        return permissionMethods;
    }

    protected ArrayList loadMethodExcludeList(Element assemblyDescriptor) throws Exception {
        ArrayList<SecurityMethodConfig> excluded = new ArrayList<SecurityMethodConfig>();
        Element excludeList = XmlHelper.getOptionalChild((Element)assemblyDescriptor, (String)"exclude-list");
        if (excludeList != null) {
            Iterator iterator = XmlHelper.getChildrenByTagName((Element)excludeList, (String)"method");
            while (iterator.hasNext()) {
                Element methodInf = (Element)iterator.next();
                SecurityMethodConfig method = new SecurityMethodConfig();
                method.importXml(methodInf);
                method.setExcluded();
                excluded.add(method);
            }
        }
        return excluded;
    }

    protected HashMap loadFieldPermissions(Element assemblyDescriptor) throws Exception {
        HashMap<String, Serializable> permissionFields = new HashMap<String, Serializable>();
        Iterator iterator = XmlHelper.getChildrenByTagName((Element)assemblyDescriptor, (String)"field-permission");
        while (iterator.hasNext()) {
            Element fieldPermission = (Element)iterator.next();
            Element unchecked = XmlHelper.getOptionalChild((Element)fieldPermission, (String)"unchecked");
            boolean isUnchecked = false;
            HashSet<String> roles = null;
            if (unchecked != null) {
                isUnchecked = true;
            } else {
                roles = new HashSet<String>();
                Iterator rolesIterator = XmlHelper.getChildrenByTagName((Element)fieldPermission, (String)"role-name");
                while (rolesIterator.hasNext()) {
                    roles.add(XmlHelper.getElementContent((Element)((Element)rolesIterator.next())));
                }
                if (roles.size() == 0) {
                    throw new RuntimeException("An unchecked element in security metadata or one or more role-name elements must be specified in field-permission");
                }
            }
            Iterator fields = XmlHelper.getChildrenByTagName((Element)fieldPermission, (String)"field");
            while (fields.hasNext()) {
                Element field = (Element)fields.next();
                String fieldName = XmlHelper.getElementContent((Element)XmlHelper.getUniqueChild((Element)field, (String)"field-name"));
                if (isUnchecked) {
                    permissionFields.put(fieldName, Boolean.TRUE);
                    continue;
                }
                Object permission = permissionFields.get(fieldName);
                if (permission != null && permission instanceof Boolean) continue;
                if (permission != null) {
                    Set curr = (Set)permission;
                    curr.addAll(roles);
                    continue;
                }
                permissionFields.put(fieldName, new HashSet(roles));
            }
        }
        return permissionFields;
    }

    protected ArrayList loadFieldExcludeList(Element assemblyDescriptor) throws Exception {
        ArrayList<String> excluded = new ArrayList<String>();
        Element excludeList = XmlHelper.getOptionalChild((Element)assemblyDescriptor, (String)"exclude-list");
        if (excludeList != null) {
            Iterator iterator = XmlHelper.getChildrenByTagName((Element)excludeList, (String)"field");
            while (iterator.hasNext()) {
                Element fieldInf = (Element)iterator.next();
                String fieldName = XmlHelper.getElementContent((Element)XmlHelper.getUniqueChild((Element)fieldInf, (String)"field-name"));
                excluded.add(fieldName);
            }
        }
        return excluded;
    }

    protected ArrayList loadConstructorPermissions(Element assemblyDescriptor) throws Exception {
        ArrayList<SecurityConstructorConfig> permissionConstructors = new ArrayList<SecurityConstructorConfig>();
        Iterator iterator = XmlHelper.getChildrenByTagName((Element)assemblyDescriptor, (String)"constructor-permission");
        while (iterator.hasNext()) {
            Element constructorPermission = (Element)iterator.next();
            Element unchecked = XmlHelper.getOptionalChild((Element)constructorPermission, (String)"unchecked");
            boolean isUnchecked = false;
            HashSet<String> roles = null;
            if (unchecked != null) {
                isUnchecked = true;
            } else {
                roles = new HashSet<String>();
                Iterator rolesIterator = XmlHelper.getChildrenByTagName((Element)constructorPermission, (String)"role-name");
                while (rolesIterator.hasNext()) {
                    roles.add(XmlHelper.getElementContent((Element)((Element)rolesIterator.next())));
                }
                if (roles.size() == 0) {
                    throw new RuntimeException("An unchecked element in security metadata or one or more role-name elements must be specified in constructor-permission");
                }
            }
            Iterator constructors = XmlHelper.getChildrenByTagName((Element)constructorPermission, (String)"constructor");
            while (constructors.hasNext()) {
                SecurityConstructorConfig constructor = new SecurityConstructorConfig();
                constructor.importXml((Element)constructors.next());
                if (isUnchecked) {
                    constructor.setUnchecked();
                    permissionConstructors.add(0, constructor);
                    continue;
                }
                constructor.setRoles(roles);
                permissionConstructors.add(constructor);
            }
        }
        return permissionConstructors;
    }

    protected ArrayList loadConstructorExcludeList(Element assemblyDescriptor) throws Exception {
        ArrayList<SecurityConstructorConfig> excluded = new ArrayList<SecurityConstructorConfig>();
        Element excludeList = XmlHelper.getOptionalChild((Element)assemblyDescriptor, (String)"exclude-list");
        if (excludeList != null) {
            Iterator iterator = XmlHelper.getChildrenByTagName((Element)excludeList, (String)"constructor");
            while (iterator.hasNext()) {
                Element constructorInf = (Element)iterator.next();
                SecurityConstructorConfig constructor = new SecurityConstructorConfig();
                constructor.importXml(constructorInf);
                constructor.setExcluded();
                excluded.add(constructor);
            }
        }
        return excluded;
    }

    public Set getConstructorPermissions(Constructor constructor, SecurityClassMetaDataBinding meta) {
        HashSet<Object> result = new HashSet<Object>();
        for (SecurityConstructorConfig m : meta.getConstructorExcludeList()) {
            if (!m.patternMatches(constructor)) continue;
            result.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            return result;
        }
        for (SecurityConstructorConfig m : meta.getConstructorPermissions()) {
            if (!m.patternMatches(constructor)) continue;
            if (m.isUnchecked()) {
                result.clear();
                result.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
                break;
            }
            for (String roleName : m.getRoles()) {
                result.add(new SimplePrincipal(roleName));
            }
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    public void bind(Advisor advisor, ClassMetaDataBinding data, CtMethod[] methods, CtField[] fields, CtConstructor[] constructors) throws Exception {
        boolean permissions;
        int i;
        SecurityClassMetaDataBinding meta = (SecurityClassMetaDataBinding)data;
        for (i = 0; i < methods.length; ++i) {
            permissions = this.getMethodPermissions(methods[i], meta);
            if (!permissions) continue;
            advisor.getMethodMetaData().addMethodMetaData(methods[i], (Object)"security", (Object)"roles", (Object)Boolean.TRUE, PayloadKey.TRANSIENT);
        }
        for (i = 0; i < fields.length; ++i) {
            permissions = this.getFieldPermissions(fields[i], meta);
            if (!permissions) continue;
            advisor.getFieldMetaData().addFieldMetaData(fields[i].getName(), (Object)"security", (Object)"roles", (Object)Boolean.TRUE, PayloadKey.TRANSIENT);
        }
        for (i = 0; i < constructors.length; ++i) {
            permissions = this.getConstructorPermissions(constructors[i], meta);
            if (!permissions) continue;
            advisor.getConstructorMetaData().addConstructorMetaData(constructors[i].getMethodInfo2().getDescriptor(), (Object)"security", (Object)"roles", (Object)Boolean.TRUE, PayloadKey.TRANSIENT);
        }
    }

    public boolean getMethodPermissions(CtMethod method, SecurityClassMetaDataBinding meta) throws Exception {
        for (SecurityMethodConfig m : meta.getMethodExcludeList()) {
            if (!m.patternMatches(method)) continue;
            return true;
        }
        for (SecurityMethodConfig m : meta.getMethodPermissions()) {
            if (!m.patternMatches(method)) continue;
            return true;
        }
        return false;
    }

    public boolean getFieldPermissions(CtField field, SecurityClassMetaDataBinding meta) {
        String fieldName = field.getName();
        for (String expr : meta.getFieldExcludeList()) {
            if (!expr.equals("*") && !expr.equals(fieldName)) continue;
            return true;
        }
        for (String expr : meta.getFieldPermissions().keySet()) {
            if (!expr.equals("*") && !expr.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean getConstructorPermissions(CtConstructor constructor, SecurityClassMetaDataBinding meta) throws NotFoundException {
        for (SecurityConstructorConfig m : meta.getConstructorExcludeList()) {
            if (!m.patternMatches(constructor)) continue;
            return true;
        }
        for (SecurityConstructorConfig m : meta.getConstructorPermissions()) {
            if (!m.patternMatches(constructor)) continue;
            return true;
        }
        return false;
    }
}

