/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.context.Context;
import javax.context.ContextNotActiveException;
import javax.context.CreationalContext;
import javax.event.Observer;
import javax.inject.AmbiguousDependencyException;
import javax.inject.BindingType;
import javax.inject.DeploymentException;
import javax.inject.DuplicateBindingTypeException;
import javax.inject.Production;
import javax.inject.Standard;
import javax.inject.TypeLiteral;
import javax.inject.UnproxyableDependencyException;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;
import javax.inject.manager.Decorator;
import javax.inject.manager.InjectionPoint;
import javax.inject.manager.InterceptionType;
import javax.inject.manager.Interceptor;
import javax.inject.manager.Manager;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.WebBean;
import org.jboss.webbeans.bean.DisposalMethodBean;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.NewEnterpriseBean;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bean.proxy.ClientProxyProvider;
import org.jboss.webbeans.bootstrap.api.ServiceRegistry;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.CreationalContextImpl;
import org.jboss.webbeans.el.Namespace;
import org.jboss.webbeans.event.EventManager;
import org.jboss.webbeans.event.EventObserver;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.injection.NonContextualInjector;
import org.jboss.webbeans.injection.resolution.ResolvableAnnotatedClass;
import org.jboss.webbeans.injection.resolution.Resolver;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.manager.api.WebBeansManager;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Reflections;
import org.jboss.webbeans.util.collections.ConcurrentList;
import org.jboss.webbeans.util.collections.multi.ConcurrentListHashMultiMap;
import org.jboss.webbeans.util.collections.multi.ConcurrentListMultiMap;
import org.jboss.webbeans.util.collections.multi.ConcurrentSetHashMultiMap;
import org.jboss.webbeans.util.collections.multi.ConcurrentSetMultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerImpl
implements WebBeansManager,
Serializable {
    private static final Log log = Logging.getLog(ManagerImpl.class);
    private static final long serialVersionUID = 3021562879133838561L;
    public static final String JNDI_KEY = "java:app/Manager";
    private final transient ExecutorService taskExecutor = Executors.newSingleThreadExecutor();
    private final transient ServiceRegistry services;
    private transient List<Class<? extends Annotation>> enabledDeploymentTypes;
    private final transient ConcurrentListMultiMap<Class<? extends Annotation>, Context> contexts;
    private final transient Set<CurrentActivity> currentActivities;
    private final transient ClientProxyProvider clientProxyProvider;
    private final transient Map<Class<?>, EnterpriseBean<?>> newEnterpriseBeans;
    private final transient Map<String, RIBean<?>> riBeans;
    private final transient Map<Bean<?>, Bean<?>> specializedBeans;
    private final transient AtomicInteger ids;
    private final transient EventManager eventManager;
    private final transient Resolver resolver;
    private final transient NonContextualInjector nonContextualInjector;
    private final transient ThreadLocal<Stack<InjectionPoint>> currentInjectionPoint;
    private transient List<Bean<?>> beans;
    private final transient Namespace rootNamespace;
    private final transient ConcurrentSetMultiMap<Type, EventObserver<?>> registeredObservers;
    private final transient Set<ManagerImpl> childActivities;
    private final Integer id;

    public static ManagerImpl newRootManager(ServiceRegistry serviceRegistry) {
        ArrayList<Class<? extends Annotation>> defaultEnabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>();
        defaultEnabledDeploymentTypes.add(0, Standard.class);
        defaultEnabledDeploymentTypes.add(1, Production.class);
        return new ManagerImpl(serviceRegistry, new CopyOnWriteArrayList(), new ConcurrentSetHashMultiMap(), new Namespace(), new ConcurrentHashMap(), new ConcurrentHashMap(), new ClientProxyProvider(), new ConcurrentListHashMultiMap<Class<? extends Annotation>, Context>(), new CopyOnWriteArraySet<CurrentActivity>(), new HashMap(), defaultEnabledDeploymentTypes, new AtomicInteger());
    }

    public static ManagerImpl newChildManager(ManagerImpl parentManager) {
        CopyOnWriteArrayList beans = new CopyOnWriteArrayList();
        beans.addAll(parentManager.getBeans());
        ConcurrentSetHashMultiMap registeredObservers = new ConcurrentSetHashMultiMap();
        registeredObservers.deepPutAll(parentManager.getRegisteredObservers());
        Namespace rootNamespace = new Namespace(parentManager.getRootNamespace());
        return new ManagerImpl(parentManager.getServices(), beans, registeredObservers, rootNamespace, parentManager.getNewEnterpriseBeanMap(), parentManager.getRiBeans(), parentManager.getClientProxyProvider(), parentManager.getContexts(), parentManager.getCurrentActivities(), parentManager.getSpecializedBeans(), parentManager.getEnabledDeploymentTypes(), parentManager.getIds());
    }

    private ManagerImpl(ServiceRegistry serviceRegistry, List<Bean<?>> beans, ConcurrentSetMultiMap<Type, EventObserver<?>> registeredObservers, Namespace rootNamespace, Map<Class<?>, EnterpriseBean<?>> newEnterpriseBeans, Map<String, RIBean<?>> riBeans, ClientProxyProvider clientProxyProvider, ConcurrentListMultiMap<Class<? extends Annotation>, Context> contexts, Set<CurrentActivity> currentActivities, Map<Bean<?>, Bean<?>> specializedBeans, List<Class<? extends Annotation>> enabledDeploymentTypes, AtomicInteger ids) {
        this.services = serviceRegistry;
        this.beans = beans;
        this.newEnterpriseBeans = newEnterpriseBeans;
        this.riBeans = riBeans;
        this.clientProxyProvider = clientProxyProvider;
        this.contexts = contexts;
        this.currentActivities = currentActivities;
        this.specializedBeans = specializedBeans;
        this.registeredObservers = registeredObservers;
        this.setEnabledDeploymentTypes(enabledDeploymentTypes);
        this.rootNamespace = rootNamespace;
        this.ids = ids;
        this.id = ids.incrementAndGet();
        this.resolver = new Resolver(this);
        this.eventManager = new EventManager(this);
        this.nonContextualInjector = new NonContextualInjector(this);
        this.childActivities = new CopyOnWriteArraySet<ManagerImpl>();
        this.currentInjectionPoint = new ThreadLocal<Stack<InjectionPoint>>(){

            @Override
            protected Stack<InjectionPoint> initialValue() {
                return new Stack<InjectionPoint>();
            }
        };
    }

    protected void checkEnabledDeploymentTypes() {
        if (!this.enabledDeploymentTypes.get(0).equals(Standard.class)) {
            throw new DeploymentException("@Standard must be the lowest precedence deployment type");
        }
    }

    protected void addWebBeansDeploymentTypes() {
        if (!this.enabledDeploymentTypes.contains(WebBean.class)) {
            this.enabledDeploymentTypes.add(1, WebBean.class);
        }
    }

    public Manager addBean(Bean<?> bean) {
        if (this.beans.contains(bean)) {
            return this;
        }
        this.resolver.clear();
        this.beans.add(bean);
        this.registerBeanNamespace(bean);
        for (ManagerImpl childActivity : this.childActivities) {
            childActivity.addBean(bean);
        }
        return this;
    }

    public <T> Set<DisposalMethodBean<T>> resolveDisposalBeans(Class<T> apiType, Annotation ... bindings) {
        Set<Bean<T>> beans = this.resolveByType(apiType, bindings);
        HashSet<DisposalMethodBean<T>> disposalBeans = new HashSet<DisposalMethodBean<T>>();
        for (Bean<T> bean : beans) {
            if (!(bean instanceof DisposalMethodBean)) continue;
            disposalBeans.add((DisposalMethodBean)bean);
        }
        return disposalBeans;
    }

    public <T> Set<Observer<T>> resolveObservers(T event, Annotation ... bindings) {
        Class<?> clazz = event.getClass();
        for (Annotation annotation : bindings) {
            if (((MetaDataCache)this.getServices().get(MetaDataCache.class)).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        HashSet<Annotation> bindingAnnotations = new HashSet<Annotation>(Arrays.asList(bindings));
        if (bindingAnnotations.size() < bindings.length) {
            throw new DuplicateBindingTypeException("Duplicate binding types: " + bindings);
        }
        this.checkEventType(clazz);
        return this.eventManager.getObservers(event, bindings);
    }

    private void checkEventType(Type eventType) {
        Type[] types;
        if (eventType instanceof Class) {
            types = Reflections.getActualTypeArguments((Class)eventType);
        } else if (eventType instanceof ParameterizedType) {
            types = ((ParameterizedType)eventType).getActualTypeArguments();
        } else {
            throw new IllegalArgumentException("Event type " + eventType + " isn't a concrete type");
        }
        for (Type type : types) {
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException("Cannot provide an event type parameterized with a wildcard " + eventType);
            }
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot provide an event type parameterized with a type parameter " + eventType);
        }
    }

    public List<Class<? extends Annotation>> getEnabledDeploymentTypes() {
        return Collections.unmodifiableList(this.enabledDeploymentTypes);
    }

    public void setEnabledDeploymentTypes(List<Class<? extends Annotation>> enabledDeploymentTypes) {
        this.enabledDeploymentTypes = new ArrayList<Class<? extends Annotation>>(enabledDeploymentTypes);
        this.checkEnabledDeploymentTypes();
        this.addWebBeansDeploymentTypes();
    }

    public <T> Set<Bean<T>> resolveByType(Class<T> type, Annotation ... bindings) {
        return this.resolveByType(ResolvableAnnotatedClass.of(type, bindings), bindings);
    }

    public <T> Set<Bean<T>> resolveByType(TypeLiteral<T> type, Annotation ... bindings) {
        return this.resolveByType(ResolvableAnnotatedClass.of(type, bindings), bindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Set<Bean<T>> resolveByType(AnnotatedItem<T, ?> element, InjectionPoint injectionPoint, Annotation ... bindings) {
        boolean registerInjectionPoint = !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            Set<Bean<T>> set = this.resolveByType(element, bindings);
            return set;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    public <T> Set<Bean<T>> resolveByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        for (Annotation annotation : element.getAnnotationsAsSet()) {
            if (((MetaDataCache)this.getServices().get(MetaDataCache.class)).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        for (Type type : element.getActualTypeArguments()) {
            if (type instanceof WildcardType) {
                throw new IllegalArgumentException("Cannot resolve a type parameterized with a wildcard " + element);
            }
            if (!(type instanceof TypeVariable)) continue;
            throw new IllegalArgumentException("Cannot resolve a type parameterized with a type parameter " + element);
        }
        if (bindings.length > element.getMetaAnnotations(BindingType.class).size()) {
            throw new DuplicateBindingTypeException("Duplicate bindings (" + Arrays.asList(bindings) + ") type passed " + element.toString());
        }
        return this.resolver.get(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeans(Set<RIBean<?>> beans) {
        Set<RIBean<?>> set = beans;
        synchronized (set) {
            this.beans = new CopyOnWriteArrayList(beans);
            for (RIBean<?> bean : beans) {
                if (bean instanceof NewEnterpriseBean) {
                    this.newEnterpriseBeans.put(bean.getType(), (EnterpriseBean)bean);
                }
                this.riBeans.put(bean.getId(), bean);
                this.registerBeanNamespace(bean);
            }
            this.resolver.clear();
        }
    }

    protected void registerBeanNamespace(Bean<?> bean) {
        if (bean.getName() != null && bean.getName().indexOf(46) > 0) {
            String name = bean.getName().substring(0, bean.getName().lastIndexOf(46));
            String[] hierarchy = name.split("\\.");
            Namespace namespace = this.getRootNamespace();
            for (String s : hierarchy) {
                namespace = namespace.putIfAbsent(s);
            }
        }
    }

    public Map<Class<?>, EnterpriseBean<?>> getNewEnterpriseBeanMap() {
        return this.newEnterpriseBeans;
    }

    public List<Bean<?>> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    public Map<String, RIBean<?>> getRiBeans() {
        return Collections.unmodifiableMap(this.riBeans);
    }

    public Manager addContext(Context context) {
        this.contexts.put(context.getScopeType(), context);
        return this;
    }

    public Manager addDecorator(Decorator decorator) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Manager addInterceptor(Interceptor interceptor) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public <T> Manager addObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        return this.addObserverByType(observer, eventType, bindings);
    }

    public <T> Manager addObserver(ObserverImpl<T> observer) {
        return this.addObserverByType(observer, observer.getEventType(), observer.getBindingsAsArray());
    }

    public <T> Manager addObserver(Observer<T> observer, TypeLiteral<T> eventType, Annotation ... bindings) {
        return this.addObserverByType(observer, eventType.getType(), bindings);
    }

    public <T> Manager addObserverByType(Observer<T> observer, Type eventType, Annotation ... bindings) {
        this.checkEventType(eventType);
        this.eventManager.addObserver(observer, eventType, bindings);
        for (ManagerImpl childActivity : this.childActivities) {
            childActivity.addObserverByType(observer, eventType, bindings);
        }
        return this;
    }

    public void fireEvent(Object event, Annotation ... bindings) {
        if (Reflections.isParameterizedType(event.getClass())) {
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " is not allowed because it is a generic");
        }
        for (Annotation binding : bindings) {
            if (Reflections.isBindings(binding)) continue;
            throw new IllegalArgumentException("Event type " + event.getClass().getName() + " cannot be fired with non-binding type " + binding.getClass().getName() + " specified");
        }
        Set observers = this.resolveObservers(event, bindings);
        this.eventManager.notifyObservers(observers, event);
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        ArrayList<Context> activeContexts = new ArrayList<Context>();
        for (Context context : (ConcurrentList)this.contexts.get(scopeType)) {
            if (!context.isActive()) continue;
            activeContexts.add(context);
        }
        if (activeContexts.isEmpty()) {
            throw new ContextNotActiveException("No active contexts for scope type " + scopeType.getName());
        }
        if (activeContexts.size() > 1) {
            throw new IllegalStateException("More than one context active for scope type " + scopeType.getName());
        }
        return (Context)activeContexts.iterator().next();
    }

    public <T> T getInstance(Bean<T> bean) {
        return this.getInstance(bean, true);
    }

    public <T> T getInstance(Bean<T> bean, boolean create) {
        if (create) {
            return this.getInstance(bean, new CreationalContextImpl<T>(bean));
        }
        return this.getInstance(bean, null);
    }

    private <T> T getInstance(Bean<T> bean, CreationalContextImpl<T> creationalContext) {
        if (this.specializedBeans.containsKey(bean)) {
            return (T)this.getInstance(this.specializedBeans.get(bean), creationalContext);
        }
        if (((MetaDataCache)this.getServices().get(MetaDataCache.class)).getScopeModel(bean.getScopeType()).isNormal()) {
            if (creationalContext != null || creationalContext == null && this.getContext(bean.getScopeType()).get(bean) != null) {
                return this.clientProxyProvider.getClientProxy(this, bean);
            }
            return null;
        }
        return (T)this.getContext(bean.getScopeType()).get(bean, creationalContext);
    }

    public <T> T getInstanceToInject(InjectionPoint injectionPoint) {
        return this.getInstanceToInject(injectionPoint, null);
    }

    public void injectNonContextualInstance(Object instance) {
        this.nonContextualInjector.inject(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstanceToInject(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        boolean registerInjectionPoint = !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            ResolvableAnnotatedClass element = ResolvableAnnotatedClass.of(injectionPoint.getType(), injectionPoint.getBindings().toArray(new Annotation[0]));
            Bean<T> resolvedBean = this.getBeanByType(element, element.getBindingsAsArray());
            if (((MetaDataCache)this.getServices().get(MetaDataCache.class)).getScopeModel(resolvedBean.getScopeType()).isNormal() && !Proxies.isTypeProxyable(injectionPoint.getType())) {
                throw new UnproxyableDependencyException("Attempting to inject an unproxyable normal scoped bean " + resolvedBean + " into " + injectionPoint);
            }
            if (creationalContext instanceof CreationalContextImpl) {
                CreationalContextImpl ctx = (CreationalContextImpl)creationalContext;
                if (ctx.containsIncompleteInstance(resolvedBean)) {
                    T t = ctx.getIncompleteInstance(resolvedBean);
                    return t;
                }
                T t = this.getInstance(resolvedBean, ctx.getCreationalContext(resolvedBean));
                return t;
            }
            T t = this.getInstance(resolvedBean);
            return t;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    public Object getInstanceByName(String name) {
        Set<Bean<?>> beans = this.resolveByName(name);
        if (beans.size() == 0) {
            return null;
        }
        if (beans.size() > 1) {
            throw new AmbiguousDependencyException("Resolved multiple Web Beans with " + name);
        }
        return this.getInstance(beans.iterator().next());
    }

    public <T> T getInstanceByType(Class<T> type, Annotation ... bindings) {
        return this.getInstanceByType(ResolvableAnnotatedClass.of(type, bindings), bindings);
    }

    public <T> T getInstanceByType(TypeLiteral<T> type, Annotation ... bindings) {
        return this.getInstanceByType(ResolvableAnnotatedClass.of(type, bindings), bindings);
    }

    public <T> T getInstanceByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        return this.getInstance(this.getBeanByType(element, bindings));
    }

    public <T> Bean<T> getBeanByType(AnnotatedItem<T, ?> element, Annotation ... bindings) {
        Set<Bean<T>> beans = this.resolveByType(element, bindings);
        if (beans.size() == 0) {
            throw new UnsatisfiedDependencyException(element + "Unable to resolve any Web Beans");
        }
        if (beans.size() > 1) {
            throw new AmbiguousDependencyException(element + "Resolved multiple Web Beans");
        }
        Bean<T> bean = beans.iterator().next();
        boolean normalScoped = ((MetaDataCache)this.getServices().get(MetaDataCache.class)).getScopeModel(bean.getScopeType()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableDependencyException("Normal scoped bean " + bean + " is not proxyable");
        }
        return bean;
    }

    public <T> Manager removeObserver(Observer<T> observer, Class<T> eventType, Annotation ... bindings) {
        this.eventManager.removeObserver(observer, eventType, bindings);
        return this;
    }

    public <T> Manager removeObserver(Observer<T> observer, TypeLiteral<T> eventType, Annotation ... bindings) {
        this.eventManager.removeObserver(observer, eventType.getRawType(), bindings);
        return this;
    }

    public Set<Bean<?>> resolveByName(String name) {
        return this.resolver.get(name);
    }

    public List<Decorator> resolveDecorators(Set<Type> types, Annotation ... bindings) {
        throw new UnsupportedOperationException();
    }

    public List<Interceptor> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        throw new UnsupportedOperationException();
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Manager\n");
        buffer.append("Enabled deployment types: " + this.getEnabledDeploymentTypes() + "\n");
        buffer.append("Registered contexts: " + this.contexts.keySet() + "\n");
        buffer.append("Registered beans: " + this.getBeans().size() + "\n");
        buffer.append("Specialized beans: " + this.specializedBeans.size() + "\n");
        return buffer.toString();
    }

    public Manager parse(InputStream xmlStream) {
        throw new UnsupportedOperationException();
    }

    public ManagerImpl createActivity() {
        ManagerImpl childActivity = ManagerImpl.newChildManager(this);
        this.childActivities.add(childActivity);
        CurrentManager.add(childActivity);
        return childActivity;
    }

    public ManagerImpl setCurrent(Class<? extends Annotation> scopeType) {
        if (!((MetaDataCache)this.getServices().get(MetaDataCache.class)).getScopeModel(scopeType).isNormal()) {
            throw new IllegalArgumentException("Scope must be a normal scope type " + scopeType);
        }
        this.currentActivities.add(new CurrentActivity(this.getContext(scopeType), this));
        return this;
    }

    public ManagerImpl getCurrent() {
        ArrayList<CurrentActivity> activeCurrentActivities = new ArrayList<CurrentActivity>();
        for (CurrentActivity currentActivity : this.currentActivities) {
            if (!currentActivity.getContext().isActive()) continue;
            activeCurrentActivities.add(currentActivity);
        }
        if (activeCurrentActivities.size() == 0) {
            return CurrentManager.rootManager();
        }
        if (activeCurrentActivities.size() == 1) {
            return ((CurrentActivity)activeCurrentActivities.get(0)).getManager();
        }
        throw new IllegalStateException("More than one current activity for an active context " + this.currentActivities);
    }

    public ServiceRegistry getServices() {
        return this.services;
    }

    public InjectionPoint getInjectionPoint() {
        if (!this.currentInjectionPoint.get().empty()) {
            return this.currentInjectionPoint.get().peek();
        }
        return null;
    }

    public Map<Bean<?>, Bean<?>> getSpecializedBeans() {
        return this.specializedBeans;
    }

    protected Object readResolve() {
        return CurrentManager.get(this.id);
    }

    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public void shutdown() {
        log.trace((Object)"Ending application", new Object[0]);
        this.shutdownExecutors();
        ApplicationContext.instance().destroy();
        ApplicationContext.instance().setActive(false);
        ApplicationContext.instance().setBeanStore(null);
        CurrentManager.cleanup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void shutdownExecutors() {
        this.taskExecutor.shutdown();
        try {
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
            this.taskExecutor.shutdownNow();
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException ie) {
            this.taskExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected ClientProxyProvider getClientProxyProvider() {
        return this.clientProxyProvider;
    }

    protected ConcurrentListMultiMap<Class<? extends Annotation>, Context> getContexts() {
        return this.contexts;
    }

    protected AtomicInteger getIds() {
        return this.ids;
    }

    protected Set<CurrentActivity> getCurrentActivities() {
        return this.currentActivities;
    }

    public Integer getId() {
        return this.id;
    }

    public ConcurrentSetMultiMap<Type, EventObserver<?>> getRegisteredObservers() {
        return this.registeredObservers;
    }

    public Namespace getRootNamespace() {
        return this.rootNamespace;
    }

    private static class CurrentActivity {
        private final Context context;
        private final ManagerImpl manager;

        public CurrentActivity(Context context, ManagerImpl manager) {
            this.context = context;
            this.manager = manager;
        }

        public Context getContext() {
            return this.context;
        }

        public ManagerImpl getManager() {
            return this.manager;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CurrentActivity) {
                return this.getContext().equals(((CurrentActivity)obj).getContext());
            }
            return false;
        }

        public int hashCode() {
            return this.getContext().hashCode();
        }

        public String toString() {
            return this.getContext() + " -> " + this.getManager();
        }
    }
}

