/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datatype.response;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.i18n.RegistryResourceBundle;

public class Result
implements RegistryObject {
    public static final int E_ASSERTION_NOT_FOUND = 30000;
    public static final int E_AUTH_TOKEN_EXPIRED = 10110;
    public static final int E_AUTH_TOKEN_REQUIRED = 10120;
    public static final int E_ACCOUNT_LIMIT_EXCEEDED = 10160;
    public static final int E_BUSY = 10400;
    public static final int E_CATEGORIZATION_NOT_ALLOWED = 20100;
    public static final int E_FATAL_ERROR = 10500;
    public static final int E_INVALID_KEY_PASSED = 10210;
    public static final int E_INVALID_PROJECTION = 20230;
    public static final int E_INVALID_CATEGORY = 20000;
    public static final int E_INVALID_COMPLETION_STATUS = 30100;
    public static final int E_INVALID_URL_PASSED = 10220;
    public static final int E_INVALID_VALUE = 20200;
    public static final int E_KEY_RETIRED = 10310;
    public static final int E_LANGUAGE_ERROR = 10060;
    public static final int E_MESSAGE_TOO_LARGE = 30110;
    public static final int E_NAME_TOO_LONG = 10020;
    public static final int E_OPERATOR_MISMATCH = 10130;
    public static final int E_PUBLISHER_CANCELLED = 30220;
    public static final int E_REQUEST_DENIED = 30210;
    public static final int E_SECRET_UNKNOWN = 30230;
    public static final int E_SUCCESS = 0;
    public static final int E_TOO_MANY_OPTIONS = 10030;
    public static final int E_TRANSFER_ABORTED = 30200;
    public static final int E_UNRECOGNIZED_VERSION = 10040;
    public static final int E_UNKNOWN_USER = 10150;
    public static final int E_UNSUPPORTED = 10050;
    public static final int E_USER_MISMATCH = 10140;
    public static final int E_VALUE_NOT_ALLOWED = 20210;
    public static final int E_UNVALIDATABLE = 20220;
    public static final int E_REQUEST_TIMEOUT = 20240;
    public static final int E_INVALID_TIME = 40030;
    public static final int E_RESULT_SET_TOO_LARGE = 40300;
    int errno;
    ErrInfo errInfo;

    public Result() {
    }

    public Result(int errno) {
        this.setErrno(errno);
    }

    public Result(int errno, ErrInfo errInfo) {
        this.errno = errno;
        this.errInfo = errInfo;
    }

    public Result(int errno, String errCode, String errMsg) {
        this.errno = errno;
        this.errInfo = new ErrInfo(errCode, errMsg);
    }

    public void setErrno(int nmbr) {
        this.errno = nmbr;
    }

    public void setErrno(String nmbr) {
        Integer integer = new Integer(nmbr);
        this.errno = integer;
    }

    public int getErrno() {
        return this.errno;
    }

    public void setErrInfo(ErrInfo info) {
        this.errInfo = info;
    }

    public ErrInfo getErrInfo() {
        return this.errInfo;
    }

    public void setErrCode(String errCode) {
        if (this.errInfo == null) {
            this.errInfo = new ErrInfo();
        }
        this.errInfo.setErrCode(errCode);
    }

    public String getErrCode() {
        if (this.errInfo == null) {
            return null;
        }
        return this.errInfo.getErrCode();
    }

    public void setErrText(String errText) {
        if (this.errInfo == null) {
            this.errInfo = new ErrInfo();
        }
        this.errInfo.setErrMsg(errText);
    }

    public String getErrText() {
        if (this.errInfo == null) {
            return null;
        }
        return this.errInfo.getErrMsg();
    }

    public String toString() {
        if (this.errInfo == null) {
            return String.valueOf(this.errno);
        }
        StringBuffer buffer = new StringBuffer();
        String errCode = this.errInfo.getErrCode();
        if (errCode != null) {
            buffer.append(errCode);
            buffer.append(" ");
        }
        buffer.append("(");
        buffer.append(this.errno);
        buffer.append(") ");
        String errText = this.errInfo.getErrMsg();
        if (errText != null) {
            buffer.append(errText);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public static final String lookupErrCode(int errno) {
        switch (errno) {
            case 10160: {
                return "E_accountLimitExceeded";
            }
            case 30000: {
                return "E_assertionNotFound";
            }
            case 10110: {
                return "E_authTokenExpired";
            }
            case 10120: {
                return "E_authTokenRequired";
            }
            case 10400: {
                return "E_busy";
            }
            case 20100: {
                return "E_categorizationNotAllowed";
            }
            case 10500: {
                return "E_fatalError";
            }
            case 20000: {
                return "E_invalidCategory";
            }
            case 30100: {
                return "E_invalidCompletionStatus";
            }
            case 10210: {
                return "E_invalidKeyPassed";
            }
            case 20230: {
                return "E_invalidProjection";
            }
            case 40030: {
                return "E_invalidTime";
            }
            case 10220: {
                return "E_invalidURLPassed";
            }
            case 20200: {
                return "E_invalidValue";
            }
            case 10310: {
                return "E_keyRetired";
            }
            case 10060: {
                return "E_languageError";
            }
            case 30110: {
                return "E_messageTooLarge";
            }
            case 10020: {
                return "E_nameTooLong";
            }
            case 10130: {
                return "E_operatorMismatch";
            }
            case 30220: {
                return "E_publisherCancelled";
            }
            case 30210: {
                return "E_requestDenied";
            }
            case 20240: {
                return "E_requestTimeout";
            }
            case 40300: {
                return "E_resultSetTooLarge";
            }
            case 30230: {
                return "E_secretUnknown";
            }
            case 0: {
                return "E_success";
            }
            case 10030: {
                return "E_tooManyOptions";
            }
            case 30200: {
                return "E_transferAborted";
            }
            case 10150: {
                return "E_unknownUser";
            }
            case 10040: {
                return "E_unrecognizedVersion";
            }
            case 10050: {
                return "E_unsupported";
            }
            case 20220: {
                return "E_unvalidatable";
            }
            case 10140: {
                return "E_userMismatch";
            }
            case 20210: {
                return "E_valueNotAllowed";
            }
        }
        return null;
    }

    public static final String lookupErrText(int errno) {
        String errCode = Result.lookupErrCode(errno);
        if (errCode == null) {
            return null;
        }
        return RegistryResourceBundle.getString(errCode);
    }
}

