/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.modules;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import org.jboss.logging.Logger;
import org.jboss.security.auth.container.modules.AbstractServerAuthModule;
import org.jboss.security.auth.container.modules.SecurityActions;

public class DelegatingServerAuthModule
extends AbstractServerAuthModule {
    private LoginContext loginContext = null;
    private String loginContextName = null;

    public DelegatingServerAuthModule() {
        this.log = Logger.getLogger(DelegatingServerAuthModule.class);
        this.supportedTypes.add(Object.class);
    }

    public DelegatingServerAuthModule(String loginModuleStackHolderName) {
        this();
        this.loginContextName = loginModuleStackHolderName;
    }

    public Class[] getSupportedMessageTypes() {
        Class[] clarr = new Class[this.supportedTypes.size()];
        this.supportedTypes.toArray(clarr);
        return clarr;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException e) {
                throw new AuthException(e.getLocalizedMessage());
            }
        }
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject arg1) throws AuthException {
        throw new RuntimeException("Not Implemented");
    }

    protected boolean validate(Subject clientSubject, MessageInfo messageInfo) throws AuthException {
        try {
            this.loginContext = SecurityActions.createLoginContext(this.getSecurityDomainName(), clientSubject, this.callbackHandler);
            this.loginContext.login();
            return true;
        }
        catch (Exception e) {
            this.log.trace((Object)"Exception in validate:", (Throwable)e);
            throw new AuthException(e.getLocalizedMessage());
        }
    }

    private String getSecurityDomainName() {
        if (this.loginContextName != null) {
            return this.loginContextName;
        }
        String domainName = (String)this.options.get("javax.security.auth.login.LoginContext");
        if (domainName == null) {
            domainName = this.getClass().getName();
        }
        return domainName;
    }
}

