/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

public class VisitorAttributes {
    public static final AcceptAnyFilter RECURSE_ALL = new AcceptAnyFilter();
    public static final VisitorAttributes DEFAULT = new ImmutableVisitorAttributes();
    public static final VisitorAttributes LEAVES_ONLY = new ImmutableVisitorAttributes(true, null);
    public static final VisitorAttributes RECURSE = new ImmutableVisitorAttributes(false, RECURSE_ALL);
    public static final VisitorAttributes RECURSE_LEAVES_ONLY = new ImmutableVisitorAttributes(true, RECURSE_ALL);
    private boolean includeRoot;
    private boolean leavesOnly;
    private boolean ignoreErrors;
    private boolean includeHidden;
    private VirtualFileFilter recurseFilter;

    public boolean isLeavesOnly() {
        return this.leavesOnly;
    }

    public void setLeavesOnly(boolean leavesOnly) {
        this.leavesOnly = leavesOnly;
    }

    public boolean isRecurse(VirtualFile file) {
        boolean recurse = false;
        if (this.recurseFilter != null) {
            recurse = this.recurseFilter.accepts(file);
        }
        return recurse;
    }

    public VirtualFileFilter getRecurseFilter() {
        return this.recurseFilter;
    }

    public void setRecurseFilter(VirtualFileFilter filter) {
        this.recurseFilter = filter;
    }

    public boolean isIncludeRoot() {
        return this.includeRoot;
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }

    public void setIncludeHidden(boolean includeHidden) {
        this.includeHidden = includeHidden;
    }

    private static class ImmutableVisitorAttributes
    extends VisitorAttributes {
        public ImmutableVisitorAttributes() {
        }

        public ImmutableVisitorAttributes(boolean leavesOnly, VirtualFileFilter recurseFilter) {
            super.setLeavesOnly(leavesOnly);
            super.setRecurseFilter(recurseFilter);
        }

        public void setLeavesOnly(boolean leavesOnly) {
            throw new IllegalStateException("The preconfigured attributes are immutable");
        }

        public void setIncludeRoot(boolean includeRoot) {
            throw new IllegalStateException("The preconfigured attributes are immutable");
        }

        public void setRecurseFilter(VirtualFileFilter filter) {
            throw new IllegalStateException("The preconfigured attributes are immutable");
        }

        public void setIgnoreErrors(boolean ignoreErrors) {
            throw new IllegalStateException("The preconfigured attributes are immutable");
        }

        public void setIncludeHidden(boolean includeHidden) {
            throw new IllegalStateException("The preconfigured attributes are immutable");
        }
    }

    private static class AcceptAnyFilter
    implements VirtualFileFilter {
        private AcceptAnyFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return true;
        }
    }
}

