/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.ejb.packaging.JarVisitorFactory;

public class JarProtocolVisitor
implements JarVisitor {
    private JarVisitor delegate;
    private URL jarUrl;
    private Filter[] filters;

    public JarProtocolVisitor(URL url, Filter[] filters, String entry) {
        this.jarUrl = url;
        this.filters = filters;
        if (entry != null && entry.length() > 0) {
            throw new IllegalArgumentException("jar:jar: not supported: " + this.jarUrl);
        }
        this.init();
    }

    private void init() {
        String file = this.jarUrl.getFile();
        int subEntryIndex = file.lastIndexOf("!");
        if (subEntryIndex == -1) {
            throw new AssertionFailure("JAR URL does not contain '!/' :" + this.jarUrl);
        }
        String entry = subEntryIndex + 1 >= file.length() ? "" : file.substring(subEntryIndex + 1);
        URL fileUrl = JarVisitorFactory.getJarURLFromURLEntry(this.jarUrl, entry);
        this.delegate = JarVisitorFactory.getVisitor(fileUrl, this.filters, entry);
    }

    public String getUnqualifiedJarName() {
        return this.delegate.getUnqualifiedJarName();
    }

    public Filter[] getFilters() {
        return this.delegate.getFilters();
    }

    public Set[] getMatchingEntries() throws IOException {
        return this.delegate.getMatchingEntries();
    }
}

