/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.message;

import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessageStore;

public class SimpleMessageStore
implements MessageStore {
    private static final Logger log = Logger.getLogger(SimpleMessageStore.class);
    private Map<Long, Message> messages = new WeakHashMap<Long, Message>();

    public SimpleMessageStore() {
        log.debug((Object)(this + " initialized"));
    }

    public synchronized MessageReference reference(Message m) {
        Message message = this.messages.get(m.getMessageID());
        if (message == null) {
            this.messages.put(m.getMessageID(), m);
            message = m;
        }
        return message.createReference();
    }

    public synchronized MessageReference reference(long messageID) {
        Message message = this.messages.get(messageID);
        if (message == null) {
            return null;
        }
        return message.createReference();
    }

    public synchronized void clear() {
        this.messages.clear();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public String toString() {
        return "MemoryStore[" + System.identityHashCode(this) + "]";
    }
}

