/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mgbean;

import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.ErrorBean;
import com.sun.faces.mgbean.ManagedBeanBuilder;
import com.sun.faces.mgbean.ManagedBeanCreationException;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.mgbean.ManagedBeanPreProcessingException;
import com.sun.faces.mgbean.ManagedListBeanBuilder;
import com.sun.faces.mgbean.ManagedMapBeanBuilder;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManager {
    private static final Logger LOGGER = FacesLogger.MANAGEDBEAN.getLogger();
    private Map<String, BeanBuilder> managedBeans = new HashMap<String, BeanBuilder>();
    private InjectionProvider injectionProvider;
    private boolean configPreprocessed;
    private boolean lazyBeanValidation;

    public BeanManager(InjectionProvider injectionProvider, boolean lazyBeanValidation) {
        this.injectionProvider = injectionProvider;
        this.lazyBeanValidation = lazyBeanValidation;
    }

    public BeanManager(InjectionProvider injectionProvider, Map<String, BeanBuilder> managedBeans, boolean lazyBeanValidation) {
        this(injectionProvider, lazyBeanValidation);
        this.managedBeans = managedBeans;
    }

    public void register(ManagedBeanInfo beanInfo) {
        if (beanInfo.hasListEntry()) {
            if (beanInfo.hasMapEntry() || beanInfo.hasManagedProperties()) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_LIST_CONFIG_ERROR", beanInfo.getName());
                this.addBean(beanInfo.getName(), new ErrorBean(beanInfo, message));
            } else {
                this.addBean(beanInfo.getName(), new ManagedListBeanBuilder(beanInfo));
            }
        } else if (beanInfo.hasMapEntry()) {
            if (beanInfo.hasManagedProperties()) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_AS_MAP_CONFIG_ERROR", beanInfo.getName());
                this.addBean(beanInfo.getName(), new ErrorBean(beanInfo, message));
            } else {
                this.addBean(beanInfo.getName(), new ManagedMapBeanBuilder(beanInfo));
            }
        } else {
            this.addBean(beanInfo.getName(), new ManagedBeanBuilder(beanInfo));
        }
    }

    public Map<String, BeanBuilder> getRegisteredBeans() {
        return this.managedBeans;
    }

    public boolean isManaged(String name) {
        return this.managedBeans != null && this.managedBeans.containsKey(name);
    }

    public BeanBuilder getBuilder(String name) {
        if (this.managedBeans != null) {
            return this.managedBeans.get(name);
        }
        return null;
    }

    public void preProcessesBeans() {
        if (!this.configPreprocessed && !this.lazyBeanValidation) {
            this.configPreprocessed = true;
            for (Map.Entry<String, BeanBuilder> entry : this.managedBeans.entrySet()) {
                this.preProcessBean(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean isBeanInScope(String name, FacesContext context) {
        ELUtils.Scope scope = this.getBuilder(name).getScope();
        ExternalContext externalContext = context.getExternalContext();
        switch (scope) {
            case REQUEST: {
                if (externalContext.getRequestMap().containsKey(name)) {
                    return true;
                }
            }
            case SESSION: {
                if (externalContext.getSessionMap().containsKey(name)) {
                    return true;
                }
            }
            case APPLICATION: {
                if (!externalContext.getApplicationMap().containsKey(name)) break;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(String name, FacesContext facesContext) {
        BeanBuilder builder = this.managedBeans.get(name);
        if (builder != null) {
            Object bean;
            if (this.lazyBeanValidation && !builder.isBaked()) {
                this.preProcessBean(name, builder);
            }
            if (builder.hasMessages()) {
                throw new ManagedBeanCreationException(this.buildMessage(name, builder.getMessages(), true));
            }
            ELUtils.Scope scope = builder.getScope();
            switch (scope) {
                case APPLICATION: {
                    Object object = facesContext.getExternalContext().getContext();
                    synchronized (object) {
                        bean = this.createAndPush(name, builder, scope, facesContext);
                        break;
                    }
                }
                case SESSION: {
                    Object object = facesContext.getExternalContext().getSession(true);
                    synchronized (object) {
                        bean = this.createAndPush(name, builder, scope, facesContext);
                        break;
                    }
                }
                default: {
                    bean = this.createAndPush(name, builder, scope, facesContext);
                }
            }
            return bean;
        }
        return null;
    }

    public void destroy(String beanName, Object bean) {
        BeanBuilder builder = this.managedBeans.get(beanName);
        if (builder != null) {
            builder.destroy(this.injectionProvider, bean);
        }
    }

    private void addBean(String beanName, BeanBuilder builder) {
        if (this.configPreprocessed) {
            this.preProcessBean(beanName, builder);
        }
        this.managedBeans.put(beanName, builder);
    }

    private void validateReferences(BeanBuilder builder, List<String> references, List<String> messages) {
        List<String> refs = builder.getReferences();
        if (refs != null) {
            for (String ref : refs) {
                if (!this.isManaged(ref)) continue;
                if (references.contains(ref)) {
                    StringBuilder sb = new StringBuilder(64);
                    String[] ra = references.toArray(new String[references.size()]);
                    for (int i = 0; i < ra.length; ++i) {
                        sb.append(ra[i]);
                        sb.append(" -> ");
                    }
                    sb.append(ref);
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.CYCLIC_REFERENCE_ERROR", ra[0], sb.toString());
                    messages.add(message);
                    continue;
                }
                BeanBuilder b = this.getBuilder(ref);
                if (b.getReferences() == null) continue;
                references.add(ref);
                this.validateReferences(b, references, messages);
                references.remove(ref);
            }
        }
    }

    private synchronized void preProcessBean(String beanName, BeanBuilder builder) {
        if (!builder.isBaked()) {
            try {
                builder.bake();
                List<String> propRefs = builder.getReferences();
                if (propRefs != null) {
                    for (String reference : propRefs) {
                        if (!this.isManaged(reference)) continue;
                        BeanBuilder b = this.getBuilder(reference);
                        this.preProcessBean(reference, b);
                    }
                }
                ArrayList<String> refs = new ArrayList<String>();
                refs.add(beanName);
                ArrayList<String> messages = new ArrayList<String>();
                this.validateReferences(builder, refs, messages);
                if (!messages.isEmpty()) {
                    builder.queueMessages(messages);
                }
                if (builder.hasMessages() && LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, this.buildMessage(beanName, builder.getMessages(), false));
                }
            }
            catch (ManagedBeanPreProcessingException mbpe) {
                if (ManagedBeanPreProcessingException.Type.CHECKED.equals((Object)mbpe.getType())) {
                    builder.queueMessage(mbpe.getMessage());
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, this.buildMessage(beanName, builder.getMessages(), false));
                    }
                }
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNKNOWN_PROCESSING_ERROR", beanName);
                throw new ManagedBeanPreProcessingException(message, (Throwable)((Object)mbpe));
            }
        }
    }

    private Object createAndPush(String name, BeanBuilder builder, ELUtils.Scope scope, FacesContext facesContext) {
        Object bean = builder.build(this.injectionProvider, facesContext);
        ScopeManager.pushToScope(name, bean, scope, facesContext);
        return bean;
    }

    private String buildMessage(String name, List<String> messages, boolean runtime) {
        StringBuilder sb = new StringBuilder(128);
        if (runtime) {
            sb.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_ERROR", name));
        } else {
            sb.append(MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROBLEMS_STARTUP_ERROR", name));
        }
        for (String message : messages) {
            sb.append("\n     - ").append(message);
        }
        return sb.toString();
    }

    private static class ScopeManager {
        private static final EnumMap<ELUtils.Scope, ScopeHandler> handlerMap = new EnumMap(ELUtils.Scope.class);

        private ScopeManager() {
        }

        static void pushToScope(String name, Object bean, ELUtils.Scope scope, FacesContext context) {
            ScopeHandler handler = handlerMap.get((Object)scope);
            if (handler != null) {
                handler.handle(name, bean, context);
            }
        }

        static {
            handlerMap.put(ELUtils.Scope.REQUEST, new RequestScopeHandler());
            handlerMap.put(ELUtils.Scope.SESSION, new SessionScopeHandler());
            handlerMap.put(ELUtils.Scope.APPLICATION, new ApplicationScopeHandler());
        }

        private static class ApplicationScopeHandler
        implements ScopeHandler {
            private ApplicationScopeHandler() {
            }

            public void handle(String name, Object bean, FacesContext context) {
                context.getExternalContext().getApplicationMap().put(name, bean);
            }
        }

        private static class SessionScopeHandler
        implements ScopeHandler {
            private SessionScopeHandler() {
            }

            public void handle(String name, Object bean, FacesContext context) {
                context.getExternalContext().getSessionMap().put(name, bean);
            }
        }

        private static class RequestScopeHandler
        implements ScopeHandler {
            private RequestScopeHandler() {
            }

            public void handle(String name, Object bean, FacesContext context) {
                context.getExternalContext().getRequestMap().put(name, bean);
            }
        }

        private static interface ScopeHandler {
            public void handle(String var1, Object var2, FacesContext var3);
        }
    }
}

