/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi;

import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;

public class ParentPolicy {
    public static final ParentPolicy BEFORE = new ParentPolicy(ClassFilterUtils.EVERYTHING, ClassFilterUtils.NOTHING, "BEFORE");
    public static final ParentPolicy AFTER = new ParentPolicy(ClassFilterUtils.NOTHING_BUT_JAVA, ClassFilterUtils.EVERYTHING, "AFTER");
    public static final ParentPolicy BEFORE_BUT_JAVA_ONLY = new ParentPolicy(ClassFilterUtils.JAVA_ONLY, ClassFilterUtils.NOTHING, "BEFORE_BUT_JAVA_ONLY");
    public static final ParentPolicy AFTER_BUT_JAVA_BEFORE = new ParentPolicy(ClassFilterUtils.JAVA_ONLY, ClassFilterUtils.EVERYTHING, "AFTER_BUT_JAVA_BEFORE");
    public static final ParentPolicy AFTER_BUT_ONLY_JAVA_BEFORE = new ParentPolicy(ClassFilterUtils.NOTHING_BUT_JAVA, ClassFilterUtils.EVERYTHING, "AFTER_BUT_JAVA_BEFORE");
    private ClassFilter beforeFilter;
    private ClassFilter afterFilter;
    private String description;

    public ParentPolicy(ClassFilter beforeFilter, ClassFilter afterFilter) {
        this(beforeFilter, afterFilter, null);
    }

    public ParentPolicy(ClassFilter beforeFilter, ClassFilter afterFilter, String description) {
        if (beforeFilter == null) {
            throw new IllegalArgumentException("Null beforeFilter");
        }
        if (afterFilter == null) {
            throw new IllegalArgumentException("Null afterFilter");
        }
        this.beforeFilter = beforeFilter;
        this.afterFilter = afterFilter;
        this.description = description;
        if (description == null) {
            this.description = "(before=" + beforeFilter + " after=" + afterFilter + ")";
        }
    }

    public ClassFilter getBeforeFilter() {
        return this.beforeFilter;
    }

    public ClassFilter getAfterFilter() {
        return this.afterFilter;
    }

    public String toString() {
        return this.description;
    }
}

