/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.system.server.profileservice.repository.clustered.metadata.Identifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSortedMetadataContainer<K, T extends Identifiable<K>>
implements Serializable {
    private static final long serialVersionUID = 7130572488073615772L;
    protected SortedSet<T> sortedItems = new TreeSet<T>();
    private transient Map<K, T> itemMap = new ConcurrentHashMap<K, T>();
    private transient Collection<T> exposedCollection = new MetadataCollection();

    protected Collection<T> getExposedCollection() {
        return this.exposedCollection;
    }

    protected T getContainedMetadata(K key) {
        return (T)((Identifiable)this.itemMap.get(key));
    }

    protected Set<K> getContainedMetadataIds() {
        return Collections.unmodifiableSet(this.itemMap.keySet());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.exposedCollection = new MetadataCollection();
        this.itemMap = new ConcurrentHashMap<K, T>();
        for (Identifiable item : this.sortedItems) {
            this.itemMap.put(item.getId(), item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MetadataCollection
    implements Collection<T> {
        private MetadataCollection() {
        }

        @Override
        public boolean add(T toAdd) {
            boolean change;
            Object id = toAdd.getId();
            Identifiable existing = (Identifiable)AbstractSortedMetadataContainer.this.itemMap.put(id, toAdd);
            boolean bl = change = !toAdd.equals(existing);
            if (change) {
                if (existing != null) {
                    AbstractSortedMetadataContainer.this.sortedItems.remove(existing);
                }
                AbstractSortedMetadataContainer.this.sortedItems.add(toAdd);
            }
            return change;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean mod = false;
            for (Identifiable t : c) {
                if (!this.add((T)t)) continue;
                mod = true;
            }
            return mod;
        }

        @Override
        public void clear() {
            AbstractSortedMetadataContainer.this.itemMap.clear();
            AbstractSortedMetadataContainer.this.sortedItems.clear();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractSortedMetadataContainer.this.sortedItems.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return AbstractSortedMetadataContainer.this.sortedItems.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return AbstractSortedMetadataContainer.this.sortedItems.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return AbstractSortedMetadataContainer.this.sortedItems.iterator();
        }

        @Override
        public boolean remove(Object toRemove) {
            boolean result = AbstractSortedMetadataContainer.this.sortedItems.remove(toRemove);
            if (result) {
                Identifiable item = (Identifiable)toRemove;
                AbstractSortedMetadataContainer.this.itemMap.remove(item.getId());
            }
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean mod = false;
            for (Object o : c) {
                if (!this.remove(o)) continue;
                mod = true;
            }
            return mod;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll is not supported");
        }

        @Override
        public int size() {
            return AbstractSortedMetadataContainer.this.sortedItems.size();
        }

        @Override
        public Object[] toArray() {
            return AbstractSortedMetadataContainer.this.sortedItems.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return AbstractSortedMetadataContainer.this.sortedItems.toArray(a);
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof Collection) {
                Collection o = (Collection)other;
                return AbstractSortedMetadataContainer.this.sortedItems.size() == o.size() && AbstractSortedMetadataContainer.this.sortedItems.containsAll(o);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return AbstractSortedMetadataContainer.this.sortedItems.hashCode();
        }
    }
}

