/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.deployers;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb.EjbModule;
import org.jboss.management.j2ee.EJB;
import org.jboss.management.j2ee.EJBModule;
import org.jboss.management.j2ee.deployers.AbstractVFSJSR77Deployer;
import org.jboss.management.j2ee.factory.FactoryUtils;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbModuleJSR77Deployer
extends AbstractVFSJSR77Deployer<JBossMetaData> {
    public EjbModuleJSR77Deployer() {
        super(JBossMetaData.class);
    }

    @Override
    protected void deployJsr77(MBeanServer server, VFSDeploymentUnit unit, JBossMetaData metaData) throws Throwable {
        String ejbJarName = unit.getSimpleName();
        ObjectName ejbModuleService = this.extractRootObjectName(server, (DeploymentUnit)unit, metaData);
        ObjectName jsr77Name = EJBModule.create(server, FactoryUtils.findEarParent((DeploymentUnit)unit), ejbJarName, unit.getRoot().toURL(), ejbModuleService);
        EjbModuleJSR77Deployer.putObjectName((DeploymentUnit)unit, ejbModuleService.getCanonicalName(), jsr77Name);
        EjbModuleJSR77Deployer.putObjectName((DeploymentUnit)unit, EJBModule.class.getName(), jsr77Name);
        this.log.debug((Object)("Created module: " + jsr77Name));
        Iterable<ObjectName> ejbs = this.extractComponentObjectNames(server, (DeploymentUnit)unit, metaData);
        for (ObjectName containerName : ejbs) {
            this.createEJB(server, unit, containerName);
        }
    }

    @Override
    protected void undeployJsr77(MBeanServer server, VFSDeploymentUnit unit, JBossMetaData metaData) {
        ObjectName ejbModuleService;
        ObjectName jsr77Name = EjbModuleJSR77Deployer.removeObjectName((DeploymentUnit)unit, EJBModule.class.getName());
        this.log.debug((Object)("Destroy module: " + jsr77Name));
        Iterable<ObjectName> ejbs = this.extractComponentObjectNames(server, (DeploymentUnit)unit, metaData);
        for (ObjectName containerName : ejbs) {
            this.destroyEJB(server, unit, containerName);
        }
        if (jsr77Name != null) {
            EJBModule.destroy(server, jsr77Name);
        }
        if ((ejbModuleService = this.extractRootObjectName(server, (DeploymentUnit)unit, metaData)) != null) {
            EjbModuleJSR77Deployer.removeObjectName((DeploymentUnit)unit, ejbModuleService.getCanonicalName());
        }
    }

    public ObjectName createEJB(MBeanServer server, VFSDeploymentUnit unit, ObjectName containerName) {
        ObjectName jsr77Name = null;
        try {
            BeanMetaData metaData = (BeanMetaData)server.getAttribute(containerName, "BeanMetaData");
            EjbModule ejbModule = (EjbModule)server.getAttribute(containerName, "EjbModule");
            ObjectName ejbModName = EjbModuleJSR77Deployer.getObjectName((DeploymentUnit)unit, ejbModule.getServiceName().getCanonicalName());
            String ejbName = metaData.getEjbName();
            String jndiName = metaData.getJndiName();
            String localJndiName = metaData.getLocalJndiName();
            int type = 2;
            if (metaData.isSession()) {
                SessionMetaData smetaData = (SessionMetaData)metaData;
                if (smetaData.isStateful()) {
                    type = 1;
                }
            } else {
                type = metaData.isMessageDriven() ? 3 : 0;
            }
            jsr77Name = EJB.create(server, ejbModName, containerName, type, ejbName, jndiName, localJndiName);
            EjbModuleJSR77Deployer.putObjectName((DeploymentUnit)unit, containerName.getCanonicalName(), jsr77Name);
            this.log.debug((Object)("Create container: " + containerName + ", module: " + jsr77Name));
        }
        catch (Exception e) {
            this.log.debug((Object)"", (Throwable)e);
        }
        return jsr77Name;
    }

    public void destroyEJB(MBeanServer server, VFSDeploymentUnit unit, ObjectName containerName) {
        ObjectName jsr77Name = EjbModuleJSR77Deployer.removeObjectName((DeploymentUnit)unit, containerName.getCanonicalName());
        this.log.debug((Object)("Destroy container: " + containerName + ", module: " + jsr77Name));
        if (jsr77Name != null) {
            EJB.destroy(server, jsr77Name);
        }
    }
}

