/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.deployers.spi;

import java.util.HashSet;
import java.util.Set;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3DeployerUtils {
    private static final String MC_BEAN_NAME_MAIN_DEPLOYER = "MainDeployer";

    private Ejb3DeployerUtils() {
    }

    public static Set<DeploymentUnit> getAllEjb3DeploymentUnitsInMainDeployer() {
        HashSet<DeploymentUnit> deploymentUnits = new HashSet<DeploymentUnit>();
        Object mainDeployer = Ejb3RegistrarLocator.locateRegistrar().lookup(MC_BEAN_NAME_MAIN_DEPLOYER);
        assert (mainDeployer instanceof DeployerClient && mainDeployer instanceof MainDeployerStructure) : "Obtained Main Deployer is not of expected type";
        DeployerClient dc = (DeployerClient)mainDeployer;
        MainDeployerStructure mds = (MainDeployerStructure)mainDeployer;
        for (Deployment d : dc.getTopLevel()) {
            DeploymentUnit du = mds.getDeploymentUnit(d.getName());
            JBossMetaData metadata = (JBossMetaData)du.getAttachment(JBossMetaData.class);
            if (metadata == null || !metadata.isEJB3x()) continue;
            deploymentUnits.add(du);
        }
        return deploymentUnits;
    }
}

