/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.SessionSynchronization;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.EnterpriseBeanPolicyContextHandler;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.logging.Logger;
import org.jboss.metadata.SessionMetaData;
import org.jboss.security.AuthenticationManager;

public class StatefulSessionInstanceInterceptor
extends AbstractInterceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    protected StatefulSessionContainer container;
    private static final Method getEJBHome;
    private static final Method getHandle;
    private static final Method getPrimaryKey;
    private static final Method isIdentical;
    private static final Method remove;
    private static final Method getEJBObject;
    private static final Method ejbTimeout;

    public void setContainer(Container container) {
        this.container = (StatefulSessionContainer)container;
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        EnterpriseContext enterpriseContext;
        Object object;
        if (getEJBObject.equals(mi.getMethod())) {
            return this.getNext().invokeHome(mi);
        }
        InstancePool pool = this.container.getInstancePool();
        EnterpriseContext ctx = pool.get();
        mi.setEnterpriseContext(ctx);
        ctx.lock();
        AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_HOME);
        try {
            object = this.getNext().invokeHome(mi);
            Object var6_5 = null;
            enterpriseContext = ctx;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            EnterpriseContext enterpriseContext2 = ctx;
            synchronized (enterpriseContext2) {
                AllowedOperationsAssociation.popInMethodFlag();
                ctx.unlock();
                if (ctx.getId() == null) {
                    pool.free(ctx);
                }
            }
            throw throwable;
        }
        synchronized (enterpriseContext) {
            AllowedOperationsAssociation.popInMethodFlag();
            ctx.unlock();
            if (ctx.getId() == null) {
                pool.free(ctx);
            }
        }
        return object;
    }

    protected void register(EnterpriseContext ctx, Transaction tx, BeanLock lock) {
        InstanceSynchronization synch = new InstanceSynchronization(ctx, lock);
        try {
            if (tx.getStatus() == 1) {
                return;
            }
            try {
                tx.registerSynchronization((Synchronization)synch);
            }
            catch (Exception ex) {
                this.getContainer().getLockManager().removeLockRef(lock.getId());
                throw ex;
            }
            synch.afterBegin();
        }
        catch (RollbackException e) {
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Invocation mi) throws Exception {
        InstanceCache cache = this.container.getInstanceCache();
        InstancePool pool = this.container.getInstancePool();
        Object methodID = mi.getId();
        EnterpriseContext ctx = null;
        BeanLock lock = this.container.getLockManager().getLock(methodID);
        boolean callerRunAsIdentityPresent = SecurityActions.peekRunAsIdentity() != null;
        boolean pushSecurityContext = SecurityActions.getSecurityContext() == null;
        try {
            Object object;
            if (!callerRunAsIdentityPresent && pushSecurityContext) {
                AuthenticationManager am = this.container.getSecurityManager();
                String securityDomain = "other";
                if (am != null) {
                    securityDomain = am.getSecurityDomain();
                }
                SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), securityDomain, null);
            }
            lock.sync();
            try {
                try {
                    ctx = cache.get(methodID);
                }
                catch (NoSuchObjectException e) {
                    if (!mi.isLocal()) throw e;
                    throw new NoSuchObjectLocalException(e.getMessage());
                }
                catch (EJBException e) {
                    throw e;
                }
                catch (RemoteException e) {
                    throw e;
                }
                catch (Exception e) {
                    InvocationType type = mi.getType();
                    boolean isLocal = type == InvocationType.LOCAL || type == InvocationType.LOCALHOME;
                    if (!isLocal) throw new RemoteException("Unable to get an intance from the pool/cache", e);
                    throw new EJBException("Unable to get an instance from the pool/cache", e);
                }
                mi.setEnterpriseContext(ctx);
                EnterpriseBeanPolicyContextHandler.setEnterpriseBean(ctx.getInstance());
                boolean isBMT = ((SessionMetaData)this.container.getBeanMetaData()).isBeanManagedTx();
                if (!isBMT) {
                    if (ctx.getTransaction() != null && !ctx.getTransaction().equals(mi.getTransaction())) {
                        StringBuffer msg = new StringBuffer("Application Error: tried to enter Stateful bean with different tx context");
                        msg.append(", contextTx: " + ctx.getTransaction());
                        msg.append(", methodTx: " + mi.getTransaction());
                        throw new EJBException(msg.toString());
                    }
                    if (ctx.getTransaction() == null && mi.getTransaction() != null) {
                        this.register(ctx, mi.getTransaction(), lock);
                    }
                }
                if (!ctx.isLocked()) {
                    ctx.lock();
                } else {
                    if (!this.isCallAllowed(mi)) {
                        throw new EJBException("Application Error: no concurrent calls on stateful beans");
                    }
                    ctx.lock();
                }
                Object var13_21 = null;
                lock.releaseSync();
            }
            catch (Throwable throwable) {
                Object var13_22 = null;
                lock.releaseSync();
                throw throwable;
            }
            if (ejbTimeout.equals(mi.getMethod())) {
                AllowedOperationsAssociation.pushInMethodFlag(IN_EJB_TIMEOUT);
            } else {
                AllowedOperationsAssociation.pushInMethodFlag(IN_BUSINESS_METHOD);
            }
            boolean validContext = true;
            try {
                Object ret;
                object = ret = this.getNext().invoke(mi);
                Object var15_24 = null;
            }
            catch (RemoteException e) {
                try {
                    cache.remove(methodID);
                    pool.discard(ctx);
                    validContext = false;
                    throw e;
                    catch (RuntimeException e2) {
                        cache.remove(methodID);
                        pool.discard(ctx);
                        validContext = false;
                        throw e2;
                    }
                    catch (Error e3) {
                        cache.remove(methodID);
                        pool.discard(ctx);
                        validContext = false;
                        throw e3;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_25 = null;
                    AllowedOperationsAssociation.popInMethodFlag();
                    if (!validContext) throw throwable;
                    lock.sync();
                    try {}
                    catch (Throwable throwable2) {
                        Object var17_29 = null;
                        lock.releaseSync();
                        throw throwable2;
                    }
                    ctx.unlock();
                    if (ctx.getId() == null) {
                        cache.remove(methodID);
                        pool.free(ctx);
                    }
                    Object var17_28 = null;
                    lock.releaseSync();
                    throw throwable;
                }
            }
            AllowedOperationsAssociation.popInMethodFlag();
            if (validContext) {
                lock.sync();
                try {
                    ctx.unlock();
                    if (ctx.getId() == null) {
                        cache.remove(methodID);
                        pool.free(ctx);
                    }
                    Object var17_26 = null;
                    lock.releaseSync();
                }
                catch (Throwable throwable) {
                    Object var17_27 = null;
                    lock.releaseSync();
                    throw throwable;
                }
            }
            Object var19_32 = null;
            this.container.getLockManager().removeLockRef(lock.getId());
            if (!callerRunAsIdentityPresent && pushSecurityContext) {
                SecurityActions.clearSecurityContext();
            }
            EnterpriseBeanPolicyContextHandler.setEnterpriseBean(null);
            return object;
        }
        catch (Throwable throwable) {
            Object var19_33 = null;
            this.container.getLockManager().removeLockRef(lock.getId());
            if (!callerRunAsIdentityPresent && pushSecurityContext) {
                SecurityActions.clearSecurityContext();
            }
            EnterpriseBeanPolicyContextHandler.setEnterpriseBean(null);
            throw throwable;
        }
    }

    protected boolean isCallAllowed(Invocation mi) {
        Method m = mi.getMethod();
        return m.equals(getEJBHome) || m.equals(getHandle) || m.equals(getPrimaryKey) || m.equals(isIdentical) || m.equals(remove);
    }

    static {
        try {
            Class[] noArg = new Class[]{};
            getEJBHome = EJBObject.class.getMethod("getEJBHome", noArg);
            getHandle = EJBObject.class.getMethod("getHandle", noArg);
            getPrimaryKey = EJBObject.class.getMethod("getPrimaryKey", noArg);
            isIdentical = EJBObject.class.getMethod("isIdentical", EJBObject.class);
            remove = EJBObject.class.getMethod("remove", noArg);
            getEJBObject = Handle.class.getMethod("getEJBObject", noArg);
            ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }

    private class InstanceSynchronization
    implements Synchronization {
        private EnterpriseContext ctx;
        private boolean notifySession = false;
        private Method afterBegin;
        private Method beforeCompletion;
        private Method afterCompletion;
        private BeanLock lock;
        private boolean beforeCompletionInvoked = false;

        InstanceSynchronization(EnterpriseContext ctx, BeanLock lock) {
            this.ctx = ctx;
            this.lock = lock;
            this.lock.addRef();
            this.notifySession = ctx.getInstance() instanceof SessionSynchronization;
            if (this.notifySession) {
                try {
                    Class<?> sync = Class.forName("javax.ejb.SessionSynchronization");
                    this.afterBegin = sync.getMethod("afterBegin", new Class[0]);
                    this.beforeCompletion = sync.getMethod("beforeCompletion", new Class[0]);
                    this.afterCompletion = sync.getMethod("afterCompletion", Boolean.TYPE);
                }
                catch (Exception e) {
                    StatefulSessionInstanceInterceptor.this.log.error((Object)"failed to setup InstanceSynchronization", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterBegin() {
            if (!this.notifySession) return;
            try {
                try {
                    AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_AFTER_BEGIN);
                    this.afterBegin.invoke(this.ctx.getInstance(), new Object[0]);
                }
                catch (Exception e) {
                    StatefulSessionInstanceInterceptor.this.log.error((Object)"failed to invoke afterBegin", (Throwable)e);
                    Object var3_2 = null;
                    AllowedOperationsAssociation.popInMethodFlag();
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                throw throwable;
            }
            AllowedOperationsAssociation.popInMethodFlag();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void beforeCompletion() {
            if (StatefulSessionInstanceInterceptor.this.log.isTraceEnabled()) {
                StatefulSessionInstanceInterceptor.this.log.trace((Object)"beforeCompletion called");
            }
            this.ctx.lock();
            this.beforeCompletionInvoked = true;
            if (!this.notifySession) return;
            try {
                try {
                    AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_BEFORE_COMPLETION);
                    StatefulSessionInstanceInterceptor.this.container.pushENC();
                    this.beforeCompletion.invoke(this.ctx.getInstance(), new Object[0]);
                }
                catch (Exception e) {
                    StatefulSessionInstanceInterceptor.this.log.error((Object)"failed to invoke beforeCompletion", (Throwable)e);
                    Object var3_2 = null;
                    StatefulSessionInstanceInterceptor.this.container.popENC();
                    AllowedOperationsAssociation.popInMethodFlag();
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                StatefulSessionInstanceInterceptor.this.container.popENC();
                AllowedOperationsAssociation.popInMethodFlag();
                throw throwable;
            }
            StatefulSessionInstanceInterceptor.this.container.popENC();
            AllowedOperationsAssociation.popInMethodFlag();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterCompletion(int status) {
            if (StatefulSessionInstanceInterceptor.this.log.isTraceEnabled()) {
                StatefulSessionInstanceInterceptor.this.log.trace((Object)"afterCompletion called");
            }
            this.lock.sync();
            try {
                block12: {
                    this.ctx.setTransaction(null);
                    if (this.beforeCompletionInvoked) {
                        this.ctx.unlock();
                    }
                    if (this.notifySession) {
                        try {
                            try {
                                AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsFlags.IN_AFTER_COMPLETION);
                                StatefulSessionInstanceInterceptor.this.container.pushENC();
                                if (status == 3) {
                                    this.afterCompletion.invoke(this.ctx.getInstance(), Boolean.TRUE);
                                } else {
                                    this.afterCompletion.invoke(this.ctx.getInstance(), Boolean.FALSE);
                                }
                            }
                            catch (Exception e) {
                                StatefulSessionInstanceInterceptor.this.log.error((Object)"failed to invoke afterCompletion", (Throwable)e);
                                Object var4_3 = null;
                                StatefulSessionInstanceInterceptor.this.container.popENC();
                                AllowedOperationsAssociation.popInMethodFlag();
                                break block12;
                            }
                            Object var4_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            StatefulSessionInstanceInterceptor.this.container.popENC();
                            AllowedOperationsAssociation.popInMethodFlag();
                            throw throwable;
                        }
                        StatefulSessionInstanceInterceptor.this.container.popENC();
                        AllowedOperationsAssociation.popInMethodFlag();
                    }
                }
                Object var6_7 = null;
                this.lock.releaseSync();
                StatefulSessionInstanceInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.lock.releaseSync();
                StatefulSessionInstanceInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                throw throwable;
            }
        }
    }
}

