/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mcint.metadata.plugins;

import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.common.deployers.spi.Ejb3DeployerUtils;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.ejb3.common.resolvers.spi.UnresolvableReferenceException;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.reflect.spi.TypeInfo;

public class AbstractEjbReferenceValueMetadata
extends AbstractDependencyValueMetaData {
    private static final long serialVersionUID = 1L;
    private static final String DEPENDS_JNDI_PREFIX = "jndi:";
    private EjbReferenceResolver resolver;
    private EjbReference reference;
    private Context namingContext;

    public AbstractEjbReferenceValueMetadata(EjbReferenceResolver resolver, EjbReference reference, Context context) {
        assert (resolver != null) : "Resolver is required, but was not specified";
        assert (reference != null) : "EJB Reference is required, but was not specified";
        assert (context != null) : "Naming Context is required, but was not specified";
        this.setResolver(resolver);
        this.setReference(reference);
        this.setNamingContext(context);
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        return this.resolveEjb();
    }

    public Object getValue() {
        return this.resolveEjb();
    }

    public Object getUnderlyingValue() {
        return DEPENDS_JNDI_PREFIX + this.getTargetJndiName();
    }

    protected String getTargetJndiName() {
        String jndiName = null;
        Set dus = Ejb3DeployerUtils.getAllEjb3DeploymentUnitsInMainDeployer();
        if (dus != null) {
            for (DeploymentUnit du : dus) {
                if (du.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class) == null) continue;
                try {
                    jndiName = this.resolver.resolveEjb(du, this.reference);
                    if (jndiName == null) continue;
                    break;
                }
                catch (UnresolvableReferenceException urre) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("EJB reference " + this.reference + " could not be resolved in unit " + du + " - trying next unit"));
                }
            }
        }
        if (jndiName == null) {
            throw new UnresolvableReferenceException("Could not resolve in current deployments reference: " + this.reference);
        }
        return jndiName;
    }

    protected Object resolveEjb() {
        Object obj = null;
        String jndiName = this.getTargetJndiName();
        try {
            obj = this.getNamingContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not obtain " + jndiName + "from JNDI", e);
        }
        this.addDependencyItem();
        return obj;
    }

    public EjbReference getReference() {
        return this.reference;
    }

    protected void setReference(EjbReference reference) {
        this.reference = reference;
    }

    protected EjbReferenceResolver getResolver() {
        return this.resolver;
    }

    protected void setResolver(EjbReferenceResolver resolver) {
        this.resolver = resolver;
    }

    protected Context getNamingContext() {
        return this.namingContext;
    }

    protected void setNamingContext(Context context) {
        this.namingContext = context;
    }
}

