/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheRemove;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.SegmentsAndVirtualNodeConverter;
import org.jboss.as.clustering.infinispan.subsystem.SharedCacheResource;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DistributedCacheResource
extends SharedCacheResource {
    public static final PathElement DISTRIBUTED_CACHE_PATH = PathElement.pathElement((String)"distributed-cache");
    static final SimpleAttributeDefinition L1_LIFESPAN = new SimpleAttributeDefinitionBuilder("l1-lifespan", ModelType.LONG, true).setXmlName(Attribute.L1_LIFESPAN.getLocalName()).setMeasurementUnit(MeasurementUnit.MILLISECONDS).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(600000)).build();
    static final SimpleAttributeDefinition OWNERS = new SimpleAttributeDefinitionBuilder("owners", ModelType.INT, true).setXmlName(Attribute.OWNERS.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(2)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).build();
    @Deprecated
    static final SimpleAttributeDefinition VIRTUAL_NODES = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("virtual-nodes", ModelType.INT, true).setXmlName(Attribute.VIRTUAL_NODES.getLocalName()).setAllowExpression(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(1)).setDeprecated(ModelVersion.create((int)1, (int)4, (int)0))).setAlternatives(new String[]{"segments"}).build();
    static final SimpleAttributeDefinition SEGMENTS = new SimpleAttributeDefinitionBuilder("segments", ModelType.INT, true).setXmlName(Attribute.SEGMENTS.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(80)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).setAlternatives(new String[]{"virtual-nodes"}).build();
    static final AttributeDefinition[] DISTRIBUTED_CACHE_ATTRIBUTES = new AttributeDefinition[]{OWNERS, SEGMENTS, L1_LIFESPAN};

    public DistributedCacheResource(ResolvePathHandler resolvePathHandler) {
        super(DISTRIBUTED_CACHE_PATH, InfinispanExtension.getResourceDescriptionResolver("distributed-cache"), DistributedCacheAdd.INSTANCE, (OperationStepHandler)CacheRemove.INSTANCE, resolvePathHandler);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(DISTRIBUTED_CACHE_ATTRIBUTES);
        for (AttributeDefinition attr : DISTRIBUTED_CACHE_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
        OperationStepHandler virtualNodesWriteHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                if (operation.hasDefined("value") && operation.get("value").asInt() != 1) {
                    InfinispanLogger.ROOT_LOGGER.virtualNodesAttributeDeprecated();
                    ModelNode convertedValue = SegmentsAndVirtualNodeConverter.virtualNodesToSegments(operation.get("value"));
                    ModelNode submodel = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
                    ModelNode syntheticOp = new ModelNode();
                    syntheticOp.get("segments").set(convertedValue);
                    SEGMENTS.validateAndSet(syntheticOp, submodel);
                    if (this.requiresRuntime(context)) {
                        context.addStep(new OperationStepHandler(){

                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                context.reloadRequired();
                                context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                            }
                        }, OperationContext.Stage.RUNTIME);
                    }
                }
                context.stepCompleted();
            }

            protected boolean requiresRuntime(OperationContext context) {
                return context.getProcessType().isServer() && !context.isBooting();
            }
        };
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)VIRTUAL_NODES, null, virtualNodesWriteHandler);
    }
}

