/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.impl;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.impl.SimpleCache;
import org.jboss.as.ejb3.cache.spi.GroupAwareBackingCache;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.cache.spi.impl.GroupCreationContext;

public class GroupAwareCache<K extends Serializable, V extends Cacheable<K>, G extends Serializable, M extends SerializationGroupMember<K, V, G>>
extends SimpleCache<K, V, M> {
    private final GroupAwareBackingCache<K, V, G, M> groupedCache;
    private final boolean strictGroups;

    public GroupAwareCache(GroupAwareBackingCache<K, V, G, M> groupedCache, boolean strictGroups) {
        super(groupedCache, strictGroups);
        this.groupedCache = groupedCache;
        this.strictGroups = strictGroups;
    }

    @Override
    public V create() {
        boolean outer = false;
        GroupCreationContext groupContext = GroupCreationContext.getGroupCreationContext();
        if (groupContext == null) {
            groupContext = GroupCreationContext.startGroupCreationContext(this.strictGroups);
            outer = true;
        }
        List contextEntries = groupContext.getEntries();
        try {
            Object group;
            Object cacheItem = ((SerializationGroupMember)this.groupedCache.create()).getUnderlyingItem();
            contextEntries.add(new AbstractMap.SimpleImmutableEntry(cacheItem, this.groupedCache));
            if (outer && contextEntries.size() > 1) {
                group = this.groupedCache.createGroup();
                for (Map.Entry entry : contextEntries) {
                    Cacheable object = (Cacheable)entry.getKey();
                    GroupAwareBackingCache pairCache = (GroupAwareBackingCache)entry.getValue();
                    pairCache.setGroup(object, group);
                }
            }
            group = cacheItem;
            return group;
        }
        catch (RuntimeException e) {
            if (outer) {
                for (Map.Entry entry : contextEntries) {
                    Cacheable item = (Cacheable)entry.getKey();
                    Serializable id = (Serializable)item.getId();
                    try {
                        ((GroupAwareBackingCache)entry.getValue()).remove(id);
                    }
                    catch (Exception toLog) {
                        EjbLogger.EJB3_LOGGER.cacheRemoveFailed(id);
                    }
                }
            }
            throw e;
        }
        finally {
            if (outer) {
                GroupCreationContext.clearGroupCreationContext();
            }
        }
    }
}

