/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.common.beans.property.PropertiesValueResolver;
import org.jboss.logging.Logger;

public class Configurator {
    protected static final Logger log = Logger.getLogger(Configurator.class);
    public static final String[] NO_PARAMS_TYPES = new String[0];

    public static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return Configurator.toClass(pt.getRawType());
        }
        throw PojoMessages.MESSAGES.unknownType(type);
    }

    public static Object convertValue(Class<?> clazz, Object value, boolean replaceProperties, boolean trim) throws Throwable {
        PropertyEditor editor;
        if (clazz == null) {
            return value;
        }
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == String.class) {
            String string = (String)value;
            if (trim) {
                string = string.trim();
            }
            if (replaceProperties) {
                value = PropertiesValueResolver.replaceProperties((String)string);
            }
        }
        if (clazz.isAssignableFrom(valueClass)) {
            return value;
        }
        if (clazz.isEnum()) {
            Class<Enum> eclazz = clazz.asSubclass(Enum.class);
            return Enum.valueOf(eclazz, value.toString());
        }
        if (valueClass == String.class && (editor = PropertyEditorManager.findEditor(clazz)) != null) {
            editor.setAsText((String)value);
            return editor.getValue();
        }
        try {
            Method method = clazz.getMethod("valueOf", valueClass);
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && clazz.isAssignableFrom(method.getReturnType())) {
                return method.invoke(null, value);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (valueClass == String.class) {
            try {
                Constructor<?> constructor = clazz.getConstructor(valueClass);
                if (Modifier.isPublic(constructor.getModifiers())) {
                    return constructor.newInstance(value);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return value;
    }

    public static String[] getTypes(ValueConfig[] values) {
        if (values == null || values.length == 0) {
            return NO_PARAMS_TYPES;
        }
        String[] types = new String[values.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = values[i].getType();
        }
        return types;
    }

    public static Method findMethod(DeploymentReflectionIndex index, Class classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic, boolean strict) throws IllegalArgumentException {
        if (name == null) {
            throw PojoMessages.MESSAGES.nullName();
        }
        if (classInfo == null) {
            throw PojoMessages.MESSAGES.nullClassInfo();
        }
        if (paramTypes == null) {
            paramTypes = NO_PARAMS_TYPES;
        }
        for (Class current = classInfo; current != null; current = current.getSuperclass()) {
            ClassReflectionIndex cri = index.getClassIndex(classInfo);
            Method result = Configurator.locateMethod(cri, name, paramTypes, isStatic, isPublic, strict);
            if (result == null) continue;
            return result;
        }
        throw PojoMessages.MESSAGES.methodNotFound(name, Arrays.toString(paramTypes), classInfo.getName());
    }

    private static Method locateMethod(ClassReflectionIndex classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic, boolean strict) {
        Collection methods = classInfo.getMethods();
        if (methods != null) {
            for (Method method : methods) {
                if (!name.equals(method.getName()) || !Configurator.equals(paramTypes, method.getParameterTypes()) || strict && (Modifier.isStatic(method.getModifiers()) != isStatic || Modifier.isPublic(method.getModifiers()) != isPublic)) continue;
                return method;
            }
        }
        return null;
    }

    public static boolean equals(String[] typeNames, Class<?>[] typeInfos) {
        if (!Configurator.simpleCheck(typeNames, typeInfos)) {
            return false;
        }
        for (int i = 0; i < typeNames.length; ++i) {
            if (typeNames[i] == null || typeNames[i].equals(typeInfos[i].getName())) continue;
            return false;
        }
        return true;
    }

    protected static boolean simpleCheck(String[] typeNames, Class<?>[] typeInfos) {
        return typeNames != null && typeInfos != null && typeNames.length == typeInfos.length;
    }
}

