/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import java.util.Properties;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.jpa.hibernate4.infinispan.SharedInfinispanRegionFactory;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class HibernateSecondLevelCache {
    private static final String DEFAULT_REGION_FACTORY = SharedInfinispanRegionFactory.class.getName();

    public static void addSecondLevelCacheDependencies(ServiceRegistry registry, ServiceTarget target, ServiceBuilder<?> builder, PersistenceUnitMetadata pu) {
        String regionFactory;
        String name;
        Properties properties = pu.getProperties();
        if (properties.getProperty("hibernate.cache.region_prefix") == null && (name = pu.getScopedPersistenceUnitName()) != null) {
            properties.setProperty("hibernate.cache.region_prefix", name);
        }
        if ((regionFactory = properties.getProperty("hibernate.cache.region.factory_class")) == null) {
            regionFactory = DEFAULT_REGION_FACTORY;
            properties.setProperty("hibernate.cache.region.factory_class", regionFactory);
        }
        if (regionFactory.equals(DEFAULT_REGION_FACTORY)) {
            String container = properties.getProperty("hibernate.cache.infinispan.container");
            if (container == null) {
                container = "hibernate";
                properties.setProperty("hibernate.cache.infinispan.container", container);
            }
            builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, ChannelService.getServiceName((String)container));
            String entity = properties.getProperty("hibernate.cache.infinispan.entity.cfg", "entity");
            String collection = properties.getProperty("hibernate.cache.infinispan.collection.cfg", "entity");
            builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)entity));
            builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)collection));
            if (Boolean.parseBoolean(properties.getProperty("hibernate.cache.use_query_cache"))) {
                String query = properties.getProperty("hibernate.cache.infinispan.query.cfg", "local-query");
                String timestamps = properties.getProperty("hibernate.cache.infinispan.timestamps.cfg", "local-query");
                builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)timestamps));
                builder.addDependency(CacheConfigurationService.getServiceName((String)container, (String)query));
            }
        }
    }
}

