/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.management;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.management.OSGiBundleResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.resolver.XBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiRuntimeResource
implements Resource {
    private final InjectedValue<BundleManager> injectedBundleManager;
    private final Resource delegate;

    public OSGiRuntimeResource() {
        this(Resource.Factory.create(), (InjectedValue<BundleManager>)new InjectedValue());
    }

    private OSGiRuntimeResource(Resource resource, InjectedValue<BundleManager> injectedBundleManager) {
        this.injectedBundleManager = injectedBundleManager;
        this.delegate = resource;
    }

    public InjectedValue<BundleManager> getInjectedBundleManager() {
        return this.injectedBundleManager;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("bundle".equals(element.getKey())) {
            return this.hasBundle(element);
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("bundle".equals(element.getKey())) {
            return this.hasBundle(element) ? OSGiBundleResource.INSTANCE : null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("bundle".equals(element.getKey())) {
            if (this.hasBundle(element)) {
                return OSGiBundleResource.INSTANCE;
            }
            throw new Resource.NoSuchResourceException(element);
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("bundle".equals(childType)) {
            return this.getChildrenNames("bundle").size() > 0;
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "bundle".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            return OSGiBundleResource.INSTANCE;
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>(this.delegate.getChildTypes());
        result.add("bundle");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("bundle".equals(childType)) {
            return this.getBundleIDs();
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("bundle".equals(childType)) {
            TreeSet<Resource.ResourceEntry> result = new TreeSet<Resource.ResourceEntry>();
            for (String id : this.getBundleIDs()) {
                result.add(new OSGiBundleResource.OSGiBundleResourceEntry(id));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        if ("bundle".equals(address.getKey())) {
            throw new UnsupportedOperationException();
        }
        this.delegate.registerChild(address, resource);
    }

    public Resource removeChild(PathElement address) {
        if ("bundle".equals(address.getKey())) {
            throw new UnsupportedOperationException();
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        return new OSGiRuntimeResource(this.delegate.clone(), this.injectedBundleManager);
    }

    private boolean hasBundle(PathElement element) {
        boolean result = false;
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getOptionalValue();
        if (bundleManager != null) {
            XBundle bundle2;
            try {
                Long bundleId = Long.parseLong(element.getValue());
                bundle2 = bundleManager.getBundleById(bundleId.longValue());
            }
            catch (NumberFormatException ex) {
                bundle2 = bundleManager.getBundleByLocation(element.getValue());
            }
            result = bundle2 != null;
        }
        return result;
    }

    private Set<String> getBundleIDs() {
        TreeSet<String> result = new TreeSet<String>();
        BundleContext context = this.getBundleContext();
        if (context != null) {
            for (Bundle b : context.getBundles()) {
                result.add(Long.toString(b.getBundleId()));
            }
        }
        return result;
    }

    private BundleContext getBundleContext() {
        BundleContext context;
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getOptionalValue();
        BundleContext bundleContext = context = bundleManager != null ? bundleManager.getSystemBundle().getBundleContext() : null;
        if (context == null) {
            OSGiLogger.LOGGER.debugf("BundleContext not available for management operation", new Object[0]);
        }
        return context;
    }
}

