/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.TreeSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.osgi.parser.FrameworkCapabilityResource;
import org.jboss.as.osgi.parser.Namespace;
import org.jboss.as.osgi.parser.Namespace11;
import org.jboss.as.osgi.parser.OSGiRootResource;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class OSGiSubsystemWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    static OSGiSubsystemWriter INSTANCE = new OSGiSubsystemWriter();

    private OSGiSubsystemWriter() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined("activation")) {
            OSGiRootResource.ACTIVATION.marshallAsAttribute(node, (XMLStreamWriter)writer);
        }
        if (node.hasDefined("property")) {
            writer.writeStartElement(Namespace11.Element.PROPERTIES.getLocalName());
            ModelNode properties = node.get("property");
            for (String key : new TreeSet(properties.keys())) {
                String val = properties.get(key).get("value").asString();
                writer.writeStartElement(Namespace11.Element.PROPERTY.getLocalName());
                writer.writeAttribute(Namespace11.Attribute.NAME.getLocalName(), key);
                writer.writeCharacters(val);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (node.hasDefined("capability")) {
            writer.writeStartElement(Namespace11.Element.CAPABILITIES.getLocalName());
            ModelNode modules = node.get("capability");
            for (String key : modules.keys()) {
                ModelNode moduleNode = modules.get(key);
                writer.writeEmptyElement(Namespace11.Element.CAPABILITY.getLocalName());
                writer.writeAttribute(Namespace11.Attribute.NAME.getLocalName(), key);
                if (!moduleNode.hasDefined("startlevel")) continue;
                FrameworkCapabilityResource.STARTLEVEL.marshallAsAttribute(moduleNode, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

