/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.LayeredBundlePathFactory;
import org.jboss.as.osgi.service.ModuleIdentityRepository;
import org.jboss.as.osgi.service.SystemPackagesIntegration;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentFactory;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractBundleRevisionAdaptor;
import org.jboss.osgi.framework.spi.BootstrapBundlesActivate;
import org.jboss.osgi.framework.spi.BootstrapBundlesInstall;
import org.jboss.osgi.framework.spi.BootstrapBundlesResolve;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.BundleStorage;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.XRequirementBuilder;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleRevisionBuilderFactory;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

class BootstrapBundlesIntegration
extends BootstrapBundlesInstall<Void> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleStorage> injectedStorageProvider = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<PackageAdmin> injectedPackageAdmin = new InjectedValue();
    private final InjectedValue<StartLevel> injectedStartLevel = new InjectedValue();
    private final InjectedValue<SubsystemState> injectedSubsystemState = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XRepository> injectedRepository = new InjectedValue();
    private List<SubsystemState.OSGiCapability> modulecaps;
    private List<File> bundlesPath;

    BootstrapBundlesIntegration() {
        super(IntegrationServices.BOOTSTRAP_BUNDLES);
    }

    protected void addServiceDependencies(ServiceBuilder<Void> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.injectedServerEnvironment);
        builder.addDependency(OSGiConstants.SUBSYSTEM_STATE_SERVICE_NAME, SubsystemState.class, this.injectedSubsystemState);
        builder.addDependency(OSGiConstants.REPOSITORY_SERVICE_NAME, XRepository.class, this.injectedRepository);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.PACKAGE_ADMIN, PackageAdmin.class, this.injectedPackageAdmin);
        builder.addDependency(IntegrationServices.BUNDLE_STORAGE, BundleStorage.class, this.injectedStorageProvider);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedSystemContext);
        builder.addDependency(Services.START_LEVEL, StartLevel.class, this.injectedStartLevel);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
    }

    public synchronized void start(StartContext context) throws StartException {
        ArrayList<Deployment> deployments = new ArrayList<Deployment>();
        try {
            ServerEnvironment serverEnvironment = (ServerEnvironment)this.injectedServerEnvironment.getValue();
            this.bundlesPath = LayeredBundlePathFactory.resolveLayeredBundlePath(serverEnvironment);
            this.modulecaps = new ArrayList<SubsystemState.OSGiCapability>();
            ArrayList<SubsystemState.OSGiCapability> configcaps = new ArrayList<SubsystemState.OSGiCapability>();
            for (String capspec : SystemPackagesIntegration.DEFAULT_CAPABILITIES) {
                configcaps.add(new SubsystemState.OSGiCapability(capspec, null));
            }
            configcaps.addAll(((SubsystemState)this.injectedSubsystemState.getValue()).getCapabilities());
            Iterator iterator = configcaps.iterator();
            while (iterator.hasNext()) {
                SubsystemState.OSGiCapability configcap = (SubsystemState.OSGiCapability)iterator.next();
                if (!this.installInitialModuleCapability(configcap)) continue;
                this.modulecaps.add(configcap);
                iterator.remove();
            }
            for (SubsystemState.OSGiCapability configcap : configcaps) {
                Deployment dep = this.getInitialBundleDeployment(configcap);
                deployments.add(dep);
            }
        }
        catch (Exception ex) {
            throw OSGiMessages.MESSAGES.startFailedToProcessInitialCapabilites(ex);
        }
        this.installBootstrapBundles(context.getChildTarget(), deployments);
    }

    protected ServiceController<Void> installResolveService(ServiceTarget serviceTarget, Set<ServiceName> installedServices) {
        return new BootstrapResolveIntegration(this.getServiceName().getParent(), installedServices).install(serviceTarget, this.getServiceListener());
    }

    private boolean installInitialModuleCapability(SubsystemState.OSGiCapability configcap) throws Exception {
        ModuleIdentifier moduleId;
        File bundleFile;
        String identifier = configcap.getIdentifier();
        if (this.isValidModuleIdentifier(identifier) && (bundleFile = ModuleIdentityRepository.getRepositoryEntry(this.bundlesPath, moduleId = ModuleIdentifier.fromString((String)identifier))) == null) {
            XResource resource;
            Module module;
            OSGiLogger.LOGGER.tracef("Installing initial module capability: %s", identifier);
            try {
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                module = moduleLoader.loadModule(moduleId);
            }
            catch (ModuleLoadException ex) {
                throw OSGiMessages.MESSAGES.cannotResolveInitialCapability(ex, identifier);
            }
            OSGiMetaData metadata = this.getModuleMetadata(module);
            final BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
            XBundleRevisionBuilderFactory factory = new XBundleRevisionBuilderFactory(){

                public XBundleRevision createResource() {
                    return new AbstractBundleRevisionAdaptor(syscontext, module);
                }
            };
            XResourceBuilder builder = XBundleRevisionBuilderFactory.create((XBundleRevisionBuilderFactory)factory);
            if (metadata != null) {
                builder.loadFrom(metadata);
                resource = builder.getResource();
                resource.addAttachment(OSGiMetaData.class, (Object)metadata);
            } else {
                builder.loadFrom(module);
                resource = builder.getResource();
            }
            ((XEnvironment)this.injectedEnvironment.getValue()).installResources(new XResource[]{resource});
            Integer bundleStartLevel = configcap.getStartLevel();
            if (bundleStartLevel != null && bundleStartLevel > 0) {
                StartLevel plugin = (StartLevel)this.injectedStartLevel.getValue();
                Long bundleId = (Long)resource.getAttachment(Long.class);
                XBundle bundle2 = this.getBundleManager().getBundleById(bundleId.longValue());
                plugin.setBundleStartLevel((Bundle)bundle2, bundleStartLevel.intValue());
            }
            return true;
        }
        return false;
    }

    private Deployment getInitialBundleDeployment(SubsystemState.OSGiCapability configcap) throws Exception {
        String identifier = configcap.getIdentifier();
        Integer level = configcap.getStartLevel();
        Deployment deployment = null;
        if (this.isValidModuleIdentifier(identifier)) {
            ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)identifier);
            File bundleFile = ModuleIdentityRepository.getRepositoryEntry(this.bundlesPath, moduleId);
            if (bundleFile != null) {
                OSGiLogger.LOGGER.tracef("Installing initial bundle capability: %s", identifier);
                URL bundleURL = bundleFile.toURI().toURL();
                deployment = this.getDeploymentFromURL(bundleURL, identifier, level);
            }
        } else if (this.isValidMavenIdentifier(identifier)) {
            OSGiLogger.LOGGER.tracef("Installing initial maven capability: %s", identifier);
            XRepository repository = (XRepository)this.injectedRepository.getValue();
            MavenCoordinates mavenId = MavenCoordinates.parse((String)identifier);
            XRequirement req = XRequirementBuilder.create((MavenCoordinates)mavenId).getRequirement();
            Collection caps = repository.findProviders((Requirement)req);
            if (!caps.isEmpty()) {
                XResource resource = (XResource)((Capability)caps.iterator().next()).getResource();
                XCapability ccap = (XCapability)resource.getCapabilities("osgi.content").get(0);
                URL bundleURL = new URL((String)ccap.getAttribute("url"));
                deployment = this.getDeploymentFromURL(bundleURL, identifier, level);
            }
        }
        if (deployment == null) {
            throw OSGiMessages.MESSAGES.cannotResolveInitialCapability(null, identifier);
        }
        return deployment;
    }

    private boolean isValidModuleIdentifier(String identifier) {
        try {
            ModuleIdentifier.fromString((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidMavenIdentifier(String identifier) {
        try {
            MavenCoordinates.parse((String)identifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Deployment getDeploymentFromURL(URL bundleURL, String location, Integer level) throws Exception {
        int startlevel;
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.toVirtualFile((URL)bundleURL), (String)location);
        Deployment dep = DeploymentFactory.createDeployment((BundleInfo)info);
        int n = startlevel = level != null ? level : 0;
        if (startlevel > 0) {
            dep.setStartLevel(Integer.valueOf(level));
            dep.setAutoStart(true);
        }
        BundleStorage storageProvider = (BundleStorage)this.injectedStorageProvider.getValue();
        Long bundleId = ((XEnvironment)this.injectedEnvironment.getValue()).nextResourceIdentifier(null, dep.getSymbolicName());
        StorageState storageState = storageProvider.createStorageState(bundleId.longValue(), location, startlevel, null);
        dep.addAttachment(StorageState.class, (Object)storageState);
        return dep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSGiMetaData getModuleMetadata(Module module) throws IOException {
        URL manifestURL = module.getExportedResource("META-INF/MANIFEST.MF");
        if (manifestURL != null) {
            InputStream input = manifestURL.openStream();
            try {
                Manifest manifest = new Manifest(input);
                if (OSGiManifestBuilder.isValidBundleManifest((Manifest)manifest)) {
                    OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((Manifest)manifest);
                    return oSGiMetaData;
                }
            }
            finally {
                input.close();
            }
        }
        File homeDir = ((ServerEnvironment)this.injectedServerEnvironment.getValue()).getHomeDir();
        File modulesDir = new File(homeDir + File.separator + "modules");
        ModuleIdentifier identifier = module.getIdentifier();
        String identifierPath = identifier.getName().replace('.', File.separatorChar) + File.separator + identifier.getSlot();
        File entryFile = new File(modulesDir + File.separator + identifierPath + File.separator + "jbosgi-xservice.properties");
        if (entryFile.exists()) {
            FileInputStream input = new FileInputStream(entryFile);
            try {
                Properties props = new Properties();
                props.load(input);
                OSGiMetaData oSGiMetaData = OSGiMetaDataBuilder.load((Properties)props);
                return oSGiMetaData;
            }
            finally {
                input.close();
            }
        }
        return null;
    }

    class BootstrapActivateIntegration
    extends BootstrapBundlesActivate<Void> {
        BootstrapActivateIntegration(ServiceName baseName, Set<ServiceName> installedServices) {
            super(baseName, installedServices);
        }

        public void start(StartContext context) throws StartException {
            BundleManager bundleManager = (BundleManager)BootstrapBundlesIntegration.this.injectedBundleManager.getValue();
            for (SubsystemState.OSGiCapability modcap : BootstrapBundlesIntegration.this.modulecaps) {
                if (modcap.getStartLevel() == null) continue;
                String identifier = modcap.getIdentifier();
                XBundle bundle2 = bundleManager.getBundleByLocation(identifier);
                try {
                    bundle2.start(2);
                }
                catch (BundleException ex) {
                    OSGiLogger.LOGGER.errorCannotStartBundle(ex, (Bundle)bundle2);
                }
            }
            super.start(context);
        }
    }

    class BootstrapResolveIntegration
    extends BootstrapBundlesResolve<Void> {
        BootstrapResolveIntegration(ServiceName baseName, Set<ServiceName> installedServices) {
            super(baseName, installedServices);
        }

        protected ServiceController<Void> installActivateService(ServiceTarget serviceTarget, Set<ServiceName> resolvedServices) {
            return new BootstrapActivateIntegration(this.getServiceName().getParent(), resolvedServices).install(serviceTarget, this.getServiceListener());
        }
    }
}

