/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.felix.StatelessResolver;
import org.osgi.service.resolver.Resolver;

class ResolverService
extends AbstractService<Resolver> {
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private XResolver resolver;

    static ServiceController<?> addService(ServiceTarget target) {
        ResolverService service = new ResolverService();
        ServiceBuilder builder = target.addService(OSGiConstants.RESOLVER_SERVICE_NAME, (Service)service);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, service.injectedEnvironment);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        return builder.install();
    }

    private ResolverService() {
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController serviceController = context.getController();
        OSGiLogger.LOGGER.tracef("Starting: %s in mode %s", serviceController.getName(), serviceController.getMode());
        this.resolver = new StatelessResolver();
    }

    public synchronized void stop(StopContext context) {
        ServiceController serviceController = context.getController();
        OSGiLogger.LOGGER.tracef("Stopping: %s in mode %s", serviceController.getName(), serviceController.getMode());
        this.resolver = null;
    }

    public synchronized Resolver getValue() throws IllegalStateException {
        return this.resolver;
    }
}

