/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import java.util.Arrays;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAMessage;
import org.hornetq.ra.HornetQRASession;

public class HornetQRAMapMessage
extends HornetQRAMessage
implements MapMessage {
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();

    public HornetQRAMapMessage(MapMessage message, HornetQRASession session) {
        super((Message)message, session);
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + message + ", " + session + ")");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getBoolean(" + name + ")");
        }
        return ((MapMessage)this.message).getBoolean(name);
    }

    public byte getByte(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getByte(" + name + ")");
        }
        return ((MapMessage)this.message).getByte(name);
    }

    public byte[] getBytes(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getBytes(" + name + ")");
        }
        return ((MapMessage)this.message).getBytes(name);
    }

    public char getChar(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getChar(" + name + ")");
        }
        return ((MapMessage)this.message).getChar(name);
    }

    public double getDouble(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getDouble(" + name + ")");
        }
        return ((MapMessage)this.message).getDouble(name);
    }

    public float getFloat(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getFloat(" + name + ")");
        }
        return ((MapMessage)this.message).getFloat(name);
    }

    public int getInt(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getInt(" + name + ")");
        }
        return ((MapMessage)this.message).getInt(name);
    }

    public long getLong(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getLong(" + name + ")");
        }
        return ((MapMessage)this.message).getLong(name);
    }

    public Enumeration getMapNames() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getMapNames()");
        }
        return ((MapMessage)this.message).getMapNames();
    }

    public Object getObject(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getObject(" + name + ")");
        }
        return ((MapMessage)this.message).getObject(name);
    }

    public short getShort(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getShort(" + name + ")");
        }
        return ((MapMessage)this.message).getShort(name);
    }

    public String getString(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getString(" + name + ")");
        }
        return ((MapMessage)this.message).getString(name);
    }

    public boolean itemExists(String name) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("itemExists(" + name + ")");
        }
        return ((MapMessage)this.message).itemExists(name);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setBoolean(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setBoolean(name, value);
    }

    public void setByte(String name, byte value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setByte(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setByte(name, value);
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setBytes(" + name + ", " + Arrays.toString(value) + ", " + offset + ", " + length + ")");
        }
        ((MapMessage)this.message).setBytes(name, value, offset, length);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setBytes(" + name + ", " + Arrays.toString(value) + ")");
        }
        ((MapMessage)this.message).setBytes(name, value);
    }

    public void setChar(String name, char value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setChar(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setChar(name, value);
    }

    public void setDouble(String name, double value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setDouble(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setDouble(name, value);
    }

    public void setFloat(String name, float value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setFloat(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setFloat(name, value);
    }

    public void setInt(String name, int value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setInt(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setInt(name, value);
    }

    public void setLong(String name, long value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setLong(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setLong(name, value);
    }

    public void setObject(String name, Object value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setObject(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setObject(name, value);
    }

    public void setShort(String name, short value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setShort(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setShort(name, value);
    }

    public void setString(String name, String value) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setString(" + name + ", " + value + ")");
        }
        ((MapMessage)this.message).setString(name, value);
    }
}

