/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.bridge;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.EntityBridge;
import org.jboss.as.cmp.bridge.FieldBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.jdbc.CascadeDeleteStrategy;
import org.jboss.as.cmp.jdbc.JDBCContext;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCParameterSetter;
import org.jboss.as.cmp.jdbc.JDBCResultSetReader;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.RelationData;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.CMRMessage;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMP2xFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.RelationSet;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;

public final class JDBCCMRFieldBridge
extends JDBCAbstractCMRFieldBridge {
    private final JDBCEntityBridge entity;
    private final JDBCStoreManager manager;
    private final JDBCRelationshipRoleMetaData metadata;
    private DataSource dataSource;
    private String qualifiedTableName;
    private String tableName;
    private JDBCCMP2xFieldBridge[] tableKeyFields;
    private JDBCType jdbcType;
    private WeakReference<CmpEntityBeanComponent> relatedContainerRef;
    private JDBCStoreManager relatedManager;
    private JDBCEntityBridge relatedEntity;
    private JDBCCMRFieldBridge relatedCMRField;
    private final Logger log;
    private JDBCCMP2xFieldBridge[] foreignKeyFields;
    private boolean allFKFieldsMappedToPKFields;
    private final Map relatedPKFieldsByMyPKFields = new HashMap();
    private final Map relatedPKFieldsByMyFKFields = new HashMap();
    private boolean hasFKFieldsMappedToCMPFields;
    private TransactionLocal relatedPKValuesWaitingForMyPK;
    private Method relatedFindByPrimaryKey;
    private final int jdbcContextIndex;
    private CascadeDeleteStrategy cascadeDeleteStrategy;
    private RelationDataManager relationManager;
    private static final RelationDataManager EMPTY_RELATION_MANAGER = new RelationDataManager(){

        @Override
        public void addRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
        }

        @Override
        public void removeRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
        }

        @Override
        public boolean isDirty() {
            return false;
        }

        @Override
        public RelationData getRelationData() {
            throw CmpMessages.MESSAGES.getRelationDataNotSupported();
        }
    };

    public JDBCCMRFieldBridge(JDBCEntityBridge entity, JDBCStoreManager manager, JDBCRelationshipRoleMetaData metadata) {
        this.entity = entity;
        this.manager = manager;
        this.metadata = metadata;
        this.jdbcContextIndex = ((JDBCEntityBridge)manager.getEntityBridge()).getNextJDBCContextIndex();
        String categoryName = this.getClass().getName() + "." + manager.getMetaData().getName() + ".";
        categoryName = metadata.getCMRFieldName() != null ? categoryName + metadata.getCMRFieldName() : categoryName + metadata.getRelatedRole().getEntity().getName() + "-" + metadata.getRelatedRole().getCMRFieldName();
        this.log = Logger.getLogger((String)categoryName);
    }

    public RelationDataManager getRelationDataManager() {
        return this.relationManager;
    }

    public void resolveRelationship() {
        String relatedEntityName = this.metadata.getRelatedRole().getEntity().getName();
        Catalog catalog = this.manager.getCatalog();
        this.relatedEntity = (JDBCEntityBridge)catalog.getEntityByEJBName(relatedEntityName);
        if (this.relatedEntity == null) {
            throw CmpMessages.MESSAGES.relatedEntityNotFound(this.getEntity().getEntityName(), this.getFieldName(), relatedEntityName);
        }
        JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])this.relatedEntity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCCMRFieldBridge cmrField = cmrFields[i];
            if (this.metadata.getRelatedRole() != cmrField.getMetaData()) continue;
            this.relatedCMRField = cmrField;
            break;
        }
        if (this.relatedCMRField == null) {
            throw CmpMessages.MESSAGES.relatedCmrFieldNotFound(relatedEntityName, this.entity.getEntityName(), this.getFieldName() != null ? this.getFieldName() : "<no-field>", relatedEntityName, this.metadata.getRelatedRole().getCMRFieldName() != null ? this.metadata.getRelatedRole().getCMRFieldName() : "<no-field>");
        }
        this.relatedManager = (JDBCStoreManager)this.relatedEntity.getManager();
        CmpEntityBeanComponent relatedComponent = this.relatedManager.getComponent();
        this.relatedContainerRef = new WeakReference<CmpEntityBeanComponent>(relatedComponent);
        Class homeClass = relatedComponent.getLocalHomeClass() != null ? relatedComponent.getLocalHomeClass() : relatedComponent.getHomeClass();
        try {
            this.relatedFindByPrimaryKey = homeClass.getMethod("findByPrimaryKey", this.relatedEntity.getPrimaryKeyClass());
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.findByPrimaryKeyNotFound(this.relatedEntity.getPrimaryKeyClass().getName(), homeClass.getName());
        }
        if (this.metadata.getRelationMetaData().isTableMappingStyle()) {
            Collection<JDBCCMPFieldMetaData> tableKeys = this.metadata.getKeyFields();
            ArrayList keyFieldsList = new ArrayList(tableKeys.size());
            HashMap<FieldBridge, JDBCCMP2xFieldBridge> pkFieldsToFKFields = new HashMap<FieldBridge, JDBCCMP2xFieldBridge>(tableKeys.size());
            for (JDBCCMPFieldMetaData cmpFieldMetaData : tableKeys) {
                FieldBridge pkField = this.entity.getFieldByName(cmpFieldMetaData.getFieldName());
                if (pkField == null) {
                    throw CmpMessages.MESSAGES.pkNotFoundForKeyField(cmpFieldMetaData.getFieldName());
                }
                pkFieldsToFKFields.put(pkField, new JDBCCMP2xFieldBridge(this.manager, cmpFieldMetaData));
            }
            JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
            for (int i = 0; i < pkFields.length; ++i) {
                Object fkField = pkFieldsToFKFields.get(pkFields[i]);
                if (fkField == null) {
                    throw CmpMessages.MESSAGES.primaryKeyNotMapped(pkFields[i].getFieldName());
                }
                keyFieldsList.add(fkField);
            }
            this.tableKeyFields = keyFieldsList.toArray(new JDBCCMP2xFieldBridge[keyFieldsList.size()]);
            this.dataSource = this.manager.getDataSource(this.metadata.getRelationMetaData().getDataSourceName());
        } else {
            this.initializeForeignKeyFields();
            this.dataSource = this.hasForeignKey() ? this.entity.getDataSource() : this.relatedEntity.getDataSource();
        }
        this.qualifiedTableName = SQLUtil.fixTableName(this.metadata.getRelationMetaData().getDefaultTableName(), this.dataSource);
        this.tableName = SQLUtil.getTableNameWithoutSchema(this.qualifiedTableName);
        this.relationManager = this.relatedCMRField.initRelationManager(this);
    }

    public void start() {
        this.cascadeDeleteStrategy = CascadeDeleteStrategy.getCascadeDeleteStrategy(this);
        this.relatedPKValuesWaitingForMyPK = new TransactionLocal(this.manager.getComponent().getTransactionManager()){

            protected Object initialValue() {
                return new HashMap();
            }

            public Transaction getTransaction() {
                try {
                    return this.transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw CmpMessages.MESSAGES.errorGettingCurrentTransaction(e);
                }
            }
        };
    }

    public boolean removeFromRelations(CmpEntityBeanContext ctx, Object[] oldRelationsRef) {
        this.load(ctx);
        FieldState fieldState = this.getFieldState(ctx);
        List value = fieldState.getValue();
        boolean removed = false;
        if (!value.isEmpty()) {
            if (this.hasFKFieldsMappedToCMPFields) {
                if (this.isForeignKeyValid(value.get(0))) {
                    this.cascadeDeleteStrategy.removedIds(ctx, oldRelationsRef, value);
                    removed = true;
                }
            } else {
                this.cascadeDeleteStrategy.removedIds(ctx, oldRelationsRef, value);
                removed = true;
            }
        }
        return removed;
    }

    public void cascadeDelete(CmpEntityBeanContext ctx, List oldValues) throws RemoveException, RemoteException {
        this.cascadeDeleteStrategy.cascadeDelete(ctx, oldValues);
    }

    public boolean isBatchCascadeDelete() {
        return this.cascadeDeleteStrategy instanceof CascadeDeleteStrategy.BatchCascadeDeleteStrategy;
    }

    public JDBCStoreManager getJDBCStoreManager() {
        return this.manager;
    }

    @Override
    public JDBCAbstractEntityBridge getEntity() {
        return this.entity;
    }

    @Override
    public JDBCRelationshipRoleMetaData getMetaData() {
        return this.metadata;
    }

    public JDBCRelationMetaData getRelationMetaData() {
        return this.metadata.getRelationMetaData();
    }

    @Override
    public String getFieldName() {
        return this.metadata.getCMRFieldName();
    }

    @Override
    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.metadata.getReadAhead();
    }

    @Override
    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    @Override
    public boolean isPrimaryKeyMember() {
        return false;
    }

    @Override
    public boolean hasForeignKey() {
        return this.foreignKeyFields != null;
    }

    public boolean allFkFieldsMappedToPkFields() {
        return this.allFKFieldsMappedToPKFields;
    }

    public boolean isCollectionValued() {
        return this.metadata.getRelatedRole().isMultiplicityMany();
    }

    @Override
    public boolean isSingleValued() {
        return this.metadata.getRelatedRole().isMultiplicityOne();
    }

    @Override
    public JDBCFieldBridge[] getTableKeyFields() {
        return this.tableKeyFields;
    }

    @Override
    public JDBCFieldBridge[] getForeignKeyFields() {
        return this.foreignKeyFields;
    }

    @Override
    public JDBCAbstractCMRFieldBridge getRelatedCMRField() {
        return this.relatedCMRField;
    }

    public JDBCStoreManager getRelatedManager() {
        return this.relatedManager;
    }

    @Override
    public EntityBridge getRelatedEntity() {
        return this.relatedEntity;
    }

    public JDBCEntityBridge getRelatedJDBCEntity() {
        return this.relatedEntity;
    }

    public CmpEntityBeanComponent getRelatedComponent() {
        return (CmpEntityBeanComponent)((Object)this.relatedContainerRef.get());
    }

    public Class getRelatedLocalInterface() {
        return this.getRelatedComponent().getStoreManager().getEntityBridge().getLocalInterface();
    }

    @Override
    public boolean isLoaded(CmpEntityBeanContext ctx) {
        return this.getFieldState(ctx).isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelatedPKsWaitedForMe(CmpEntityBeanContext ctx) {
        Map relatedPKsMap;
        Map map = relatedPKsMap = this.getRelatedPKsWaitingForMyPK();
        synchronized (map) {
            List relatedPKsWaitingForMe = (List)relatedPKsMap.get(ctx.getPrimaryKeyUnchecked());
            if (relatedPKsWaitingForMe != null) {
                Iterator waitingPKsIter = relatedPKsWaitingForMe.iterator();
                while (waitingPKsIter.hasNext()) {
                    Object waitingPK = waitingPKsIter.next();
                    waitingPKsIter.remove();
                    if (!this.isForeignKeyValid(waitingPK)) continue;
                    this.createRelationLinks(ctx, waitingPK);
                }
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.getRelationMetaData().isReadOnly();
    }

    @Override
    public boolean isReadTimedOut(CmpEntityBeanContext ctx) {
        if (!this.isReadOnly()) {
            return true;
        }
        if (this.getRelationMetaData().getReadTimeOut() == -1) {
            return false;
        }
        long readInterval = System.currentTimeMillis() - this.getFieldState(ctx).getLastRead();
        return readInterval > (long)this.getRelationMetaData().getReadTimeOut();
    }

    @Override
    public Object getValue(CmpEntityBeanContext ctx) {
        return this.getInstanceValue(ctx);
    }

    @Override
    public void setValue(CmpEntityBeanContext ctx, Object value) {
        if (this.isReadOnly()) {
            throw CmpMessages.MESSAGES.fieldIsReadOnly(this.getFieldName());
        }
        if (!JDBCEntityBridge.isEjbCreateDone(ctx)) {
            throw CmpMessages.MESSAGES.cmrFieldCannotBeSetInEjbCreate();
        }
        if (this.isCollectionValued() && value == null) {
            throw CmpMessages.MESSAGES.cmrCollectionFieldsCanNotBeSetToNull();
        }
        this.setInstanceValue(ctx, value);
    }

    @Override
    public Object getInstanceValue(CmpEntityBeanContext myCtx) {
        this.load(myCtx);
        FieldState fieldState = this.getFieldState(myCtx);
        if (this.isCollectionValued()) {
            return fieldState.getRelationSet();
        }
        try {
            Object relatedId;
            List value = fieldState.getValue();
            if (!value.isEmpty()) {
                Object fk = value.get(0);
                return this.getRelatedEntityByFK(fk);
            }
            if (this.foreignKeyFields != null && (relatedId = this.getRelatedIdFromContext(myCtx)) != null) {
                return this.getRelatedEntityByFK(relatedId);
            }
            return null;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorGettingInstanceValue(e);
        }
    }

    public EJBLocalObject getRelatedEntityByFK(Object fk) {
        EJBLocalObject relatedLocalObject = null;
        CmpEntityBeanComponent relatedContainer = this.getRelatedComponent();
        if (this.hasFKFieldsMappedToCMPFields && this.relatedManager.getReadAheadCache().getPreloadDataMap(fk, false) == null) {
            try {
                relatedLocalObject = relatedContainer.getEJBLocalObject(fk);
            }
            catch (Exception ignore) {}
        } else {
            relatedLocalObject = relatedContainer.getEJBLocalObject(fk);
        }
        return relatedLocalObject;
    }

    public boolean isForeignKeyValid(Object fk) {
        boolean valid;
        if (this.relatedManager.getReadAheadCache().getPreloadDataMap(fk, false) != null) {
            valid = true;
        } else {
            try {
                EJBLocalObject result = this.getRelatedComponent().getEJBLocalObject(fk);
                valid = result != null;
            }
            catch (Exception ignore) {
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public void setInstanceValue(CmpEntityBeanContext myCtx, Object newValue) {
        List<Object> newPks;
        if (newValue instanceof Collection) {
            Collection col = (Collection)newValue;
            if (!col.isEmpty()) {
                newPks = new ArrayList<Object>(col.size());
                for (Object localObject : col) {
                    Object relatedId;
                    if (localObject == null) continue;
                    try {
                        relatedId = this.getRelatedPrimaryKey(localObject);
                    }
                    catch (TransactionRolledbackLocalException e) {
                        throw CmpMessages.MESSAGES.instanceAlreadyRemoved((Exception)((Object)e));
                    }
                    if (this.relatedPKFieldsByMyPKFields.size() > 0) {
                        this.checkSetForeignKey(myCtx, relatedId);
                    }
                    newPks.add(relatedId);
                }
            } else {
                newPks = Collections.EMPTY_LIST;
            }
        } else if (newValue != null) {
            try {
                newPks = Collections.singletonList(this.getRelatedPrimaryKey(newValue));
            }
            catch (TransactionRolledbackLocalException e) {
                throw CmpMessages.MESSAGES.instanceAlreadyRemoved((Exception)((Object)e));
            }
        } else {
            newPks = Collections.EMPTY_LIST;
        }
        this.load(myCtx);
        FieldState fieldState = this.getFieldState(myCtx);
        if (newValue == fieldState.getRelationSet()) {
            return;
        }
        try {
            List value = fieldState.getValue();
            if (!value.isEmpty()) {
                Object[] curPks = value.toArray(new Object[value.size()]);
                for (int i = 0; i < curPks.length; ++i) {
                    this.destroyRelationLinks(myCtx, curPks[i]);
                }
            }
            for (int i = 0; i < newPks.size(); ++i) {
                this.createRelationLinks(myCtx, newPks.get(i));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkSetForeignKey(CmpEntityBeanContext myCtx, Object newValue) throws IllegalStateException {
        JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            Object currentValue;
            Object comingValue;
            JDBCCMP2xFieldBridge pkField = (JDBCCMP2xFieldBridge)pkFields[i];
            JDBCCMP2xFieldBridge relatedPkField = (JDBCCMP2xFieldBridge)this.relatedPKFieldsByMyPKFields.get(pkField);
            if (relatedPkField == null || (comingValue = relatedPkField.getPrimaryKeyValue(newValue)).equals(currentValue = pkField.getInstanceValue(myCtx))) continue;
            throw CmpMessages.MESSAGES.cannotCreateRelationship(this.entity.getEntityName(), this.getFieldName(), currentValue, comingValue);
        }
    }

    public void createRelationLinks(CmpEntityBeanContext myCtx, Object relatedId) {
        this.createRelationLinks(myCtx, relatedId, true);
    }

    public void createRelationLinks(CmpEntityBeanContext myCtx, Object relatedId, boolean updateForeignKey) {
        Object oldRelatedId;
        if (this.isReadOnly()) {
            throw CmpMessages.MESSAGES.fieldIsReadOnly(this.getFieldName());
        }
        if (this.metadata.isMultiplicityOne() && (oldRelatedId = this.relatedCMRField.invokeGetRelatedId(relatedId)) != null) {
            this.invokeRemoveRelation(oldRelatedId, relatedId);
            this.relatedCMRField.invokeRemoveRelation(relatedId, oldRelatedId);
        }
        this.addRelation(myCtx, relatedId, updateForeignKey);
        this.relatedCMRField.invokeAddRelation(relatedId, myCtx.getPrimaryKeyUnchecked());
    }

    public void destroyRelationLinks(CmpEntityBeanContext myCtx, Object relatedId) {
        this.destroyRelationLinks(myCtx, relatedId, true);
    }

    public void destroyRelationLinks(CmpEntityBeanContext myCtx, Object relatedId, boolean updateValueCollection) {
        this.destroyRelationLinks(myCtx, relatedId, updateValueCollection, true);
    }

    public void destroyRelationLinks(CmpEntityBeanContext myCtx, Object relatedId, boolean updateValueCollection, boolean updateForeignKey) {
        if (this.isReadOnly()) {
            throw CmpMessages.MESSAGES.fieldIsReadOnly(this.getFieldName());
        }
        this.removeRelation(myCtx, relatedId, updateValueCollection, updateForeignKey);
        this.relatedCMRField.invokeRemoveRelation(relatedId, myCtx.getPrimaryKeyUnchecked());
    }

    public void scheduleChildrenForCascadeDelete(CmpEntityBeanContext ctx) {
        this.load(ctx);
        FieldState fieldState = this.getFieldState(ctx);
        List value = fieldState.getValue();
        if (!value.isEmpty()) {
            Transaction tx = this.getTransaction();
            for (int i = 0; i < value.size(); ++i) {
                this.relatedCMRField.invokeScheduleForCascadeDelete(value.get(i));
            }
        }
    }

    public void scheduleChildrenForBatchCascadeDelete(CmpEntityBeanContext ctx) {
        this.load(ctx);
        FieldState fieldState = this.getFieldState(ctx);
        List value = fieldState.getValue();
        if (!value.isEmpty()) {
            Transaction tx = this.getTransaction();
            for (int i = 0; i < value.size(); ++i) {
                this.relatedCMRField.invokeScheduleForBatchCascadeDelete(value.get(i));
            }
        }
    }

    private void invokeScheduleForCascadeDelete(Object myId) {
        try {
            this.getManager().getComponent().invoke(CMRMessage.SCHEDULE_FOR_CASCADE_DELETE, myId, this);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorInScheduleCascadeDelete(e);
        }
    }

    private void invokeScheduleForBatchCascadeDelete(Object myId) {
        try {
            this.getManager().getComponent().invoke(CMRMessage.SCHEDULE_FOR_BATCH_CASCADE_DELETE, myId, this);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorInScheduleBatchCascadeDelete(e);
        }
    }

    private Object invokeGetRelatedId(Object myId) {
        try {
            return this.getManager().getComponent().invoke(CMRMessage.GET_RELATED_ID, myId, this);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorGetRelatedId(e);
        }
    }

    private void invokeAddRelation(Object myId, Object relatedId) {
        try {
            this.getManager().getComponent().invoke(CMRMessage.ADD_RELATION, myId, this, relatedId);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorAddRelation(e);
        }
    }

    private void invokeRemoveRelation(Object myId, Object relatedId) {
        try {
            this.getManager().getComponent().invoke(CMRMessage.REMOVE_RELATION, myId, this, relatedId);
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.errorRemoveRelation(e);
        }
    }

    public Object getRelatedId(CmpEntityBeanContext myCtx) {
        if (this.isCollectionValued()) {
            throw CmpMessages.MESSAGES.getRelatedOnlyForMuliOfOne();
        }
        this.load(myCtx);
        List value = this.getFieldState(myCtx).getValue();
        return value.isEmpty() ? null : value.get(0);
    }

    public Object getRelatedIdFromContext(CmpEntityBeanContext ctx) {
        Object relatedId = null;
        for (JDBCCMP2xFieldBridge fkField : this.foreignKeyFields) {
            Object fkFieldValue = fkField.getInstanceValue(ctx);
            if (fkFieldValue == null) {
                return null;
            }
            JDBCCMP2xFieldBridge relatedPKField = (JDBCCMP2xFieldBridge)this.relatedPKFieldsByMyFKFields.get(fkField);
            relatedId = relatedPKField.setPrimaryKeyValue(relatedId, fkFieldValue);
        }
        return relatedId;
    }

    public void addRelation(CmpEntityBeanContext myCtx, Object fk) {
        this.addRelation(myCtx, fk, true);
        this.relationManager.addRelation(this, myCtx.getPrimaryKeyUnchecked(), this.relatedCMRField, fk);
    }

    private void addRelation(CmpEntityBeanContext myCtx, Object fk, boolean updateForeignKey) {
        this.checkSetForeignKey(myCtx, fk);
        if (this.isReadOnly()) {
            throw CmpMessages.MESSAGES.fieldIsReadOnly(this.getFieldName());
        }
        if (!JDBCEntityBridge.isEjbCreateDone(myCtx)) {
            throw CmpMessages.MESSAGES.cmrFieldCannotBeSetOrAddedInEjbCreate();
        }
        FieldState myState = this.getFieldState(myCtx);
        myState.addRelation(fk);
        if (this.hasForeignKey() && updateForeignKey) {
            this.setForeignKey(myCtx, fk);
        }
    }

    public void removeRelation(CmpEntityBeanContext myCtx, Object fk) {
        this.removeRelation(myCtx, fk, true, true);
        this.relationManager.removeRelation(this, myCtx.getPrimaryKeyUnchecked(), this.relatedCMRField, fk);
    }

    private void removeRelation(CmpEntityBeanContext myCtx, Object fk, boolean updateValueCollection, boolean updateForeignKey) {
        if (this.isReadOnly()) {
            throw CmpMessages.MESSAGES.fieldIsReadOnly(this.getFieldName());
        }
        if (updateValueCollection) {
            FieldState myState = this.getFieldState(myCtx);
            myState.removeRelation(fk);
        }
        if (this.hasForeignKey() && updateForeignKey) {
            this.setForeignKey(myCtx, null);
        }
    }

    private void load(CmpEntityBeanContext myCtx) {
        Collection<Object> values;
        FieldState fieldState = this.getFieldState(myCtx);
        if (fieldState.isLoaded()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Read ahead cache load: cmrField=" + this.getFieldName() + " pk=" + myCtx.getPrimaryKeyUnchecked()));
        }
        this.manager.getReadAheadCache().load(myCtx);
        if (fieldState.isLoaded()) {
            return;
        }
        if (this.hasForeignKey()) {
            boolean loadWithManager = false;
            Object fk = null;
            for (int i = 0; i < this.foreignKeyFields.length; ++i) {
                JDBCCMP2xFieldBridge fkField = this.foreignKeyFields[i];
                if (!fkField.isLoaded(myCtx)) {
                    loadWithManager = true;
                    break;
                }
                Object fkFieldValue = fkField.getInstanceValue(myCtx);
                if (fkFieldValue == null) {
                    fk = null;
                    break;
                }
                JDBCCMP2xFieldBridge relatedPKField = (JDBCCMP2xFieldBridge)this.relatedPKFieldsByMyFKFields.get(fkField);
                fk = relatedPKField.setPrimaryKeyValue(fk, fkFieldValue);
            }
            values = loadWithManager ? this.manager.loadRelation(this, myCtx.getPrimaryKeyUnchecked()) : (fk == null ? Collections.EMPTY_LIST : Collections.singletonList(fk));
        } else {
            values = this.manager.loadRelation(this, myCtx.getPrimaryKeyUnchecked());
        }
        this.load(myCtx, values);
    }

    public void load(CmpEntityBeanContext myCtx, Collection values) {
        if (this.isSingleValued() && values.size() > 1) {
            throw CmpMessages.MESSAGES.singleValuedFieldHasMultipleValues(values);
        }
        FieldState fieldState = this.getFieldState(myCtx);
        fieldState.loadRelations(values);
        if (this.hasForeignKey()) {
            List realValue;
            if (!values.isEmpty()) {
                Object loadedValue = values.iterator().next();
                for (int i = 0; i < this.foreignKeyFields.length; ++i) {
                    JDBCCMP2xFieldBridge fkField = this.foreignKeyFields[i];
                    Object fieldValue = fkField.getPrimaryKeyValue(loadedValue);
                    fkField.updateState(myCtx, fieldValue);
                }
            }
            Object fk = (realValue = fieldState.getValue()).isEmpty() ? null : realValue.get(0);
            this.setForeignKey(myCtx, fk);
        }
        JDBCEntityBridge.setCreated(myCtx);
    }

    public void setForeignKey(CmpEntityBeanContext myCtx, Object fk) {
        if (!this.hasForeignKey()) {
            throw CmpMessages.MESSAGES.cmrFieldNoForeignKeySet(this.getFieldName());
        }
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge fkField = this.foreignKeyFields[i];
            Object fieldValue = fkField.getPrimaryKeyValue(fk);
            fkField.setInstanceValue(myCtx, fieldValue);
        }
    }

    @Override
    public void initInstance(CmpEntityBeanContext ctx) {
        this.getFieldState(ctx).loadRelations(Collections.EMPTY_SET);
        if (this.foreignKeyFields == null) {
            return;
        }
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge foreignKeyField = this.foreignKeyFields[i];
            if (foreignKeyField.isFKFieldMappedToCMPField()) continue;
            foreignKeyField.setInstanceValue(ctx, null);
        }
    }

    @Override
    public void resetPersistenceContext(CmpEntityBeanContext ctx) {
        if (!this.isReadTimedOut(ctx)) {
            return;
        }
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        jdbcCtx.setFieldState(this.jdbcContextIndex, null);
        if (this.foreignKeyFields == null) {
            return;
        }
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge foreignKeyField = this.foreignKeyFields[i];
            if (foreignKeyField.isFKFieldMappedToCMPField()) continue;
            foreignKeyField.resetPersistenceContext(ctx);
        }
    }

    @Override
    public int setInstanceParameters(PreparedStatement ps, int parameterIndex, CmpEntityBeanContext ctx) {
        if (this.foreignKeyFields == null) {
            return parameterIndex;
        }
        List value = this.getFieldState(ctx).getValue();
        Object fk = value.isEmpty() ? null : value.get(0);
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            parameterIndex = this.foreignKeyFields[i].setPrimaryKeyParameters(ps, parameterIndex, fk);
        }
        return parameterIndex;
    }

    @Override
    public int loadInstanceResults(ResultSet rs, int parameterIndex, CmpEntityBeanContext ctx) {
        if (!this.hasForeignKey()) {
            return parameterIndex;
        }
        Object[] ref = new Object[1];
        parameterIndex = this.loadArgumentResults(rs, parameterIndex, ref);
        FieldState fieldState = this.getFieldState(ctx);
        if (!fieldState.isLoaded()) {
            if (ref[0] != null) {
                this.load(ctx, Collections.singleton(ref[0]));
            } else {
                this.load(ctx, Collections.EMPTY_SET);
            }
        }
        return parameterIndex;
    }

    @Override
    public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] fkRef) {
        if (this.foreignKeyFields == null) {
            return parameterIndex;
        }
        boolean fkIsNull = false;
        Object[] argumentRef = new Object[1];
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge field = this.foreignKeyFields[i];
            parameterIndex = field.loadArgumentResults(rs, parameterIndex, argumentRef);
            if (fkIsNull) continue;
            if (field.getPrimaryKeyField() != null) {
                if (argumentRef[0] == null) {
                    fkRef[0] = null;
                    fkIsNull = true;
                    continue;
                }
                if (fkRef[0] == null) {
                    fkRef[0] = this.relatedEntity.createPrimaryKeyInstance();
                }
                try {
                    field.getPrimaryKeyField().set(fkRef[0], argumentRef[0]);
                    continue;
                }
                catch (Exception e) {
                    throw CmpMessages.MESSAGES.errorSettingFk(this.getFieldName(), e);
                }
            }
            fkRef[0] = argumentRef[0];
        }
        return parameterIndex;
    }

    @Override
    public boolean isDirty(CmpEntityBeanContext ctx) {
        return this.foreignKeyFields == null ? this.relationManager.isDirty() : false;
    }

    public boolean invalidateCache(CmpEntityBeanContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
        return fieldState == null ? false : fieldState.isChanged();
    }

    @Override
    public void setClean(CmpEntityBeanContext ctx) {
        throw CmpMessages.MESSAGES.setCleanNotSupported();
    }

    @Override
    public boolean isCMPField() {
        return false;
    }

    @Override
    public JDBCEntityPersistenceStore getManager() {
        return this.manager;
    }

    public boolean hasFKFieldsMappedToCMPFields() {
        return this.hasFKFieldsMappedToCMPFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelatedPKWaitingForMyPK(Object myPK, Object relatedPK) {
        Map relatedPKsWaitingForMyPK;
        Map map = relatedPKsWaitingForMyPK = this.getRelatedPKsWaitingForMyPK();
        synchronized (map) {
            ArrayList<Object> relatedPKs = (ArrayList<Object>)relatedPKsWaitingForMyPK.get(myPK);
            if (relatedPKs == null) {
                relatedPKs = new ArrayList<Object>(1);
                relatedPKsWaitingForMyPK.put(myPK, relatedPKs);
            }
            relatedPKs.add(relatedPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelatedPKWaitingForMyPK(Object myPK, Object relatedPK) {
        Map relatedPKMap;
        Map map = relatedPKMap = this.getRelatedPKsWaitingForMyPK();
        synchronized (map) {
            List relatedPKs = (List)relatedPKMap.get(myPK);
            if (relatedPKs != null) {
                relatedPKs.remove(relatedPK);
            }
        }
    }

    private FieldState getFieldState(CmpEntityBeanContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
        if (fieldState == null) {
            fieldState = new FieldState(ctx);
            jdbcCtx.setFieldState(this.jdbcContextIndex, fieldState);
        }
        return fieldState;
    }

    private void initializeForeignKeyFields() {
        Collection<JDBCCMPFieldMetaData> foreignKeys = this.metadata.getRelatedRole().getKeyFields();
        HashMap<JDBCCMP2xFieldBridge, JDBCCMP2xFieldBridge> fkFieldsByRelatedPKFields = new HashMap<JDBCCMP2xFieldBridge, JDBCCMP2xFieldBridge>();
        for (JDBCCMPFieldMetaData fkFieldMetaData : foreignKeys) {
            JDBCCMP2xFieldBridge relatedPKField = (JDBCCMP2xFieldBridge)this.relatedEntity.getFieldByName(fkFieldMetaData.getFieldName());
            String fkColumnName = fkFieldMetaData.getColumnName();
            JDBCCMP2xFieldBridge fkField = null;
            JDBCFieldBridge[] tableFields = this.entity.getTableFields();
            for (int tableInd = 0; tableInd < tableFields.length && fkField == null; ++tableInd) {
                JDBCCMP2xFieldBridge cmpField = (JDBCCMP2xFieldBridge)tableFields[tableInd];
                if (!fkColumnName.equals(cmpField.getColumnName())) continue;
                this.hasFKFieldsMappedToCMPFields = true;
                fkField = new JDBCCMP2xFieldBridge((JDBCStoreManager)cmpField.getManager(), relatedPKField.getFieldName(), relatedPKField.getFieldType(), cmpField.getJDBCType(), relatedPKField.isReadOnly(), relatedPKField.getReadTimeOut(), relatedPKField.getPrimaryKeyClass(), relatedPKField.getPrimaryKeyField(), cmpField, this, fkColumnName);
                if (!cmpField.isPrimaryKeyMember()) continue;
                this.relatedPKFieldsByMyPKFields.put(cmpField, relatedPKField);
            }
            if (fkField == null) {
                fkField = new JDBCCMP2xFieldBridge(this.manager, fkFieldMetaData, this.manager.getJDBCTypeFactory().getJDBCType(fkFieldMetaData));
            }
            fkFieldsByRelatedPKFields.put(relatedPKField, fkField);
            this.relatedPKFieldsByMyFKFields.put(fkField, relatedPKField);
        }
        if (fkFieldsByRelatedPKFields.size() > 0) {
            JDBCFieldBridge[] relatedPKFields = this.relatedEntity.getPrimaryKeyFields();
            ArrayList<JDBCCMPFieldBridge> fkList = new ArrayList<JDBCCMPFieldBridge>(relatedPKFields.length);
            for (int i = 0; i < relatedPKFields.length; ++i) {
                JDBCCMPFieldBridge fkField = (JDBCCMPFieldBridge)fkFieldsByRelatedPKFields.remove(relatedPKFields[i]);
                fkList.add(fkField);
            }
            this.foreignKeyFields = fkList.toArray(new JDBCCMP2xFieldBridge[fkList.size()]);
        } else {
            this.foreignKeyFields = null;
        }
        boolean bl = this.allFKFieldsMappedToPKFields = this.relatedPKFieldsByMyPKFields.size() > 0 && this.relatedPKFieldsByMyPKFields.size() == this.foreignKeyFields.length;
        if (this.foreignKeyFields != null) {
            this.jdbcType = new CMRJDBCType(Arrays.asList(this.foreignKeyFields));
        }
    }

    private Transaction getTransaction() {
        try {
            CmpEntityBeanComponent component = this.getJDBCStoreManager().getComponent();
            TransactionManager tm = component.getTransactionManager();
            return tm.getTransaction();
        }
        catch (SystemException e) {
            throw CmpMessages.MESSAGES.errorGettingTxFromManager((Exception)((Object)e));
        }
    }

    private Map getRelatedPKsWaitingForMyPK() {
        return (Map)this.relatedPKValuesWaitingForMyPK.get();
    }

    private RelationDataManager initRelationManager(JDBCCMRFieldBridge relatedField) {
        if (this.relationManager == null) {
            this.relationManager = this.metadata.getRelationMetaData().isTableMappingStyle() ? new M2MRelationManager(this, relatedField) : EMPTY_RELATION_MANAGER;
        }
        return this.relationManager;
    }

    private Object getRelatedPrimaryKey(Object localObject) {
        Object relatedId;
        if (this.relatedEntity.getLocalInterface().isAssignableFrom(localObject.getClass())) {
            EJBLocalObject local = (EJBLocalObject)localObject;
            try {
                relatedId = local.getPrimaryKey();
            }
            catch (NoSuchObjectLocalException e) {
                throw CmpMessages.MESSAGES.noSuchRelatedObject((Exception)((Object)e));
            }
        } else {
            throw CmpMessages.MESSAGES.invalidCmrFieldValue(this.relatedEntity.getLocalInterface().getName());
        }
        return relatedId;
    }

    public String toString() {
        return this.entity.getEntityName() + '.' + this.getFieldName();
    }

    public static class M2MRelationManager
    implements RelationDataManager {
        private final JDBCCMRFieldBridge leftField;
        private final JDBCCMRFieldBridge rightField;
        private final TransactionLocal relationData;

        public M2MRelationManager(final JDBCCMRFieldBridge leftField, final JDBCCMRFieldBridge rightField) {
            this.leftField = leftField;
            this.rightField = rightField;
            this.relationData = new TransactionLocal(leftField.manager.getComponent().getTransactionManager()){

                protected Object initialValue() {
                    return new RelationData(leftField, rightField);
                }

                public Transaction getTransaction() {
                    try {
                        return this.transactionManager.getTransaction();
                    }
                    catch (SystemException e) {
                        throw CmpMessages.MESSAGES.errorGettingCurrentTransaction(e);
                    }
                }
            };
        }

        @Override
        public void addRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
            RelationData local = this.getRelationData();
            local.addRelation(field, id, relatedField, relatedId);
        }

        @Override
        public void removeRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
            RelationData local = this.getRelationData();
            local.removeRelation(field, id, relatedField, relatedId);
        }

        @Override
        public boolean isDirty() {
            RelationData local = this.getRelationData();
            return local.isDirty();
        }

        @Override
        public RelationData getRelationData() {
            RelationData local = (RelationData)this.relationData.get();
            return local;
        }
    }

    public static interface RelationDataManager {
        public void addRelation(JDBCCMRFieldBridge var1, Object var2, JDBCCMRFieldBridge var3, Object var4);

        public void removeRelation(JDBCCMRFieldBridge var1, Object var2, JDBCCMRFieldBridge var3, Object var4);

        public boolean isDirty();

        public RelationData getRelationData();
    }

    private static final class TxSynchronization
    implements Synchronization {
        private final WeakReference fieldStateRef;

        private TxSynchronization(FieldState fieldState) {
            if (fieldState == null) {
                throw CmpMessages.MESSAGES.fieldStateIsNull();
            }
            this.fieldStateRef = new WeakReference<FieldState>(fieldState);
        }

        public void beforeCompletion() {
            FieldState fieldState = (FieldState)this.fieldStateRef.get();
            if (fieldState != null) {
                fieldState.invalidate();
            }
        }

        public void afterCompletion(int status) {
        }
    }

    private static final class CMRJDBCType
    implements JDBCType {
        private final String[] columnNames;
        private final Class[] javaTypes;
        private final int[] jdbcTypes;
        private final String[] sqlTypes;
        private final boolean[] notNull;

        private CMRJDBCType(List fields) {
            int i;
            ArrayList<String> columnNamesList = new ArrayList<String>();
            ArrayList<Class> javaTypesList = new ArrayList<Class>();
            ArrayList<Integer> jdbcTypesList = new ArrayList<Integer>();
            ArrayList<String> sqlTypesList = new ArrayList<String>();
            ArrayList<Boolean> notNullList = new ArrayList<Boolean>();
            for (JDBCCMPFieldBridge field : fields) {
                JDBCType type = field.getJDBCType();
                for (int i2 = 0; i2 < type.getColumnNames().length; ++i2) {
                    columnNamesList.add(type.getColumnNames()[i2]);
                    javaTypesList.add(type.getJavaTypes()[i2]);
                    jdbcTypesList.add(new Integer(type.getJDBCTypes()[i2]));
                    sqlTypesList.add(type.getSQLTypes()[i2]);
                    notNullList.add(new Boolean(type.getNotNull()[i2]));
                }
            }
            this.columnNames = columnNamesList.toArray(new String[columnNamesList.size()]);
            this.javaTypes = javaTypesList.toArray(new Class[javaTypesList.size()]);
            this.sqlTypes = sqlTypesList.toArray(new String[sqlTypesList.size()]);
            this.jdbcTypes = new int[jdbcTypesList.size()];
            for (i = 0; i < this.jdbcTypes.length; ++i) {
                this.jdbcTypes[i] = (Integer)jdbcTypesList.get(i);
            }
            this.notNull = new boolean[notNullList.size()];
            for (i = 0; i < this.notNull.length; ++i) {
                this.notNull[i] = (Boolean)notNullList.get(i);
            }
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Class[] getJavaTypes() {
            return this.javaTypes;
        }

        @Override
        public int[] getJDBCTypes() {
            return this.jdbcTypes;
        }

        @Override
        public String[] getSQLTypes() {
            return this.sqlTypes;
        }

        @Override
        public boolean[] getNotNull() {
            return this.notNull;
        }

        @Override
        public boolean[] getAutoIncrement() {
            return new boolean[]{false};
        }

        @Override
        public Object getColumnValue(int index, Object value) {
            throw CmpMessages.MESSAGES.getColumnValueNotSupported();
        }

        @Override
        public Object setColumnValue(int index, Object value, Object columnValue) {
            throw CmpMessages.MESSAGES.setColumnValueNotSupported();
        }

        @Override
        public boolean hasMapper() {
            throw CmpMessages.MESSAGES.hasMapperNotSupported();
        }

        @Override
        public boolean isSearchable() {
            throw CmpMessages.MESSAGES.isSearchableNotSupported();
        }

        @Override
        public JDBCResultSetReader[] getResultSetReaders() {
            throw CmpMessages.MESSAGES.getResultSetReadersNotSupported();
        }

        @Override
        public JDBCParameterSetter[] getParameterSetter() {
            throw CmpMessages.MESSAGES.getParamSetterNotSupported();
        }
    }

    private final class FieldState {
        private final CmpEntityBeanContext ctx;
        private List[] setHandle = new List[1];
        private Set addedRelations;
        private Set removedRelations;
        private Set relationSet;
        private boolean isLoaded = false;
        private final long lastRead = -1L;
        private boolean changed;

        public FieldState(CmpEntityBeanContext ctx) {
            this.ctx = ctx;
            this.setHandle[0] = new ArrayList();
        }

        public List getValue() {
            if (!this.isLoaded) {
                throw CmpMessages.MESSAGES.cmrFieldNotLoaded();
            }
            return Collections.unmodifiableList(this.setHandle[0]);
        }

        public boolean isLoaded() {
            return this.isLoaded;
        }

        public long getLastRead() {
            return -1L;
        }

        public void addRelation(Object fk) {
            if (this.isLoaded) {
                this.setHandle[0].add(fk);
            } else {
                if (this.removedRelations == null) {
                    this.removedRelations = new HashSet();
                    this.addedRelations = new HashSet();
                }
                this.removedRelations.remove(fk);
                this.addedRelations.add(fk);
            }
            this.changed = true;
        }

        public void removeRelation(Object fk) {
            if (this.isLoaded) {
                this.setHandle[0].remove(fk);
            } else {
                if (this.removedRelations == null) {
                    this.removedRelations = new HashSet();
                    this.addedRelations = new HashSet();
                }
                this.addedRelations.remove(fk);
                this.removedRelations.add(fk);
            }
            this.changed = true;
        }

        public void loadRelations(Collection values) {
            if (this.isLoaded) {
                throw CmpMessages.MESSAGES.cmrFieldAlreadyLoaded();
            }
            this.setHandle[0].clear();
            this.setHandle[0].addAll(values);
            if (this.removedRelations != null) {
                this.setHandle[0].removeAll(this.removedRelations);
                this.removedRelations = null;
            }
            if (this.addedRelations != null) {
                this.setHandle[0].removeAll(this.addedRelations);
                this.setHandle[0].addAll(this.addedRelations);
                this.addedRelations = null;
            }
            this.isLoaded = true;
        }

        public Set getRelationSet() {
            if (!this.isLoaded) {
                throw CmpMessages.MESSAGES.cmrFieldNotLoaded();
            }
            if (this.ctx.isReadOnly()) {
                return new RelationSet(JDBCCMRFieldBridge.this, this.ctx, new List[]{new ArrayList(this.setHandle[0])}, true);
            }
            if (this.relationSet != null) {
                return this.relationSet;
            }
            try {
                CmpEntityBeanComponent component = JDBCCMRFieldBridge.this.getJDBCStoreManager().getComponent();
                TransactionManager tm = component.getTransactionManager();
                Transaction tx = tm.getTransaction();
                if (tx != null && (tx.getStatus() == 0 || tx.getStatus() == 7)) {
                    this.relationSet = new RelationSet(JDBCCMRFieldBridge.this, this.ctx, this.setHandle, false);
                    TxSynchronization sync = new TxSynchronization(this);
                    this.ctx.getComponent().getTransactionSynchronizationRegistry().registerInterposedSynchronization((Synchronization)sync);
                } else {
                    this.relationSet = new RelationSet(JDBCCMRFieldBridge.this, this.ctx, new List[1], false);
                }
                return this.relationSet;
            }
            catch (SystemException e) {
                throw CmpMessages.MESSAGES.errorCreatingRelationSet((Exception)((Object)e));
            }
        }

        public void invalidate() {
            List currentList = null;
            if (this.setHandle != null && this.setHandle.length > 0) {
                currentList = this.setHandle[0];
                this.setHandle[0] = null;
            }
            this.setHandle = new List[1];
            this.setHandle[0] = currentList;
            this.relationSet = null;
            this.changed = false;
        }

        public boolean isChanged() {
            return this.changed;
        }
    }
}

