/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.nio.channels.ClosedChannelException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.HornetQAlreadyReplicatingException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.HornetQInternalErrorException;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.ServerLocatorInternal;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.ConfigurationUtils;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.DivertConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.deployers.Deployer;
import org.hornetq.core.deployers.DeploymentManager;
import org.hornetq.core.deployers.impl.AddressSettingsDeployer;
import org.hornetq.core.deployers.impl.BasicUserCredentialsDeployer;
import org.hornetq.core.deployers.impl.FileDeploymentManager;
import org.hornetq.core.deployers.impl.QueueDeployer;
import org.hornetq.core.deployers.impl.SecurityDeployer;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.filter.impl.FilterImpl;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.impl.SyncSpeedTest;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.impl.PagingManagerImpl;
import org.hornetq.core.paging.impl.PagingStoreFactoryNIO;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.journal.JournalStorageManager;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.persistence.impl.nullpm.NullStorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.postoffice.impl.DivertBinding;
import org.hornetq.core.postoffice.impl.LocalQueueBinding;
import org.hornetq.core.postoffice.impl.PostOfficeImpl;
import org.hornetq.core.protocol.ServerPacketDecoder;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.impl.ChannelImpl;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.remoting.server.RemotingService;
import org.hornetq.core.remoting.server.impl.RemotingServiceImpl;
import org.hornetq.core.replication.ReplicationEndpoint;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.security.SecurityStore;
import org.hornetq.core.security.impl.SecurityStoreImpl;
import org.hornetq.core.server.ActivateCallback;
import org.hornetq.core.server.Bindable;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.LiveNodeLocator;
import org.hornetq.core.server.MemoryManager;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.cluster.ClusterConnection;
import org.hornetq.core.server.cluster.ClusterManager;
import org.hornetq.core.server.cluster.Transformer;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.group.impl.GroupingHandlerConfiguration;
import org.hornetq.core.server.group.impl.LocalGroupingHandler;
import org.hornetq.core.server.group.impl.RemoteGroupingHandler;
import org.hornetq.core.server.impl.AIOFileLockNodeManager;
import org.hornetq.core.server.impl.AnyLiveNodeLocator;
import org.hornetq.core.server.impl.BackupTopologyListener;
import org.hornetq.core.server.impl.ConnectorsService;
import org.hornetq.core.server.impl.DivertImpl;
import org.hornetq.core.server.impl.FileLockNodeManager;
import org.hornetq.core.server.impl.NamedLiveNodeLocator;
import org.hornetq.core.server.impl.QueueFactoryImpl;
import org.hornetq.core.server.impl.QuorumManager;
import org.hornetq.core.server.impl.ReplicationError;
import org.hornetq.core.server.impl.ServerInfo;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.impl.ManagementServiceImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.settings.impl.HierarchicalObjectRepository;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.impl.ResourceManagerImpl;
import org.hornetq.core.version.Version;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.utils.ClassloadingUtil;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.HornetQThreadFactory;
import org.hornetq.utils.OrderedExecutorFactory;
import org.hornetq.utils.ReusableLatch;
import org.hornetq.utils.SecurityFormatter;
import org.hornetq.utils.VersionLoader;

public class HornetQServerImpl
implements HornetQServer {
    public static final String GENERIC_IGNORED_FILTER = "__HQX=-1";
    private volatile SERVER_STATE state = SERVER_STATE.STOPPED;
    private final Version version;
    private final HornetQSecurityManager securityManager;
    private final Configuration configuration;
    private final MBeanServer mbeanServer;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    private volatile ScheduledExecutorService scheduledPool;
    private volatile ExecutorFactory executorFactory;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile HornetQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private volatile ManagementService managementService;
    private volatile ConnectorsService connectorsService;
    private MemoryManager memoryManager;
    private volatile DeploymentManager deploymentManager;
    private Deployer basicUserCredentialsDeployer;
    private Deployer addressSettingsDeployer;
    private Deployer queueDeployer;
    private Deployer securityDeployer;
    private final Map<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final ReusableLatch activationLatch = new ReusableLatch(0);
    private final ReusableLatch backupSyncLatch = new ReusableLatch(0);
    private final Object replicationLock = new Object();
    private volatile boolean backupUpToDate = true;
    private ReplicationManager replicationManager;
    private ReplicationEndpoint replicationEndpoint;
    private final Set<ActivateCallback> activateCallbacks = new ConcurrentHashSet();
    private volatile GroupingHandler groupingHandler;
    private NodeManager nodeManager;
    private String identity;
    private Thread backupActivationThread;
    private Activation activation;
    private final ShutdownOnCriticalErrorListener shutdownOnCriticalIO = new ShutdownOnCriticalErrorListener();
    private final Object failbackCheckerGuard = new Object();
    private boolean cancelFailBackChecker;

    public HornetQServerImpl() {
        this(null, null, null);
    }

    public HornetQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public HornetQServerImpl(Configuration configuration, HornetQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public HornetQServerImpl(Configuration configuration, MBeanServer mbeanServer, HornetQSecurityManager securityManager) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>();
        this.securityRepository.setDefault(new HashSet());
    }

    protected NodeManager createNodeManager(String directory, String nodeGroupName, boolean replicatingBackup) {
        FileLockNodeManager manager = this.configuration.getJournalType() == JournalType.ASYNCIO && AsynchronousFileImpl.isLoaded() ? new AIOFileLockNodeManager(directory, replicatingBackup) : new FileLockNodeManager(directory, replicatingBackup);
        manager.setNodeGroupName(nodeGroupName);
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() throws Exception {
        if (this.state != SERVER_STATE.STOPPED) {
            HornetQServerLogger.LOGGER.debug("Server already started!");
            return;
        }
        Object object = this.failbackCheckerGuard;
        synchronized (object) {
            this.cancelFailBackChecker = false;
        }
        this.state = SERVER_STATE.STARTING;
        this.activationLatch.setCount(1);
        HornetQServerLogger.LOGGER.debug("Starting server " + this);
        OperationContextImpl.clearContext();
        try {
            boolean wasLive;
            this.checkJournalDirectory();
            this.nodeManager = this.createNodeManager(this.configuration.getJournalDirectory(), this.configuration.getBackupGroupName(), false);
            this.nodeManager.start();
            HornetQServerLogger.LOGGER.serverStarting(this.configuration.isBackup() ? "backup" : "live", this.configuration);
            if (this.configuration.isRunSyncSpeedTest()) {
                SyncSpeedTest test = new SyncSpeedTest();
                test.run();
            }
            boolean bl = wasLive = !this.configuration.isBackup();
            if (!this.configuration.isBackup()) {
                this.activation = this.configuration.isSharedStore() && this.configuration.isPersistenceEnabled() ? new SharedStoreLiveActivation() : new SharedNothingLiveActivation();
                this.activation.run();
            }
            if (this.configuration.isBackup()) {
                if (this.configuration.isSharedStore()) {
                    this.activation = new SharedStoreBackupActivation();
                } else {
                    assert (this.replicationEndpoint == null);
                    this.nodeManager.stop();
                    this.nodeManager = this.createNodeManager(this.configuration.getJournalDirectory(), this.configuration.getBackupGroupName(), true);
                    this.backupUpToDate = false;
                    this.backupSyncLatch.setCount(1);
                    this.replicationEndpoint = new ReplicationEndpoint(this, this.shutdownOnCriticalIO, wasLive);
                    this.activation = new SharedNothingBackupActivation(wasLive);
                }
                this.backupActivationThread = new Thread((Runnable)this.activation, HornetQMessageBundle.BUNDLE.activationForServer(this));
                this.backupActivationThread.start();
            } else {
                this.state = SERVER_STATE.STARTED;
                HornetQServerLogger.LOGGER.serverStarted(this.getVersion().getFullVersion(), this.nodeManager.getNodeId(), this.identity != null ? this.identity : "");
            }
            this.connectorsService = new ConnectorsService(this.configuration, this.storageManager, this.scheduledPool, this.postOffice);
            this.connectorsService.start();
        }
        finally {
            OperationContextImpl.clearContext();
        }
    }

    protected final void finalize() throws Throwable {
        if (this.state != SERVER_STATE.STOPPED) {
            HornetQServerLogger.LOGGER.serverFinalisedWIthoutBeingSTopped();
            this.stop();
        }
        super.finalize();
    }

    public final void stopTheServer(final boolean criticalIOError) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    HornetQServerImpl.this.stop(HornetQServerImpl.this.configuration.isFailoverOnServerShutdown(), criticalIOError, false);
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorStoppingServer(e);
                }
            }
        });
    }

    public final void stop() throws Exception {
        this.stop(this.configuration.isFailoverOnServerShutdown());
    }

    @Override
    public void threadDump(String reason) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        Map<Thread, StackTraceElement[]> stackTrace = Thread.getAllStackTraces();
        out.println(HornetQMessageBundle.BUNDLE.generatingThreadDump(reason));
        out.println("*******************************************************************************");
        for (Map.Entry<Thread, StackTraceElement[]> el : stackTrace.entrySet()) {
            out.println("===============================================================================");
            out.println(HornetQMessageBundle.BUNDLE.threadDump(el.getKey(), el.getKey().getName(), el.getKey().getId(), el.getKey().getThreadGroup()));
            out.println();
            for (StackTraceElement traceEl : el.getValue()) {
                out.println(traceEl);
            }
        }
        out.println("===============================================================================");
        out.println(HornetQMessageBundle.BUNDLE.endThreadDump());
        out.println("*******************************************************************************");
        HornetQServerLogger.LOGGER.warn(str.toString());
    }

    @Override
    public final void stop(boolean failoverOnServerShutdown) throws Exception {
        this.stop(failoverOnServerShutdown, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean failingBack) throws Exception {
        Object object;
        if (!failingBack) {
            object = this.failbackCheckerGuard;
            synchronized (object) {
                this.cancelFailBackChecker = true;
            }
        }
        object = this;
        synchronized (object) {
            if (this.state == SERVER_STATE.STOPPED || this.state == SERVER_STATE.STOPPING) {
                return;
            }
            this.state = SERVER_STATE.STOPPING;
            final ReplicationManager localReplicationManager = this.getReplicationManager();
            if (localReplicationManager != null) {
                this.replicationManager.sendLiveIsStopping(ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED);
                this.scheduledPool.schedule(new Runnable(){

                    @Override
                    public void run() {
                        localReplicationManager.clearReplicationTokens();
                    }
                }, 30L, TimeUnit.SECONDS);
            }
            HornetQServerImpl.stopComponent(this.connectorsService);
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                this.groupingHandler = null;
            }
            HornetQServerImpl.stopComponent(this.clusterManager);
            this.freezeConnections();
        }
        this.closeAllServerSessions(criticalIOError);
        if (this.storageManager != null) {
            this.storageManager.clearContext();
        }
        this.callDeActiveCallbacks();
        object = this;
        synchronized (object) {
            if (this.configuration.isFileDeploymentEnabled()) {
                HornetQServerImpl.stopComponent(this.basicUserCredentialsDeployer);
                HornetQServerImpl.stopComponent(this.addressSettingsDeployer);
                HornetQServerImpl.stopComponent(this.queueDeployer);
                HornetQServerImpl.stopComponent(this.securityDeployer);
                HornetQServerImpl.stopComponent(this.deploymentManager);
            }
            if (this.managementService != null) {
                this.managementService.unregisterServer();
            }
            HornetQServerImpl.stopComponent(this.managementService);
            HornetQServerImpl.stopComponent(this.replicationEndpoint);
            HornetQServerImpl.stopComponent(this.pagingManager);
            if (this.storageManager != null) {
                this.storageManager.stop(criticalIOError);
            }
            if (this.remotingService != null) {
                this.remotingService.stop(criticalIOError);
            }
            HornetQServerImpl.stopComponent(this.securityManager);
            HornetQServerImpl.stopComponent(this.resourceManager);
            HornetQServerImpl.stopComponent(this.postOffice);
            if (this.scheduledPool != null) {
                this.scheduledPool.shutdownNow();
            }
            HornetQServerImpl.stopComponent(this.memoryManager);
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                try {
                    if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                        HornetQServerLogger.LOGGER.timedOutStoppingThreadpool(this.threadPool);
                        for (Runnable r : this.threadPool.shutdownNow()) {
                            HornetQServerLogger.LOGGER.debug("Cancelled the execution of " + r);
                        }
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.scheduledPool = null;
            this.threadPool = null;
            if (this.securityStore != null) {
                this.securityStore.stop();
            }
            this.threadPool = null;
            this.scheduledPool = null;
            this.pagingManager = null;
            this.securityStore = null;
            this.resourceManager = null;
            this.replicationManager = null;
            this.replicationEndpoint = null;
            this.postOffice = null;
            this.queueFactory = null;
            this.resourceManager = null;
            this.messagingServerControl = null;
            this.memoryManager = null;
            this.sessions.clear();
            this.state = SERVER_STATE.STOPPED;
            this.activationLatch.setCount(1);
            SimpleString tempNodeID = this.getNodeID();
            if (this.activation != null) {
                this.activation.close(failoverOnServerShutdown);
            }
            if (this.backupActivationThread != null) {
                this.backupActivationThread.join(30000L);
                if (this.backupActivationThread.isAlive()) {
                    HornetQServerLogger.LOGGER.backupActivationDidntFinish(this);
                    this.backupActivationThread.interrupt();
                }
            }
            HornetQServerImpl.stopComponent(this.nodeManager);
            this.nodeManager = null;
            this.addressSettingsRepository.clearListeners();
            this.addressSettingsRepository.clearCache();
            if (this.identity != null) {
                HornetQServerLogger.LOGGER.serverStopped("identity=" + this.identity + ",version=" + this.getVersion().getFullVersion(), tempNodeID);
            } else {
                HornetQServerLogger.LOGGER.serverStopped(this.getVersion().getFullVersion(), tempNodeID);
            }
        }
    }

    private void freezeConnections() {
        if (this.state != SERVER_STATE.STOPPING) {
            throw new IllegalStateException();
        }
        ReplicationManager localReplicationManager = this.getReplicationManager();
        if (localReplicationManager != null) {
            this.remotingService.freeze(localReplicationManager.getBackupTransportConnection());
        } else {
            this.remotingService.freeze(null);
        }
    }

    private void closeAllServerSessions(boolean criticalIOError) {
        if (this.state != SERVER_STATE.STOPPING) {
            throw new IllegalStateException();
        }
        for (ServerSession session : this.sessions.values()) {
            try {
                session.close(true);
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
            }
        }
        if (!criticalIOError) {
            for (ServerSession session : this.sessions.values()) {
                try {
                    session.waitContextCompletion();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
                }
            }
        }
    }

    private static void stopComponent(HornetQComponent component) throws Exception {
        if (component != null) {
            component.stop();
        }
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println(HornetQMessageBundle.BUNDLE.serverDescribe(this.identity, this.getClusterManager().describe()));
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String destroyConnectionWithSessionMetadata(String metaKey, String parameterValue) throws Exception {
        StringBuffer operationsExecuted = new StringBuffer();
        try {
            operationsExecuted.append("**************************************************************************************************\n");
            operationsExecuted.append(HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataHeader(metaKey, parameterValue) + "\n");
            Set<ServerSession> allSessions = this.getSessions();
            ServerSession sessionFound = null;
            for (ServerSession session : allSessions) {
                try {
                    String value = session.getMetaData(metaKey);
                    if (value == null || !value.equals(parameterValue)) continue;
                    sessionFound = session;
                    operationsExecuted.append(HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataClosingConnection(sessionFound.toString()) + "\n");
                    RemotingConnection conn = session.getRemotingConnection();
                    if (conn != null) {
                        conn.fail((HornetQException)HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataSendException(metaKey, parameterValue));
                    }
                    session.close(true);
                    this.sessions.remove(session.getName());
                }
                catch (Throwable e) {
                    HornetQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
            if (sessionFound == null) {
                operationsExecuted.append(HornetQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataNoSessionFound(metaKey, parameterValue) + "\n");
            }
            operationsExecuted.append("**************************************************************************************************");
            String string = operationsExecuted.toString();
            return string;
        }
        finally {
            HornetQServerLogger.LOGGER.info(operationsExecuted.toString());
        }
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public HornetQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public boolean isStarted() {
        return this.state == SERVER_STATE.STARTED;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback) throws Exception {
        if (this.securityStore != null) {
            this.securityStore.authenticate(username, password);
        }
        OperationContext context = this.storageManager.newContext(this.getExecutorFactory().getExecutor());
        ServerSessionImpl session = this.internalCreateSession(name, username, password, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, context);
        this.sessions.put(name, session);
        return session;
    }

    protected ServerSessionImpl internalCreateSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, OperationContext context) throws Exception {
        return new ServerSessionImpl(name, username, password, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback, context);
    }

    protected SecurityStore getSecurityStore() {
        return this.securityStore;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public ServerSession lookupSession(String key, String value) {
        Set<ServerSession> allSessions = this.getSessions();
        for (ServerSession session : allSessions) {
            String metaValue = session.getMetaData(key);
            if (metaValue == null || !metaValue.equals(value)) continue;
            return session;
        }
        return null;
    }

    @Override
    public synchronized List<ServerSession> getSessions(String connectionID) {
        Set<Map.Entry<String, ServerSession>> sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry<String, ServerSession> sessionEntry : sessionEntries) {
            ServerSession serverSession = sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public synchronized Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    @Override
    public boolean isActive() {
        return this.activationLatch.getCount() < 1;
    }

    @Override
    public boolean waitForActivation(long timeout, TimeUnit unit) throws InterruptedException {
        return this.activationLatch.await(timeout, unit);
    }

    @Override
    public boolean waitForBackupSync(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.configuration.isBackup() && !this.configuration.isSharedStore()) {
            return this.backupSyncLatch.await(timeout, unit);
        }
        return true;
    }

    @Override
    public HornetQServerControlImpl getHornetQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnections().size();
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeManager == null ? null : this.nodeManager.getNodeId();
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, durable, temporary, false);
    }

    @Override
    public Queue locateQueue(SimpleString queueName) throws Exception {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            return null;
        }
        Bindable queue = binding.getBindable();
        if (!(queue instanceof Queue)) {
            throw new IllegalStateException("locateQueue should only be used to locate queues");
        }
        return (Queue)binding.getBindable();
    }

    @Override
    public Queue deployQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        HornetQServerLogger.LOGGER.deployQueue(queueName);
        return this.createQueue(address, queueName, filterString, durable, temporary, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName) throws Exception {
        this.destroyQueue(queueName, null, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, ServerSession session, boolean checkConsumerCount) throws Exception {
        this.addressSettingsRepository.clearCache();
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw HornetQMessageBundle.BUNDLE.noSuchQueue(queueName);
        }
        Queue queue = (Queue)binding.getBindable();
        if (checkConsumerCount && queue.getConsumerCount() != 0) {
            throw HornetQMessageBundle.BUNDLE.cannotDeleteQueue(queue.getName(), queueName, binding.getClass().getName());
        }
        if (session != null) {
            if (queue.isDurable()) {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_DURABLE_QUEUE, session);
            } else {
                this.securityStore.check(binding.getAddress(), CheckType.DELETE_NON_DURABLE_QUEUE, session);
            }
        }
        queue.deleteQueue();
    }

    @Override
    public void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        this.groupingHandler = groupingHandler;
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationEndpoint getReplicationEndpoint() {
        return this.replicationEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationManager getReplicationManager() {
        Object object = this.replicationLock;
        synchronized (object) {
            return this.replicationManager;
        }
    }

    @Override
    public ConnectorsService getConnectorsService() {
        return this.connectorsService;
    }

    @Override
    public void deployDivert(DivertConfiguration config) throws Exception {
        if (config.getName() == null) {
            HornetQServerLogger.LOGGER.divertWithNoName();
            return;
        }
        if (config.getAddress() == null) {
            HornetQServerLogger.LOGGER.divertWithNoAddress();
            return;
        }
        if (config.getForwardingAddress() == null) {
            HornetQServerLogger.LOGGER.divertWithNoForwardingAddress();
            return;
        }
        SimpleString sName = new SimpleString(config.getName());
        if (this.postOffice.getBinding(sName) != null) {
            HornetQServerLogger.LOGGER.divertBindingNotExists(sName);
            return;
        }
        SimpleString sAddress = new SimpleString(config.getAddress());
        Transformer transformer = this.instantiateTransformer(config.getTransformerClassName());
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        DivertImpl divert = new DivertImpl(new SimpleString(config.getForwardingAddress()), sName, new SimpleString(config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager);
        DivertBinding binding = new DivertBinding(this.storageManager.generateUniqueID(), sAddress, divert);
        this.postOffice.addBinding(binding);
        this.managementService.registerDivert(divert, config);
    }

    @Override
    public void destroyDivert(SimpleString name) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null) {
            throw HornetQMessageBundle.BUNDLE.noBindingForDivert(name);
        }
        if (!(binding instanceof DivertBinding)) {
            throw HornetQMessageBundle.BUNDLE.bindingNotDivert(name);
        }
        this.postOffice.removeBinding(name, null);
    }

    @Override
    public void deployBridge(BridgeConfiguration config) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.deployBridge(config);
        }
    }

    @Override
    public void destroyBridge(String name) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.destroyBridge(name);
        }
    }

    @Override
    public ServerSession getSessionByID(String sessionName) {
        return this.sessions.get(sessionName);
    }

    public String toString() {
        if (this.identity != null) {
            return "HornetQServerImpl::" + this.identity;
        }
        return "HornetQServerImpl::" + (this.nodeManager != null ? "serverUUID=" + this.nodeManager.getUUID() : "");
    }

    public void replaceQueueFactory(QueueFactory factory) {
        this.queueFactory = factory;
    }

    private PagingManager createPagingManager() {
        return new PagingManagerImpl(new PagingStoreFactoryNIO(this.storageManager, this.configuration.getPagingDirectory(), this.configuration.getJournalBufferSize_NIO(), this.scheduledPool, this.executorFactory, this.configuration.isJournalSyncNonTransactional(), this.shutdownOnCriticalIO), this.addressSettingsRepository);
    }

    private StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            return new JournalStorageManager(this.configuration, this.executorFactory, this.shutdownOnCriticalIO);
        }
        return new NullStorageManager();
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    private void callDeActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.deActivate();
        }
    }

    private synchronized boolean initialisePart1() throws Exception {
        if (this.state == SERVER_STATE.STOPPED) {
            return false;
        }
        HornetQThreadFactory tFactory = new HornetQThreadFactory("HornetQ-server-" + this.toString(), false, HornetQServerImpl.getThisClassLoader());
        this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? Executors.newCachedThreadPool((ThreadFactory)tFactory) : Executors.newFixedThreadPool(this.configuration.getThreadPoolMaxSize(), (ThreadFactory)tFactory);
        this.executorFactory = new OrderedExecutorFactory((Executor)this.threadPool);
        this.scheduledPool = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), (ThreadFactory)new HornetQThreadFactory("HornetQ-scheduled-threads", false, HornetQServerImpl.getThisClassLoader()));
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManager(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.deploymentManager = new FileDeploymentManager(this.configuration.getFileDeployerScanPeriod());
        }
        this.callPreActiveCallbacks();
        this.storageManager = this.createStorageManager();
        if (HornetQDefaultConfiguration.getDefaultClusterUser().equals(this.configuration.getClusterUser()) && HornetQDefaultConfiguration.getDefaultClusterPassword().equals(this.configuration.getClusterPassword())) {
            HornetQServerLogger.LOGGER.clusterSecurityRisk();
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService);
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl((int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getMessageExpiryThreadPriority(), this.configuration.isWildcardRoutingEnabled(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.clusterManager = new ClusterManager(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.nodeManager, this.configuration.isBackup(), this.threadPool);
        this.clusterManager.deploy();
        this.remotingService = new RemotingServiceImpl(this.clusterManager, this.configuration, this, this.managementService, this.scheduledPool);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.configuration.isBackup());
        if (this.configuration.isFileDeploymentEnabled()) {
            this.addressSettingsDeployer = new AddressSettingsDeployer(this.deploymentManager, this.addressSettingsRepository);
            this.addressSettingsDeployer.start();
        }
        this.deployAddressSettingsFromConfiguration();
        this.storageManager.start();
        if (this.securityManager != null) {
            this.securityManager.start();
        }
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        if (this.configuration.isFileDeploymentEnabled()) {
            this.basicUserCredentialsDeployer = new BasicUserCredentialsDeployer(this.deploymentManager, this.securityManager);
            this.basicUserCredentialsDeployer.start();
            if (this.securityManager != null) {
                this.securityDeployer = new SecurityDeployer(this.deploymentManager, this.securityRepository);
                this.securityDeployer.start();
            }
        }
        this.deploySecurityFromConfiguration();
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
        return true;
    }

    private synchronized void initialisePart2() throws Exception {
        if (this.state == SERVER_STATE.STOPPED || this.state == SERVER_STATE.STOPPING) {
            return;
        }
        this.pagingManager.reloadStores();
        JournalLoadInformation[] journalInfo = this.loadJournals();
        final ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    HornetQServerLogger.LOGGER.dumpServerInfo(dumper.dump());
                }
            }, 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        if (this.configuration.isFileDeploymentEnabled()) {
            this.queueDeployer = new QueueDeployer(this.deploymentManager, this);
            this.queueDeployer.start();
        } else {
            this.deployQueuesFromConfiguration();
        }
        this.callActivateCallbacks();
        this.deployDiverts();
        if (this.deploymentManager != null) {
            this.deploymentManager.start();
        }
        this.remotingService.start();
        this.clusterManager.start();
        if (this.nodeManager.getNodeId() == null) {
            throw HornetQMessageBundle.BUNDLE.nodeIdNull();
        }
        this.activationLatch.countDown();
        this.postOffice.startExpiryScanner();
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        for (CoreQueueConfiguration config : this.configuration.getQueueConfigurations()) {
            this.deployQueue(SimpleString.toSimpleString((String)config.getAddress()), SimpleString.toSimpleString((String)config.getName()), SimpleString.toSimpleString((String)config.getFilterString()), config.isDurable(), false);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressesSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private JournalLoadInformation[] loadJournals() throws Exception {
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos);
        this.recoverStoredConfigs();
        HashMap<Long, Queue> queues = new HashMap<Long, Queue>();
        HashMap<Long, QueueBindingInfo> queueBindingInfosMap = new HashMap<Long, QueueBindingInfo>();
        int duplicateID = 0;
        for (QueueBindingInfo queueBindingInfo : queueBindingInfos) {
            boolean bl;
            queueBindingInfosMap.put(queueBindingInfo.getId(), queueBindingInfo);
            Filter filter = FilterImpl.createFilter(queueBindingInfo.getFilterString());
            boolean bl2 = bl = filter != null && filter.getFilterString() != null && filter.getFilterString().toString().equals(GENERIC_IGNORED_FILTER);
            if (this.postOffice.getBinding(queueBindingInfo.getQueueName()) != null) {
                if (bl) {
                    long tx = this.storageManager.generateUniqueID();
                    this.storageManager.deleteQueueBinding(tx, queueBindingInfo.getId());
                    this.storageManager.commitBindings(tx);
                    continue;
                }
                SimpleString newName = queueBindingInfo.getQueueName().concat("-" + duplicateID++);
                HornetQServerLogger.LOGGER.queueDuplicatedRenaming(queueBindingInfo.getQueueName().toString(), newName.toString());
                queueBindingInfo.replaceQueueName(newName);
            }
            PageSubscription subscription = null;
            if (!bl) {
                subscription = this.pagingManager.getPageStore(queueBindingInfo.getAddress()).getCursorProvider().createSubscription(queueBindingInfo.getId(), filter, true);
            }
            Queue queue = this.queueFactory.createQueue(queueBindingInfo.getId(), queueBindingInfo.getAddress(), queueBindingInfo.getQueueName(), filter, subscription, true, false);
            LocalQueueBinding binding = new LocalQueueBinding(queueBindingInfo.getAddress(), queue, this.nodeManager.getNodeId());
            queues.put(queueBindingInfo.getId(), queue);
            this.postOffice.addBinding(binding);
            this.managementService.registerAddress(queueBindingInfo.getAddress());
            this.managementService.registerQueue(queue, queueBindingInfo.getAddress(), this.storageManager);
        }
        for (GroupingInfo groupingInfo : groupingInfos) {
            if (this.groupingHandler == null) continue;
            this.groupingHandler.addGroupBinding(new GroupBinding(groupingInfo.getId(), groupingInfo.getGroupId(), groupingInfo.getClusterName()));
        }
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        HashSet<Pair<Long, Long>> pendingLargeMessages = new HashSet<Pair<Long, Long>>();
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queues, queueBindingInfosMap, duplicateIDMap, pendingLargeMessages);
        for (Map.Entry entry : duplicateIDMap.entrySet()) {
            SimpleString address = (SimpleString)entry.getKey();
            DuplicateIDCache cache = this.postOffice.getDuplicateIDCache(address);
            if (!this.configuration.isPersistIDCache()) continue;
            cache.load((List)entry.getValue());
        }
        for (Pair pair : pendingLargeMessages) {
            HornetQServerLogger.LOGGER.deletingPendingMessage((Pair<Long, Long>)pair);
            LargeServerMessage msg = this.storageManager.createLargeMessage();
            msg.setMessageID((Long)pair.getB());
            msg.setPendingRecordID((Long)pair.getA());
            msg.setDurable(true);
            msg.deleteFile();
        }
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        List<PersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (PersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
        List<PersistedRoles> roles = this.storageManager.recoverPersistedRoles();
        for (PersistedRoles roleItem : roles) {
            Set setRoles = SecurityFormatter.createSecurity((String)roleItem.getSendRoles(), (String)roleItem.getConsumeRoles(), (String)roleItem.getCreateDurableQueueRoles(), (String)roleItem.getDeleteDurableQueueRoles(), (String)roleItem.getCreateNonDurableQueueRoles(), (String)roleItem.getDeleteNonDurableQueueRoles(), (String)roleItem.getManageRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    private Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean ignoreIfExists) throws Exception {
        QueueBinding binding = (QueueBinding)this.postOffice.getBinding(queueName);
        if (binding != null) {
            if (ignoreIfExists) {
                return binding.getQueue();
            }
            throw HornetQMessageBundle.BUNDLE.queueAlreadyExists(queueName);
        }
        Filter filter = FilterImpl.createFilter(filterString);
        long txID = this.storageManager.generateUniqueID();
        long queueID = this.storageManager.generateUniqueID();
        PageSubscription pageSubscription = filterString != null && filterString.toString().equals(GENERIC_IGNORED_FILTER) ? null : this.pagingManager.getPageStore(address).getCursorProvider().createSubscription(queueID, filter, durable);
        Queue queue = this.queueFactory.createQueue(queueID, address, queueName, filter, pageSubscription, durable, temporary);
        binding = new LocalQueueBinding(address, queue, this.nodeManager.getNodeId());
        if (durable) {
            this.storageManager.addQueueBinding(txID, binding);
        }
        try {
            this.postOffice.addBinding(binding);
            if (durable) {
                this.storageManager.commitBindings(txID);
            }
        }
        catch (Exception e) {
            try {
                if (durable) {
                    this.storageManager.rollbackBindings(txID);
                }
                if (queue != null) {
                    queue.close();
                }
                if (pageSubscription != null) {
                    pageSubscription.destroy();
                }
            }
            catch (Throwable ignored) {
                HornetQServerLogger.LOGGER.debug(ignored.getMessage(), ignored);
            }
            throw e;
        }
        this.managementService.registerAddress(address);
        this.managementService.registerQueue(queue, address, this.storageManager);
        return queue;
    }

    private void deployDiverts() throws Exception {
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            this.deployDivert(config);
        }
    }

    private void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupingHandler groupingHandler1 = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout()) : new RemoteGroupingHandler(this.managementService, config.getName(), config.getAddress(), config.getTimeout());
            this.groupingHandler = groupingHandler1;
            this.managementService.addNotificationListener(groupingHandler1);
        }
    }

    private Transformer instantiateTransformer(String transformerClassName) {
        Transformer transformer = null;
        if (transformerClassName != null) {
            transformer = (Transformer)this.instantiateInstance(transformerClassName);
        }
        return transformer;
    }

    private Object instantiateInstance(String className) {
        return HornetQServerImpl.safeInitNewInstance(className);
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    private void checkJournalDirectory() {
        File journalDir = new File(this.configuration.getJournalDirectory());
        if (!journalDir.exists()) {
            if (this.configuration.isCreateJournalDir()) {
                journalDir.mkdirs();
            } else {
                throw HornetQMessageBundle.BUNDLE.cannotCreateDir(journalDir.getAbsolutePath());
            }
        }
    }

    private void startFailbackChecker() {
        this.scheduledPool.scheduleAtFixedRate(new FailbackChecker(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private TransportConfiguration[] connectorNameListToArray(List<String> connectorNames) {
        TransportConfiguration[] tcConfigs = (TransportConfiguration[])Array.newInstance(TransportConfiguration.class, connectorNames.size());
        int count = 0;
        for (String connectorName : connectorNames) {
            TransportConfiguration connector = this.configuration.getConnectorConfigurations().get(connectorName);
            if (connector == null) {
                HornetQServerLogger.LOGGER.bridgeNoConnector(connectorName);
                return null;
            }
            tcConfigs[count++] = connector;
        }
        return tcConfigs;
    }

    private static Object safeInitNewInstance(final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ClassloadingUtil.newInstanceFromClassLoader((String)className);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplication(CoreRemotingConnection rc, final ClusterConnection clusterConnection, final Pair<TransportConfiguration, TransportConfiguration> pair, final boolean isFailBackRequest) throws HornetQException {
        if (this.replicationManager != null) {
            throw new HornetQAlreadyReplicatingException();
        }
        if (!this.isStarted()) {
            throw new HornetQIllegalStateException();
        }
        Object object = this.replicationLock;
        synchronized (object) {
            if (this.replicationManager != null) {
                throw new HornetQAlreadyReplicatingException();
            }
            ReplicationFailureListener listener = new ReplicationFailureListener();
            rc.addCloseListener((CloseListener)listener);
            rc.addFailureListener((FailureListener)listener);
            this.replicationManager = new ReplicationManager(rc, this.executorFactory);
            this.replicationManager.start();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block20: {
                        try {
                            HornetQServerImpl.this.storageManager.startReplication(HornetQServerImpl.this.replicationManager, HornetQServerImpl.this.pagingManager, HornetQServerImpl.this.getNodeID().toString(), isFailBackRequest && HornetQServerImpl.this.configuration.isAllowAutoFailBack());
                            clusterConnection.nodeAnnounced(System.currentTimeMillis(), HornetQServerImpl.this.getNodeID().toString(), HornetQServerImpl.this.configuration.getBackupGroupName(), (Pair<TransportConfiguration, TransportConfiguration>)pair, true);
                            if (!isFailBackRequest || !HornetQServerImpl.this.configuration.isAllowAutoFailBack()) break block20;
                            BackupTopologyListener listener1 = new BackupTopologyListener(HornetQServerImpl.this.getNodeID().toString());
                            clusterConnection.addClusterTopologyListener(listener1);
                            if (listener1.waitForBackup()) {
                                try {
                                    Thread.sleep(HornetQServerImpl.this.configuration.getFailbackDelay());
                                }
                                catch (InterruptedException e) {
                                    // empty catch block
                                }
                                HornetQServerImpl.this.stop(true);
                                HornetQServerLogger.LOGGER.stopReplicatedBackupAfterFailback();
                                break block20;
                            }
                            HornetQServerLogger.LOGGER.failbackMissedBackupAnnouncement();
                        }
                        catch (Exception e) {
                            if (HornetQServerImpl.this.state == SERVER_STATE.STARTED) {
                                HornetQServerLogger.LOGGER.errorStartingReplication(e);
                            }
                            try {
                                HornetQServerImpl.stopComponent(HornetQServerImpl.this.replicationManager);
                            }
                            catch (Exception hqe) {
                                HornetQServerLogger.LOGGER.errorStoppingReplication(hqe);
                            }
                            finally {
                                Object object = HornetQServerImpl.this.replicationLock;
                                synchronized (object) {
                                    HornetQServerImpl.this.replicationManager = null;
                                }
                            }
                        }
                    }
                }
            });
            t.start();
        }
    }

    public boolean isRemoteBackupUpToDate() {
        return this.backupUpToDate;
    }

    public void setRemoteBackupUpToDate() {
        this.clusterManager.announceBackup();
        this.backupUpToDate = true;
        this.backupSyncLatch.countDown();
    }

    public void remoteFailOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) throws HornetQException {
        if (!this.configuration.isBackup() || this.configuration.isSharedStore()) {
            throw new HornetQInternalErrorException();
        }
        if (this.activation instanceof SharedNothingBackupActivation) {
            SharedNothingBackupActivation replicationActivation = (SharedNothingBackupActivation)this.activation;
            if (!this.backupUpToDate) {
                replicationActivation.failOver(null);
            } else {
                replicationActivation.failOver(finalMessage);
            }
        }
    }

    private ServerLocatorInternal getFailbackLocator(ClusterConnectionConfiguration config) throws HornetQException {
        ServerLocatorInternal locator;
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = this.configuration.getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            if (dg == null) {
                throw new HornetQException("foo");
            }
            locator = (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((DiscoveryGroupConfiguration)dg);
        } else {
            TransportConfiguration[] tcConfigs = config.getStaticConnectors() != null ? this.connectorNameListToArray(config.getStaticConnectors()) : null;
            locator = (ServerLocatorInternal)HornetQClient.createServerLocatorWithHA((TransportConfiguration[])tcConfigs);
        }
        return locator;
    }

    private void moveServerData() {
        String[] dataDirs = new String[]{this.configuration.getBindingsDirectory(), this.configuration.getJournalDirectory(), this.configuration.getPagingDirectory(), this.configuration.getLargeMessagesDirectory()};
        boolean allEmpty = true;
        int lowestSuffixForMovedData = 1;
        boolean redo = true;
        while (redo) {
            redo = false;
            for (String dir : dataDirs) {
                File fDir = new File(dir);
                if (fDir.exists()) {
                    if (!fDir.isDirectory()) {
                        throw new IllegalStateException("Path " + fDir + " exists and it is not a directory");
                    }
                    if (fDir.list().length > 0) {
                        allEmpty = false;
                    }
                }
                String sanitizedPath = fDir.getPath();
                while (new File(sanitizedPath + lowestSuffixForMovedData).exists()) {
                    ++lowestSuffixForMovedData;
                    redo = true;
                }
            }
        }
        if (allEmpty) {
            return;
        }
        for (String dir0 : dataDirs) {
            File dir = new File(dir0);
            File newPath = new File(dir.getPath() + lowestSuffixForMovedData);
            if (dir.exists()) {
                if (!dir.renameTo(newPath)) {
                    throw new IllegalStateException("Could not move " + dir);
                }
                HornetQServerLogger.LOGGER.backupMovingDataAway(dir0, newPath.getPath());
            }
            dir.mkdir();
        }
    }

    private final class ReplicationFailureListener
    implements FailureListener,
    CloseListener {
        private ReplicationFailureListener() {
        }

        public void connectionFailed(HornetQException exception, boolean failedOver) {
            this.connectionClosed();
        }

        public void connectionClosed() {
            HornetQServerImpl.this.threadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = HornetQServerImpl.this.replicationLock;
                    synchronized (object) {
                        if (HornetQServerImpl.this.replicationManager != null) {
                            HornetQServerImpl.this.storageManager.stopReplication();
                            HornetQServerImpl.this.replicationManager = null;
                        }
                    }
                }
            });
        }
    }

    static final class NodeIdListener
    implements ClusterTopologyListener {
        volatile boolean isNodePresent = false;
        private final SimpleString nodeId;
        private final CountDownLatch latch = new CountDownLatch(1);

        public NodeIdListener(SimpleString nodeId) {
            this.nodeId = nodeId;
        }

        public void nodeUP(TopologyMember topologyMember, boolean last) {
            boolean isOurNodeId;
            boolean bl = isOurNodeId = this.nodeId != null && this.nodeId.toString().equals(topologyMember.getNodeId());
            if (isOurNodeId) {
                this.isNodePresent = true;
            }
            if (isOurNodeId || last) {
                this.latch.countDown();
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }

    private final class SharedNothingLiveActivation
    implements Activation {
        private SharedNothingLiveActivation() {
        }

        @Override
        public void run() {
            try {
                if (HornetQServerImpl.this.configuration.isClustered() && HornetQServerImpl.this.configuration.isCheckForLiveServer() && this.isNodeIdUsed()) {
                    HornetQServerImpl.this.configuration.setBackup(true);
                    return;
                }
                HornetQServerImpl.this.initialisePart1();
                HornetQServerImpl.this.initialisePart2();
                if (HornetQServerImpl.this.identity != null) {
                    HornetQServerLogger.LOGGER.serverIsLive(HornetQServerImpl.this.identity);
                } else {
                    HornetQServerLogger.LOGGER.serverIsLive();
                }
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.initializationError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isNodeIdUsed() throws Exception {
            SimpleString nodeId0;
            if (HornetQServerImpl.this.configuration.getClusterConfigurations().isEmpty()) {
                return false;
            }
            try {
                nodeId0 = HornetQServerImpl.this.nodeManager.readNodeId();
            }
            catch (HornetQIllegalStateException e) {
                nodeId0 = null;
            }
            ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(HornetQServerImpl.this.configuration);
            ServerLocatorInternal locator = HornetQServerImpl.this.getFailbackLocator(config);
            ClientSessionFactoryInternal factory = null;
            NodeIdListener listener = new NodeIdListener(nodeId0);
            locator.addClusterTopologyListener((ClusterTopologyListener)listener);
            try {
                locator.setReconnectAttempts(0);
                try {
                    locator.addClusterTopologyListener((ClusterTopologyListener)listener);
                    factory = locator.connectNoWarnings();
                }
                catch (Exception notConnected) {
                    boolean bl = false;
                    if (factory != null) {
                        factory.close();
                    }
                    if (locator != null) {
                        locator.close();
                    }
                    return bl;
                }
                listener.latch.await(5L, TimeUnit.SECONDS);
                boolean bl = listener.isNodePresent;
                return bl;
            }
            finally {
                if (factory != null) {
                    factory.close();
                }
                if (locator != null) {
                    locator.close();
                }
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
            if (nodeManagerInUse != null) {
                if (permanently) {
                    nodeManagerInUse.crashLiveServer();
                } else {
                    nodeManagerInUse.pauseLiveServer();
                }
            }
        }
    }

    private final class SharedNothingBackupActivation
    implements Activation {
        private volatile ServerLocatorInternal serverLocator0;
        private volatile QuorumManager quorumManager;
        private final boolean attemptFailBack;
        private String nodeID;
        ClientSessionFactoryInternal liveServerSessionFactory;
        private boolean closed;

        public SharedNothingBackupActivation(boolean attemptFailBack) {
            this.attemptFailBack = attemptFailBack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            QuorumManager.BACKUP_ACTIVATION signal;
            LiveNodeLocator nodeLocator;
            try {
                Object object = HornetQServerImpl.this;
                synchronized (object) {
                    HornetQServerImpl.this.state = SERVER_STATE.STARTED;
                }
                HornetQServerImpl.this.nodeManager.stop();
                HornetQServerImpl.this.moveServerData();
                HornetQServerImpl.this.nodeManager.start();
                object = this;
                synchronized (object) {
                    if (this.closed) {
                        return;
                    }
                    ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(HornetQServerImpl.this.configuration);
                    this.serverLocator0 = HornetQServerImpl.this.getFailbackLocator(config);
                }
                this.serverLocator0.setReconnectAttempts(-1);
                this.serverLocator0.setInitialConnectAttempts(-1);
                this.serverLocator0.setPacketDecoder((PacketDecoder)ServerPacketDecoder.INSTANCE);
                if (!HornetQServerImpl.this.initialisePart1()) {
                    return;
                }
                object = this;
                synchronized (object) {
                    if (this.closed) {
                        return;
                    }
                    this.quorumManager = new QuorumManager((ServerLocator)this.serverLocator0, HornetQServerImpl.this.threadPool, HornetQServerImpl.this.scheduledPool, HornetQServerImpl.this.getIdentity(), HornetQServerImpl.this.nodeManager);
                    this.serverLocator0.addClusterTopologyListener((ClusterTopologyListener)this.quorumManager);
                }
                nodeLocator = HornetQServerImpl.this.configuration.getBackupGroupName() == null ? new AnyLiveNodeLocator(this.quorumManager) : new NamedLiveNodeLocator(HornetQServerImpl.this.configuration.getBackupGroupName(), this.quorumManager);
                this.serverLocator0.addClusterTopologyListener((ClusterTopologyListener)nodeLocator);
                while (true) {
                    try {
                        nodeLocator.connectToCluster(this.serverLocator0);
                    }
                    catch (HornetQException e) {
                        if (this.closed) {
                            if (this.serverLocator0 == null) return;
                            this.serverLocator0.close();
                            return;
                        }
                        Thread.sleep(this.serverLocator0.getRetryInterval());
                        continue;
                    }
                    break;
                }
                this.serverLocator0.addIncomingInterceptor((Interceptor)new ReplicationError(HornetQServerImpl.this, nodeLocator));
            }
            catch (Exception e) {
                if ((e instanceof InterruptedException || e instanceof IllegalStateException) && !HornetQServerImpl.this.isStarted()) {
                    return;
                }
                HornetQServerLogger.LOGGER.initializationError(e);
                e.printStackTrace();
                return;
            }
            HornetQServerImpl.this.clusterManager.start();
            HornetQServerImpl.this.replicationEndpoint.setQuorumManager(this.quorumManager);
            HornetQServerImpl.this.replicationEndpoint.setExecutor(HornetQServerImpl.this.executorFactory.getExecutor());
            EndpointConnector endpointConnector = new EndpointConnector();
            HornetQServerLogger.LOGGER.backupServerStarted(HornetQServerImpl.this.version.getFullVersion(), HornetQServerImpl.this.nodeManager.getNodeId());
            HornetQServerImpl.this.state = SERVER_STATE.STARTED;
            do {
                block47: {
                    nodeLocator.locateNode();
                    if (this.closed) {
                        return;
                    }
                    Pair<TransportConfiguration, TransportConfiguration> possibleLive = nodeLocator.getLiveConfiguration();
                    this.nodeID = nodeLocator.getNodeID();
                    if (!this.attemptFailBack) {
                        if (this.nodeID == null) {
                            throw new RuntimeException("Could not establish the connection");
                        }
                        HornetQServerImpl.this.nodeManager.setNodeID(this.nodeID);
                    }
                    try {
                        this.liveServerSessionFactory = (ClientSessionFactoryInternal)this.serverLocator0.createSessionFactory((TransportConfiguration)possibleLive.getA(), 0, false);
                    }
                    catch (Exception e) {
                        if (possibleLive.getB() == null) break block47;
                        try {
                            this.liveServerSessionFactory = (ClientSessionFactoryInternal)this.serverLocator0.createSessionFactory((TransportConfiguration)possibleLive.getB(), 0, false);
                        }
                        catch (Exception e1) {
                            this.liveServerSessionFactory = null;
                        }
                    }
                }
                if (this.liveServerSessionFactory == null) {
                    Thread.sleep(this.serverLocator0.getRetryInterval());
                    signal = QuorumManager.BACKUP_ACTIVATION.ALREADY_REPLICATING;
                    continue;
                }
                HornetQServerImpl.this.threadPool.execute(endpointConnector);
                signal = this.quorumManager.waitForStatusChange();
                HornetQServerImpl.stopComponent(HornetQServerImpl.this.replicationEndpoint);
                if (!HornetQServerImpl.this.isStarted()) return;
                if (signal == QuorumManager.BACKUP_ACTIVATION.STOP) {
                    return;
                }
                if (signal == QuorumManager.BACKUP_ACTIVATION.FAIL_OVER) break;
                if (signal == QuorumManager.BACKUP_ACTIVATION.FAILURE_REPLICATING) {
                    Thread startThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                HornetQServerImpl.this.stop();
                            }
                            catch (Exception e) {
                                HornetQServerLogger.LOGGER.errorRestartingBackupServer(e, HornetQServerImpl.this);
                            }
                        }
                    });
                    startThread.start();
                    return;
                }
                this.liveServerSessionFactory.close();
                this.quorumManager.reset();
                if (HornetQServerImpl.this.replicationEndpoint.getChannel() == null) continue;
                HornetQServerImpl.this.replicationEndpoint.getChannel().close();
                HornetQServerImpl.this.replicationEndpoint.setChannel(null);
            } while (signal == QuorumManager.BACKUP_ACTIVATION.ALREADY_REPLICATING);
            if (!HornetQServerImpl.this.isRemoteBackupUpToDate()) {
                throw HornetQMessageBundle.BUNDLE.backupServerNotInSync();
            }
            HornetQServerImpl.this.configuration.setBackup(false);
            HornetQServerImpl hornetQServerImpl = HornetQServerImpl.this;
            synchronized (hornetQServerImpl) {
                if (!HornetQServerImpl.this.isStarted()) {
                    return;
                }
                HornetQServerLogger.LOGGER.becomingLive(HornetQServerImpl.this);
                HornetQServerImpl.this.nodeManager.stopBackup();
                HornetQServerImpl.this.storageManager.start();
                HornetQServerImpl.this.initialisePart2();
                HornetQServerImpl.this.clusterManager.activate();
                return;
            }
            finally {
                if (this.serverLocator0 != null) {
                    this.serverLocator0.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(boolean permanently) throws Exception {
            SharedNothingBackupActivation sharedNothingBackupActivation = this;
            synchronized (sharedNothingBackupActivation) {
                if (this.quorumManager != null) {
                    this.quorumManager.causeExit(QuorumManager.BACKUP_ACTIVATION.STOP);
                }
                if (this.serverLocator0 != null) {
                    this.serverLocator0.close();
                }
                this.closed = true;
            }
            if (HornetQServerImpl.this.configuration.isBackup()) {
                long timeout = 30000L;
                long start = System.currentTimeMillis();
                NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
                while (HornetQServerImpl.this.backupActivationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
                    if (nodeManagerInUse != null) {
                        nodeManagerInUse.interrupt();
                    }
                    HornetQServerImpl.this.backupActivationThread.interrupt();
                    Thread.sleep(1000L);
                }
                if (System.currentTimeMillis() - start >= timeout) {
                    HornetQServerLogger.LOGGER.backupActivationProblem();
                }
                if (nodeManagerInUse != null) {
                    nodeManagerInUse.stopBackup();
                }
            }
        }

        public final void failOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
            if (finalMessage == null) {
                this.quorumManager.causeExit(QuorumManager.BACKUP_ACTIVATION.FAILURE_REPLICATING);
            } else {
                this.quorumManager.failOver(finalMessage);
            }
        }

        private class EndpointConnector
        implements Runnable {
            private EndpointConnector() {
            }

            @Override
            public void run() {
                try {
                    SharedNothingBackupActivation.this.liveServerSessionFactory.setReconnectAttempts(1);
                    SharedNothingBackupActivation.this.quorumManager.setSessionFactory(SharedNothingBackupActivation.this.liveServerSessionFactory);
                    CoreRemotingConnection liveConnection = SharedNothingBackupActivation.this.liveServerSessionFactory.getConnection();
                    SharedNothingBackupActivation.this.quorumManager.addAsFailureListenerOf(liveConnection);
                    Channel pingChannel = liveConnection.getChannel(ChannelImpl.CHANNEL_ID.PING.id, -1);
                    Channel replicationChannel = liveConnection.getChannel(ChannelImpl.CHANNEL_ID.REPLICATION.id, -1);
                    this.connectToReplicationEndpoint(replicationChannel);
                    HornetQServerImpl.this.replicationEndpoint.start();
                    HornetQServerImpl.this.clusterManager.announceReplicatingBackupToLive(pingChannel, SharedNothingBackupActivation.this.attemptFailBack);
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.replicationStartProblem(e);
                    SharedNothingBackupActivation.this.quorumManager.causeExit(QuorumManager.BACKUP_ACTIVATION.FAILURE_REPLICATING);
                }
            }

            private synchronized ReplicationEndpoint connectToReplicationEndpoint(Channel channel) throws Exception {
                if (!HornetQServerImpl.this.isStarted()) {
                    return null;
                }
                if (!HornetQServerImpl.this.configuration.isBackup()) {
                    throw HornetQMessageBundle.BUNDLE.serverNotBackupServer();
                }
                channel.setHandler((ChannelHandler)HornetQServerImpl.this.replicationEndpoint);
                if (HornetQServerImpl.this.replicationEndpoint.getChannel() != null) {
                    throw HornetQMessageBundle.BUNDLE.alreadyHaveReplicationServer();
                }
                HornetQServerImpl.this.replicationEndpoint.setChannel(channel);
                return HornetQServerImpl.this.replicationEndpoint;
            }
        }
    }

    private static interface Activation
    extends Runnable {
        public void close(boolean var1) throws Exception;
    }

    private final class ShutdownOnCriticalErrorListener
    implements IOCriticalErrorListener {
        boolean failedAlready = false;

        private ShutdownOnCriticalErrorListener() {
        }

        public synchronized void onIOException(Exception cause, String message, SequentialFile file) {
            if (!this.failedAlready) {
                this.failedAlready = true;
                HornetQServerLogger.LOGGER.ioCriticalIOError(message, file.toString(), cause);
                HornetQServerImpl.this.stopTheServer(true);
            }
        }
    }

    private final class SharedStoreBackupActivation
    implements Activation {
        private SharedStoreBackupActivation() {
        }

        @Override
        public void run() {
            try {
                HornetQServerImpl.this.nodeManager.startBackup();
                if (!HornetQServerImpl.this.initialisePart1()) {
                    return;
                }
                HornetQServerImpl.this.clusterManager.start();
                HornetQServerImpl.this.state = SERVER_STATE.STARTED;
                HornetQServerLogger.LOGGER.backupServerStarted(HornetQServerImpl.this.version.getFullVersion(), HornetQServerImpl.this.nodeManager.getNodeId());
                HornetQServerImpl.this.nodeManager.awaitLiveNode();
                HornetQServerImpl.this.configuration.setBackup(false);
                if (HornetQServerImpl.this.state != SERVER_STATE.STARTED) {
                    return;
                }
                HornetQServerImpl.this.initialisePart2();
                HornetQServerImpl.this.clusterManager.activate();
                HornetQServerLogger.LOGGER.backupServerIsLive();
                HornetQServerImpl.this.nodeManager.releaseBackup();
                if (HornetQServerImpl.this.configuration.isAllowAutoFailBack()) {
                    HornetQServerImpl.this.startFailbackChecker();
                }
            }
            catch (InterruptedException e) {
            }
            catch (ClosedChannelException e) {
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof InterruptedException)) {
                    HornetQServerLogger.LOGGER.initializationError(e);
                }
            }
            catch (Throwable e) {
                HornetQServerLogger.LOGGER.initializationError(e);
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
            if (HornetQServerImpl.this.configuration.isBackup()) {
                long timeout = 30000L;
                long start = System.currentTimeMillis();
                while (HornetQServerImpl.this.backupActivationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
                    if (nodeManagerInUse != null) {
                        nodeManagerInUse.interrupt();
                    }
                    HornetQServerImpl.this.backupActivationThread.interrupt();
                    HornetQServerImpl.this.backupActivationThread.join(1000L);
                }
                if (System.currentTimeMillis() - start >= timeout) {
                    HornetQServerImpl.this.threadDump("Timed out waiting for backup activation to exit");
                }
                if (nodeManagerInUse != null) {
                    nodeManagerInUse.stopBackup();
                }
            } else if (nodeManagerInUse != null) {
                if (permanently) {
                    nodeManagerInUse.crashLiveServer();
                } else {
                    nodeManagerInUse.pauseLiveServer();
                }
            }
        }
    }

    private final class SharedStoreLiveActivation
    implements Activation {
        private SharedStoreLiveActivation() {
        }

        @Override
        public void run() {
            try {
                HornetQServerLogger.LOGGER.awaitingLiveLock();
                HornetQServerImpl.this.checkJournalDirectory();
                if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                    HornetQServerLogger.LOGGER.debug("First part initialization on " + this);
                }
                if (!HornetQServerImpl.this.initialisePart1()) {
                    return;
                }
                if (HornetQServerImpl.this.nodeManager.isBackupLive()) {
                    if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                        HornetQServerLogger.LOGGER.debug("announcing backup to the former live" + this);
                    }
                    HornetQServerImpl.this.clusterManager.announceBackup();
                    Thread.sleep(HornetQServerImpl.this.configuration.getFailbackDelay());
                }
                HornetQServerImpl.this.nodeManager.startLiveNode();
                if (HornetQServerImpl.this.state == SERVER_STATE.STOPPED || HornetQServerImpl.this.state == SERVER_STATE.STOPPING) {
                    return;
                }
                HornetQServerImpl.this.initialisePart2();
                HornetQServerLogger.LOGGER.serverIsLive();
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.initializationError(e);
            }
        }

        @Override
        public void close(boolean permanently) throws Exception {
            NodeManager nodeManagerInUse = HornetQServerImpl.this.nodeManager;
            if (nodeManagerInUse != null) {
                if (permanently) {
                    nodeManagerInUse.crashLiveServer();
                } else {
                    nodeManagerInUse.pauseLiveServer();
                }
            }
        }
    }

    private class FailbackChecker
    implements Runnable {
        private boolean restarting = false;

        private FailbackChecker() {
        }

        @Override
        public void run() {
            try {
                if (!this.restarting && HornetQServerImpl.this.nodeManager.isAwaitingFailback()) {
                    HornetQServerLogger.LOGGER.awaitFailBack();
                    this.restarting = true;
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                HornetQServerLogger.LOGGER.debug(HornetQServerImpl.this + "::Stopping live node in favor of failback");
                                HornetQServerImpl.this.stop(true, false, true);
                                Thread.sleep(HornetQServerImpl.this.configuration.getFailbackDelay());
                                Object object = HornetQServerImpl.this.failbackCheckerGuard;
                                synchronized (object) {
                                    if (HornetQServerImpl.this.cancelFailBackChecker) {
                                        return;
                                    }
                                    HornetQServerImpl.this.configuration.setBackup(true);
                                    HornetQServerLogger.LOGGER.debug(HornetQServerImpl.this + "::Starting backup node now after failback");
                                    HornetQServerImpl.this.start();
                                }
                            }
                            catch (Exception e) {
                                HornetQServerLogger.LOGGER.serverRestartWarning();
                            }
                        }
                    });
                    t.start();
                }
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.serverRestartWarning(e);
            }
        }
    }

    static enum SERVER_STATE {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

