/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.JBossAppenderHandler;
import org.apache.log4j.JBossLevelMapping;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class JBossLogManagerFacade {
    public static final String LOG4J_ROOT_NAME = "root";
    public static final String JBL_ROOT_NAME = "";
    private static final Logger.AttachmentKey<Logger> LOGGER_KEY = new Logger.AttachmentKey();
    private static final Logger.AttachmentKey<Hierarchy> HIERARCHY_KEY = new Logger.AttachmentKey();

    private JBossLogManagerFacade() {
    }

    public static org.jboss.logmanager.Logger getJBossLogger(String name) {
        String loggerName = name == null || name.equals(LOG4J_ROOT_NAME) ? JBL_ROOT_NAME : name;
        org.jboss.logmanager.Logger result = LogContext.getLogContext().getLogger(loggerName);
        JBossAppenderHandler.createAndAttach(result);
        return result;
    }

    public static LoggerRepository getLoggerRepository() {
        org.jboss.logmanager.Logger jbossRoot = JBossLogManagerFacade.getJBossRootLogger();
        Object hierarchy = (Hierarchy)jbossRoot.getAttachment(HIERARCHY_KEY);
        if (hierarchy == null) {
            Object appearing;
            Object root = (Logger)jbossRoot.getAttachment(LOGGER_KEY);
            if (root == null && (appearing = (Logger)jbossRoot.attachIfAbsent(LOGGER_KEY, root = new RootLogger(JBossLevelMapping.getPriorityFor(jbossRoot.getLevel())))) != null) {
                root = appearing;
            }
            if ((appearing = (Hierarchy)jbossRoot.attachIfAbsent(HIERARCHY_KEY, hierarchy = new Hierarchy((Logger)root))) != null) {
                hierarchy = appearing;
            }
        }
        return hierarchy;
    }

    public static LoggerRepository getLoggerRepository(LogContext logContext) {
        org.jboss.logmanager.Logger jbossRoot = logContext.getLogger(JBL_ROOT_NAME);
        Object hierarchy = (Hierarchy)jbossRoot.getAttachment(HIERARCHY_KEY);
        if (hierarchy == null) {
            Object appearing;
            Object root = (Logger)jbossRoot.getAttachment(LOGGER_KEY);
            if (root == null && (appearing = (Logger)jbossRoot.attachIfAbsent(LOGGER_KEY, root = new RootLogger(JBossLevelMapping.getPriorityFor(jbossRoot.getLevel())))) != null) {
                root = appearing;
            }
            if ((appearing = (Hierarchy)jbossRoot.attachIfAbsent(HIERARCHY_KEY, hierarchy = new Hierarchy((Logger)root))) != null) {
                hierarchy = appearing;
            }
        }
        return hierarchy;
    }

    public static org.jboss.logmanager.Logger getJBossRootLogger() {
        return JBossLogManagerFacade.getJBossLogger(JBL_ROOT_NAME);
    }

    public static Logger exists(String name) {
        org.jboss.logmanager.Logger logger = LogContext.getLogContext().getLoggerIfExists(name);
        return logger == null ? null : (Logger)logger.getAttachment(LOGGER_KEY);
    }

    public static Logger getLogger(org.jboss.logmanager.Logger lmLogger) {
        return (Logger)lmLogger.getAttachment(LOGGER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(LoggerRepository repository, String name, LoggerFactory factory) {
        org.jboss.logmanager.Logger lmLogger = JBossLogManagerFacade.getJBossLogger(name);
        Logger logger = (Logger)lmLogger.getAttachment(LOGGER_KEY);
        if (logger == null) {
            Logger.AttachmentKey<Logger> attachmentKey = LOGGER_KEY;
            synchronized (attachmentKey) {
                logger = factory.makeNewLoggerInstance(name);
                Logger currentLogger = (Logger)lmLogger.attachIfAbsent(LOGGER_KEY, (Object)logger);
                if (currentLogger != null) {
                    logger = currentLogger;
                }
                JBossLogManagerFacade.updateParents(repository, logger);
            }
        }
        return logger;
    }

    public static Collection<Logger> getLoggers() {
        LogContext context = LogContext.getLogContext();
        List<String> currentLoggerNames = context.getLoggingMXBean().getLoggerNames();
        ArrayList<Logger> currentLoggers = new ArrayList<Logger>(currentLoggerNames.size());
        for (String name : currentLoggerNames) {
            Logger logger;
            org.jboss.logmanager.Logger lmLogger = context.getLoggerIfExists(name);
            if (lmLogger == null || (logger = (Logger)lmLogger.getAttachment(LOGGER_KEY)) == null) continue;
            currentLoggers.add(logger);
        }
        return currentLoggers;
    }

    public static Collection<org.jboss.logmanager.Logger> getJBossLoggers() {
        LogContext context = LogContext.getLogContext();
        List<String> currentLoggerNames = context.getLoggingMXBean().getLoggerNames();
        ArrayList<org.jboss.logmanager.Logger> currentLoggers = new ArrayList<org.jboss.logmanager.Logger>(currentLoggerNames.size());
        for (String name : currentLoggerNames) {
            org.jboss.logmanager.Logger lmLogger = context.getLoggerIfExists(name);
            if (lmLogger == null) continue;
            currentLoggers.add(lmLogger);
        }
        return currentLoggers;
    }

    private static void updateParents(LoggerRepository repository, Logger cat) {
        String name = cat.getName();
        int length = name.length();
        boolean addRootAsParent = true;
        int i = name.lastIndexOf(46, length - 1);
        while (i >= 0) {
            org.jboss.logmanager.Logger lmLogger = LogContext.getLogContext().getLoggerIfExists(name.substring(0, i));
            if (lmLogger != null) {
                cat.parent = (Category)lmLogger.getAttachment(LOGGER_KEY);
                if (cat.parent != null) {
                    addRootAsParent = false;
                    break;
                }
            }
            i = name.lastIndexOf(46, i - 1);
        }
        if (addRootAsParent) {
            cat.parent = repository.getRootLogger();
        }
    }
}

