/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import org.jboss.as.clustering.web.sso.SSOClusterManager;
import org.jboss.as.clustering.web.sso.SSOClusterManagerService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.as.web.VirtualHost;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebReWriteConditionDefinition;
import org.jboss.as.web.WebReWriteDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.as.web.WebVirtualHostService;
import org.jboss.as.web.WelcomeContextService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class WebVirtualHostAdd
extends AbstractAddStepHandler {
    static final WebVirtualHostAdd INSTANCE = new WebVirtualHostAdd();
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    private static final String HOME_DIR = "jboss.home.dir";
    private static final String[] NO_ALIASES = new String[0];

    private WebVirtualHostAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        model.get(WebVirtualHostDefinition.NAME.getName()).set(address.getLastElement().getValue());
        WebVirtualHostDefinition.ALIAS.validateAndSet(operation, model);
        WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.validateAndSet(operation, model);
        WebVirtualHostDefinition.DEFAULT_WEB_MODULE.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode baseOperation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress address = PathAddress.pathAddress((ModelNode)baseOperation.require("address"));
        String name = address.getLastElement().getValue();
        boolean welcome = WebVirtualHostDefinition.ENABLE_WELCOME_ROOT.resolveModelAttribute(context, fullModel).asBoolean();
        ServiceTarget serviceTarget = context.getServiceTarget();
        WebVirtualHostService service = new WebVirtualHostService(name, WebVirtualHostAdd.aliases(fullModel), welcome, TEMP_DIR);
        ServiceBuilder serviceBuilder = serviceTarget.addService(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name}), (Service)service).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector()).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getWebServer());
        if (fullModel.get(new String[]{WebExtension.ACCESS_LOG_PATH.getKey(), WebExtension.ACCESS_LOG_PATH.getValue()}).isDefined()) {
            ModelNode unresolved = fullModel.get(new String[]{WebExtension.ACCESS_LOG_PATH.getKey(), WebExtension.ACCESS_LOG_PATH.getValue()});
            service.setAccessLog(this.resolveExpressions(context, unresolved, (AttributeDefinition[])WebAccessLogDefinition.ACCESS_LOG_ATTRIBUTES));
            ModelNode accessLogDir = unresolved.get(new String[]{WebExtension.DIRECTORY_PATH.getKey(), WebExtension.DIRECTORY_PATH.getValue()});
            String relativeTo = WebAccessLogDirectoryDefinition.RELATIVE_TO.resolveModelAttribute(context, accessLogDir).asString();
            ModelNode pathNode = WebAccessLogDirectoryDefinition.PATH.resolveModelAttribute(context, accessLogDir);
            service.setAccessLogPaths(pathNode.isDefined() ? pathNode.asString() : name, relativeTo);
        }
        if (fullModel.hasDefined("rewrite")) {
            ModelNode resolvedRewrite = this.resolveRewriteExpressions(context, fullModel.get("rewrite"));
            service.setRewrite(resolvedRewrite);
        }
        if (fullModel.get(new String[]{WebExtension.SSO_PATH.getKey(), WebExtension.SSO_PATH.getValue()}).isDefined()) {
            ModelNode sso = this.resolveExpressions(context, fullModel.get(new String[]{WebExtension.SSO_PATH.getKey(), WebExtension.SSO_PATH.getValue()}).clone(), (AttributeDefinition[])WebSSODefinition.SSO_ATTRIBUTES);
            service.setSso(sso);
            if (sso.hasDefined("cache-container")) {
                ServiceName ssoName = WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name, "sso"});
                serviceBuilder.addDependency(ssoName, SSOClusterManager.class, service.getSSOClusterManager());
                SSOClusterManagerService ssoService = new SSOClusterManagerService();
                SSOClusterManager ssoManager = ssoService.getValue();
                ssoManager.setCacheContainerName(sso.get("cache-container").asString());
                if (sso.hasDefined("cache-name")) {
                    ssoManager.setCacheName(sso.get("cache-name").asString());
                }
                ServiceBuilder builder = serviceTarget.addService(ssoName, (Service)ssoService);
                ssoService.getValue().addDependencies(serviceTarget, builder);
                newControllers.add(builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install());
            }
        }
        if (fullModel.hasDefined(WebVirtualHostDefinition.DEFAULT_WEB_MODULE.getName())) {
            if (welcome) {
                throw new OperationFailedException(new ModelNode().set(WebMessages.MESSAGES.noRootWebappWithWelcomeWebapp()));
            }
            service.setDefaultWebModule(WebVirtualHostDefinition.DEFAULT_WEB_MODULE.resolveModelAttribute(context, fullModel).asString());
        }
        serviceBuilder.addListener((ServiceListener)verificationHandler);
        newControllers.add(serviceBuilder.install());
        if (welcome) {
            WelcomeContextService welcomeService = new WelcomeContextService(HOME_DIR);
            newControllers.add(context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB.append(new String[]{name}).append(new String[]{"welcome"}), (Service)welcomeService).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, welcomeService.getPathManagerInjector()).addDependency(WebSubsystemServices.JBOSS_WEB_HOST.append(new String[]{name}), VirtualHost.class, welcomeService.getHostInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, HttpManagementService.SERVICE_NAME, HttpManagement.class, welcomeService.getHttpManagementInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
    }

    static String[] aliases(ModelNode node) {
        if (node.hasDefined("alias")) {
            ModelNode aliases = node.require("alias");
            int size = aliases.asInt();
            String[] array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = aliases.get(i).asString();
            }
            return array;
        }
        return NO_ALIASES;
    }

    private ModelNode resolveRewriteExpressions(OperationContext context, ModelNode unresolvedRewriteChildren) throws OperationFailedException {
        ModelNode result = new ModelNode();
        for (Property prop : unresolvedRewriteChildren.asPropertyList()) {
            ModelNode resolvedParent = this.resolveExpressions(context, prop.getValue(), (AttributeDefinition[])WebReWriteDefinition.ATTRIBUTES);
            result.get(prop.getName()).set(resolvedParent);
            if (!prop.getValue().hasDefined("condition")) continue;
            for (Property conditionProp : prop.getValue().get("condition").asPropertyList()) {
                ModelNode resolvedCondition = this.resolveExpressions(context, conditionProp.getValue(), (AttributeDefinition[])WebReWriteConditionDefinition.ATTRIBUTES);
                result.get(prop.getName()).get(new String[]{"condition", conditionProp.getName()}).set(resolvedCondition);
            }
        }
        return result;
    }

    private ModelNode resolveExpressions(OperationContext context, ModelNode fullModel, AttributeDefinition ... attributeDefinitions) throws OperationFailedException {
        ModelNode result = new ModelNode();
        for (AttributeDefinition def : attributeDefinitions) {
            result.get(def.getName()).set(def.resolveModelAttribute(context, fullModel));
        }
        return result;
    }
}

