/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.DirContext;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.JspPropertyGroup;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.Multipart;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.SessionCookie;
import org.apache.catalina.deploy.jsp.FunctionInfo;
import org.apache.catalina.deploy.jsp.TagAttributeInfo;
import org.apache.catalina.deploy.jsp.TagFileInfo;
import org.apache.catalina.deploy.jsp.TagInfo;
import org.apache.catalina.deploy.jsp.TagLibraryInfo;
import org.apache.catalina.deploy.jsp.TagLibraryValidatorInfo;
import org.apache.catalina.deploy.jsp.TagVariableInfo;
import org.apache.catalina.startup.ContextConfig;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.annotation.javaee.Icon;
import org.jboss.as.clustering.ClassLoaderAwareClassResolver;
import org.jboss.as.clustering.web.DistributedCacheManagerFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.AuthenticatorValve;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebServerService;
import org.jboss.as.web.deployment.ScisMetaData;
import org.jboss.as.web.deployment.TldsMetaData;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.helpers.VFSDirContext;
import org.jboss.as.web.session.DistributableSessionManager;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.merge.web.jboss.JBossWebMetaDataMerger;
import org.jboss.metadata.web.jboss.JBossAnnotationMetaData;
import org.jboss.metadata.web.jboss.JBossAnnotationsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.AuthConstraintMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroupMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingsMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TaglibMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.VariableMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.metadata.web.spec.WelcomeFileListMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.jboss.vfs.VirtualFile;

public class JBossContextConfig
extends ContextConfig {
    private DeploymentUnit deploymentUnitContext = null;
    private Set<String> overlays = new HashSet<String>();
    private final InjectedValue<DistributedCacheManagerFactory> factory = new InjectedValue();
    private Map<String, AuthenticatorValve> authenValves = null;
    private boolean DELETE_WORK_DIR_ONCONTEXTDESTROY = Boolean.valueOf(System.getProperty("org.jboss.as.web.deployment.DELETE_WORK_DIR_ONCONTEXTDESTROY", "false"));

    public JBossContextConfig(DeploymentUnit deploymentUnitContext) {
        this.deploymentUnitContext = deploymentUnitContext;
    }

    public JBossContextConfig(DeploymentUnit deploymentUnitContext, WebServerService service) {
        this.deploymentUnitContext = deploymentUnitContext;
        if (service != null) {
            this.authenValves = service.getAuthenValves();
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("after_start")) {
            VFSDirContext dirContext;
            WarMetaData warMetaData = (WarMetaData)this.deploymentUnitContext.getAttachment(WarMetaData.ATTACHMENT_KEY);
            Set<VirtualFile> overlayVirtualFiles = warMetaData.getOverlays();
            if (overlayVirtualFiles != null) {
                if (this.context.getResources() instanceof ProxyDirContext) {
                    ProxyDirContext resources = (ProxyDirContext)this.context.getResources();
                    for (VirtualFile overlay : overlayVirtualFiles) {
                        dirContext = new VFSDirContext();
                        dirContext.setVirtualFile(overlay);
                        resources.addOverlay((DirContext)((Object)dirContext));
                    }
                } else if (overlayVirtualFiles.size() > 0) {
                    WebLogger.WEB_LOGGER.noOverlay(this.context.getName());
                    this.ok = false;
                }
            }
            for (String overlay : this.overlays) {
                if (!(this.context.getResources() instanceof ProxyDirContext)) continue;
                ProxyDirContext resources = (ProxyDirContext)this.context.getResources();
                dirContext = new FileDirContext();
                dirContext.setDocBase(overlay);
                resources.addOverlay((DirContext)((Object)dirContext));
            }
            ScisMetaData scisMetaData = (ScisMetaData)this.deploymentUnitContext.getAttachment(ScisMetaData.ATTACHMENT_KEY);
            if (scisMetaData != null) {
                for (ServletContainerInitializer sci : scisMetaData.getScis()) {
                    try {
                        sci.onStartup(scisMetaData.getHandlesTypes().get(sci), this.context.getServletContext());
                    }
                    catch (Throwable t) {
                        WebLogger.WEB_LOGGER.sciOnStartupError(sci.getClass().getName(), t);
                        this.ok = false;
                    }
                }
            }
            List<String> order = warMetaData.getOrder();
            if (!warMetaData.isNoOrder()) {
                this.context.getServletContext().setAttribute("javax.servlet.context.orderedLibs", order);
            }
        }
        super.lifecycleEvent(event);
    }

    protected void applicationWebConfig() {
        WarMetaData warMetaData = (WarMetaData)this.deploymentUnitContext.getAttachment(WarMetaData.ATTACHMENT_KEY);
        this.processJBossWebMetaData(warMetaData.getMergedJBossWebMetaData());
        this.processWebMetaData(warMetaData.getMergedJBossWebMetaData());
    }

    protected void defaultWebConfig() {
        JBossWebMetaData sharedJBossWebMetaData = new JBossWebMetaData();
        WarMetaData warMetaData = (WarMetaData)this.deploymentUnitContext.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaDataMerger.merge((JBossWebMetaData)sharedJBossWebMetaData, null, (WebMetaData)warMetaData.getSharedWebMetaData());
        this.processJBossWebMetaData(sharedJBossWebMetaData);
        this.processWebMetaData(sharedJBossWebMetaData);
    }

    protected void processJBossWebMetaData(JBossWebMetaData metaData) {
        if (metaData.getOverlays() != null) {
            this.overlays.addAll(metaData.getOverlays());
        }
    }

    protected Object getInstance(String moduleName, String className, List<ParamValueMetaData> params) {
        try {
            Module module = (Module)this.deploymentUnitContext.getAttachment(Attachments.MODULE);
            Object moduleClassLoader = null;
            moduleClassLoader = moduleName == null ? (this.context.getLoader() == null || this.context.getLoader().getClassLoader() == null ? module.getClassLoader() : this.context.getLoader().getClassLoader()) : module.getModule(ModuleIdentifier.create((String)moduleName)).getClassLoader();
            Object instance = moduleClassLoader.loadClass(className).newInstance();
            if (params != null) {
                for (ParamValueMetaData param : params) {
                    IntrospectionUtils.setProperty(instance, (String)param.getParamName(), (String)param.getParamValue());
                }
            }
            return instance;
        }
        catch (Throwable t) {
            WebLogger.WEB_LOGGER.componentInstanceCreationFailed(className, t);
            this.ok = false;
            return null;
        }
    }

    protected void processWebMetaData(JBossWebMetaData metaData) {
        SessionConfigMetaData scmd;
        WelcomeFileListMetaData welcomeFiles;
        LocaleEncodingsMetaData locales;
        JspConfigMetaData config;
        List smappings;
        JBossServletsMetaData servlets;
        SecurityRolesMetaData roles;
        List scs;
        List mimes;
        LoginConfigMetaData loginConfig;
        List listeners;
        List filtersMappings;
        FiltersMetaData filters;
        List errorPages;
        List contextParams;
        Module module;
        String displayName;
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setReplaceWelcomeFiles(true);
        }
        this.context.setVersion(metaData.getVersion());
        if (metaData.is30()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_3_0.dtd");
        } else if (metaData.is25()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_5.dtd");
        } else if (metaData.is24()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_4.dtd");
        } else if (metaData.is23()) {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        } else {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
        }
        DescriptionGroupMetaData dg = metaData.getDescriptionGroup();
        if (dg != null && (displayName = dg.getDisplayName()) != null) {
            this.context.setDisplayName(displayName);
        }
        if ((module = (Module)this.deploymentUnitContext.getAttachment(Attachments.MODULE)) != null && metaData.getDistributable() != null) {
            try {
                ModularClassResolver resolver = ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader());
                this.context.setManager(new DistributableSessionManager((DistributedCacheManagerFactory)this.factory.getValue(), metaData, (ClassResolver)new ClassLoaderAwareClassResolver((ClassResolver)resolver, (ClassLoader)module.getClassLoader())));
                this.context.setDistributable(true);
            }
            catch (Exception e) {
                WebLogger.WEB_LOGGER.clusteringNotSupported();
            }
        }
        if ((contextParams = metaData.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                this.context.addParameter(param.getParamName(), param.getParamValue());
            }
        }
        if ((errorPages = metaData.getErrorPages()) != null) {
            for (ErrorPageMetaData value : errorPages) {
                ErrorPage errorPage = new ErrorPage();
                errorPage.setErrorCode(value.getErrorCode());
                errorPage.setExceptionType(value.getExceptionType());
                errorPage.setLocation(value.getLocation());
                this.context.addErrorPage(errorPage);
            }
        }
        if ((filters = metaData.getFilters()) != null) {
            for (FilterMetaData value : filters) {
                FilterDef filterDef = new FilterDef();
                filterDef.setFilterName(value.getName());
                filterDef.setFilterClass(value.getFilterClass());
                if (value.getInitParam() != null) {
                    for (ParamValueMetaData param : value.getInitParam()) {
                        filterDef.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                filterDef.setAsyncSupported(value.isAsyncSupported());
                this.context.addFilterDef(filterDef);
            }
        }
        if ((filtersMappings = metaData.getFilterMappings()) != null) {
            for (FilterMappingMetaData value : filtersMappings) {
                List dispatchers;
                List urlPatterns;
                FilterMap filterMap = new FilterMap();
                filterMap.setFilterName(value.getFilterName());
                List servletNames = value.getServletNames();
                if (servletNames != null) {
                    for (String name : servletNames) {
                        filterMap.addServletName(name);
                    }
                }
                if ((urlPatterns = value.getUrlPatterns()) != null) {
                    for (String pattern : urlPatterns) {
                        filterMap.addURLPattern(pattern);
                    }
                }
                if ((dispatchers = value.getDispatchers()) != null) {
                    for (DispatcherType type : dispatchers) {
                        filterMap.setDispatcher(type.name());
                    }
                }
                this.context.addFilterMap(filterMap);
            }
        }
        if ((listeners = metaData.getListeners()) != null) {
            for (ListenerMetaData value : listeners) {
                this.context.addApplicationListener(value.getListenerClass());
            }
        }
        if ((loginConfig = metaData.getLoginConfig()) != null) {
            LoginConfig loginConfig2 = new LoginConfig();
            loginConfig2.setAuthMethod(loginConfig.getAuthMethod());
            loginConfig2.setRealmName(loginConfig.getRealmName());
            if (loginConfig.getFormLoginConfig() != null) {
                loginConfig2.setLoginPage(loginConfig.getFormLoginConfig().getLoginPage());
                loginConfig2.setErrorPage(loginConfig.getFormLoginConfig().getErrorPage());
            }
            this.context.setLoginConfig(loginConfig2);
        }
        if ((mimes = metaData.getMimeMappings()) != null) {
            for (MimeMappingMetaData value : mimes) {
                this.context.addMimeMapping(value.getExtension(), value.getMimeType());
            }
        }
        if ((scs = metaData.getSecurityConstraints()) != null) {
            for (SecurityConstraintMetaData value : scs) {
                WebResourceCollectionsMetaData wrcs;
                SecurityConstraint constraint = new SecurityConstraint();
                TransportGuaranteeType tg = value.getTransportGuarantee();
                constraint.setUserConstraint(tg.name());
                AuthConstraintMetaData acmd = value.getAuthConstraint();
                constraint.setAuthConstraint(acmd != null);
                if (acmd != null && acmd.getRoleNames() != null) {
                    for (String role : acmd.getRoleNames()) {
                        constraint.addAuthRole(role);
                    }
                }
                if ((wrcs = value.getResourceCollections()) != null) {
                    for (WebResourceCollectionMetaData wrc : wrcs) {
                        List patterns;
                        List methodOmissions;
                        SecurityCollection collection2 = new SecurityCollection();
                        collection2.setName(wrc.getName());
                        List methods = wrc.getHttpMethods();
                        if (methods != null) {
                            for (String method : wrc.getHttpMethods()) {
                                collection2.addMethod(method);
                            }
                        }
                        if ((methodOmissions = wrc.getHttpMethodOmissions()) != null) {
                            for (String method : wrc.getHttpMethodOmissions()) {
                                collection2.addMethodOmission(method);
                            }
                        }
                        if ((patterns = wrc.getUrlPatterns()) != null) {
                            for (String pattern : patterns) {
                                collection2.addPattern(pattern);
                            }
                        }
                        constraint.addCollection(collection2);
                    }
                }
                this.context.addConstraint(constraint);
            }
        }
        if ((roles = metaData.getSecurityRoles()) != null) {
            for (SecurityRoleMetaData value : roles) {
                this.context.addSecurityRole(value.getRoleName());
            }
        }
        if ((servlets = metaData.getServlets()) != null) {
            for (JBossServletMetaData value : servlets) {
                SecurityRoleRefsMetaData refs;
                List params;
                Wrapper wrapper = this.context.createWrapper();
                wrapper.setName(value.getName());
                wrapper.setServletClass(value.getServletClass());
                if (value.getJspFile() != null) {
                    wrapper.setJspFile(value.getJspFile());
                }
                wrapper.setLoadOnStartup(value.getLoadOnStartupInt());
                if (value.getRunAs() != null) {
                    wrapper.setRunAs(value.getRunAs().getRoleName());
                }
                if ((params = value.getInitParam()) != null) {
                    for (ParamValueMetaData param : params) {
                        wrapper.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                if ((refs = value.getSecurityRoleRefs()) != null) {
                    for (SecurityRoleRefMetaData ref : refs) {
                        wrapper.addSecurityReference(ref.getRoleName(), ref.getRoleLink());
                    }
                }
                wrapper.setAsyncSupported(value.isAsyncSupported());
                wrapper.setEnabled(value.isEnabled());
                if (value.getMultipartConfig() != null) {
                    MultipartConfigMetaData multipartConfigMetaData = value.getMultipartConfig();
                    Multipart multipartConfig = new Multipart();
                    multipartConfig.setLocation(multipartConfigMetaData.getLocation());
                    multipartConfig.setMaxRequestSize(multipartConfigMetaData.getMaxRequestSize());
                    multipartConfig.setMaxFileSize(multipartConfigMetaData.getMaxFileSize());
                    multipartConfig.setFileSizeThreshold(multipartConfigMetaData.getFileSizeThreshold());
                    wrapper.setMultipartConfig(multipartConfig);
                }
                this.context.addChild((Container)wrapper);
            }
        }
        if ((smappings = metaData.getServletMappings()) != null) {
            for (ServletMappingMetaData value : smappings) {
                List urlPatterns = value.getUrlPatterns();
                if (urlPatterns == null) continue;
                for (String pattern : urlPatterns) {
                    this.context.addServletMapping(pattern, value.getServletName());
                }
            }
        }
        if ((config = metaData.getJspConfig()) != null) {
            List taglibs;
            List groups = config.getPropertyGroups();
            if (groups != null) {
                for (JspPropertyGroupMetaData group : groups) {
                    JspPropertyGroup jspPropertyGroup = new JspPropertyGroup();
                    for (String pattern : group.getUrlPatterns()) {
                        jspPropertyGroup.addUrlPattern(pattern);
                    }
                    jspPropertyGroup.setElIgnored(group.getElIgnored());
                    jspPropertyGroup.setPageEncoding(group.getPageEncoding());
                    jspPropertyGroup.setScriptingInvalid(group.getScriptingInvalid());
                    jspPropertyGroup.setIsXml(group.getIsXml());
                    if (group.getIncludePreludes() != null) {
                        for (String includePrelude : group.getIncludePreludes()) {
                            jspPropertyGroup.addIncludePrelude(includePrelude);
                        }
                    }
                    if (group.getIncludeCodas() != null) {
                        for (String includeCoda : group.getIncludeCodas()) {
                            jspPropertyGroup.addIncludeCoda(includeCoda);
                        }
                    }
                    jspPropertyGroup.setDeferredSyntaxAllowedAsLiteral(group.getDeferredSyntaxAllowedAsLiteral());
                    jspPropertyGroup.setTrimDirectiveWhitespaces(group.getTrimDirectiveWhitespaces());
                    jspPropertyGroup.setDefaultContentType(group.getDefaultContentType());
                    jspPropertyGroup.setBuffer(group.getBuffer());
                    jspPropertyGroup.setErrorOnUndeclaredNamespace(group.getErrorOnUndeclaredNamespace());
                    this.context.addJspPropertyGroup(jspPropertyGroup);
                }
            }
            if ((taglibs = config.getTaglibs()) != null) {
                for (TaglibMetaData taglib : taglibs) {
                    this.context.addTaglib(taglib.getTaglibUri(), taglib.getTaglibLocation());
                }
            }
        }
        if ((locales = metaData.getLocalEncodings()) != null) {
            for (LocaleEncodingMetaData value : locales.getMappings()) {
                this.context.addLocaleEncodingMappingParameter(value.getLocale(), value.getEncoding());
            }
        }
        if ((welcomeFiles = metaData.getWelcomeFileList()) != null) {
            for (String value : welcomeFiles.getWelcomeFiles()) {
                this.context.addWelcomeFile(value);
            }
        }
        if ((scmd = metaData.getSessionConfig()) != null) {
            this.context.setSessionTimeout(scmd.getSessionTimeout());
            if (scmd.getSessionTrackingModes() != null) {
                for (SessionTrackingModeType stmt : scmd.getSessionTrackingModes()) {
                    this.context.addSessionTrackingMode(stmt.toString());
                }
            }
            if (scmd.getCookieConfig() != null) {
                String value;
                value = scmd.getCookieConfig();
                SessionCookie cookieConfig = new SessionCookie();
                cookieConfig.setName(value.getName());
                cookieConfig.setDomain(value.getDomain());
                cookieConfig.setPath(value.getPath());
                cookieConfig.setComment(value.getComment());
                cookieConfig.setHttpOnly(value.getHttpOnly());
                cookieConfig.setSecure(value.getSecure());
                cookieConfig.setMaxAge(value.getMaxAge());
                this.context.setSessionCookie(cookieConfig);
            }
        }
    }

    protected void init() {
        this.context.setConfigured(false);
        this.ok = true;
    }

    protected void destroy() {
        if (this.DELETE_WORK_DIR_ONCONTEXTDESTROY) {
            super.destroy();
        }
    }

    protected void applicationTldConfig() {
        TldsMetaData tldsMetaData = (TldsMetaData)this.deploymentUnitContext.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        if (tldsMetaData == null) {
            return;
        }
        Map<String, TldMetaData> localTlds = tldsMetaData.getTlds();
        List<TldMetaData> sharedTlds = tldsMetaData.getSharedTlds(this.deploymentUnitContext);
        ArrayList<TagLibraryInfo> tagLibraries = new ArrayList<TagLibraryInfo>();
        for (String location : localTlds.keySet()) {
            this.processTld(tagLibraries, location, localTlds.get(location));
        }
        for (TldMetaData sharedTld : sharedTlds) {
            this.processTld(tagLibraries, null, sharedTld);
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String uri = taglibs[i];
            String path = this.context.findTaglib(taglibs[i]);
            String location = "";
            if (path.indexOf(58) == -1 && !path.startsWith("/")) {
                path = "/WEB-INF/" + path;
            }
            if (path.endsWith(".jar")) {
                location = path;
                path = "META-INF/taglib.tld";
            }
            for (int j = 0; j < tagLibraries.size(); ++j) {
                TagLibraryInfo tagLibraryInfo = tagLibraries.get(j);
                if (!tagLibraryInfo.getLocation().equals(location) || !tagLibraryInfo.getPath().equals(path)) continue;
                this.context.addJspTagLibrary(uri, tagLibraryInfo);
            }
        }
    }

    protected void processTld(ArrayList<TagLibraryInfo> tagLibraries, String location, TldMetaData tldMetaData) {
        int pos;
        String relativeLocation = location;
        String jarPath = null;
        if (relativeLocation != null && relativeLocation.startsWith("/WEB-INF/lib/") && (pos = relativeLocation.indexOf(47, "/WEB-INF/lib/".length())) > 0) {
            jarPath = relativeLocation.substring(pos);
            if (jarPath.startsWith("/")) {
                jarPath = jarPath.substring(1);
            }
            relativeLocation = relativeLocation.substring(0, pos);
        }
        TagLibraryInfo tagLibraryInfo = new TagLibraryInfo();
        tagLibraryInfo.setTlibversion(tldMetaData.getTlibVersion());
        if (tldMetaData.getJspVersion() == null) {
            tagLibraryInfo.setJspversion(tldMetaData.getVersion());
        } else {
            tagLibraryInfo.setJspversion(tldMetaData.getJspVersion());
        }
        tagLibraryInfo.setShortname(tldMetaData.getShortName());
        tagLibraryInfo.setUri(tldMetaData.getUri());
        if (tldMetaData.getDescriptionGroup() != null) {
            tagLibraryInfo.setInfo(tldMetaData.getDescriptionGroup().getDescription());
        }
        if (tldMetaData.getListeners() != null) {
            for (ListenerMetaData listener : tldMetaData.getListeners()) {
                tagLibraryInfo.addListener(listener.getListenerClass());
            }
        }
        if (tldMetaData.getValidator() != null) {
            TagLibraryValidatorInfo tagLibraryValidatorInfo = new TagLibraryValidatorInfo();
            tagLibraryValidatorInfo.setValidatorClass(tldMetaData.getValidator().getValidatorClass());
            if (tldMetaData.getValidator().getInitParams() != null) {
                for (ParamValueMetaData paramValueMetaData : tldMetaData.getValidator().getInitParams()) {
                    tagLibraryValidatorInfo.addInitParam(paramValueMetaData.getParamName(), (Object)paramValueMetaData.getParamValue());
                }
            }
            tagLibraryInfo.setValidator(tagLibraryValidatorInfo);
        }
        if (tldMetaData.getTags() != null) {
            for (TagMetaData tagMetaData : tldMetaData.getTags()) {
                TagInfo tagInfo = new TagInfo();
                tagInfo.setTagName(tagMetaData.getName());
                tagInfo.setTagClassName(tagMetaData.getTagClass());
                tagInfo.setTagExtraInfo(tagMetaData.getTeiClass());
                if (tagMetaData.getBodyContent() != null) {
                    tagInfo.setBodyContent(tagMetaData.getBodyContent().toString());
                }
                tagInfo.setDynamicAttributes(tagMetaData.getDynamicAttributes());
                if (tagMetaData.getDescriptionGroup() != null) {
                    DescriptionGroupMetaData descriptionGroup = tagMetaData.getDescriptionGroup();
                    if (descriptionGroup.getIcons() != null && descriptionGroup.getIcons().value() != null && descriptionGroup.getIcons().value().length > 0) {
                        Icon icon = descriptionGroup.getIcons().value()[0];
                        tagInfo.setLargeIcon(icon.largeIcon());
                        tagInfo.setSmallIcon(icon.smallIcon());
                    }
                    tagInfo.setInfoString(descriptionGroup.getDescription());
                    tagInfo.setDisplayName(descriptionGroup.getDisplayName());
                }
                if (tagMetaData.getVariables() != null) {
                    for (VariableMetaData variableMetaData : tagMetaData.getVariables()) {
                        TagVariableInfo tagVariableInfo = new TagVariableInfo();
                        tagVariableInfo.setNameGiven(variableMetaData.getNameGiven());
                        tagVariableInfo.setNameFromAttribute(variableMetaData.getNameFromAttribute());
                        tagVariableInfo.setClassName(variableMetaData.getVariableClass());
                        tagVariableInfo.setDeclare(variableMetaData.getDeclare());
                        if (variableMetaData.getScope() != null) {
                            tagVariableInfo.setScope(variableMetaData.getScope().toString());
                        }
                        tagInfo.addTagVariableInfo(tagVariableInfo);
                    }
                }
                if (tagMetaData.getAttributes() != null) {
                    for (AttributeMetaData attributeMetaData : tagMetaData.getAttributes()) {
                        TagAttributeInfo tagAttributeInfo = new TagAttributeInfo();
                        tagAttributeInfo.setName(attributeMetaData.getName());
                        tagAttributeInfo.setType(attributeMetaData.getType());
                        tagAttributeInfo.setReqTime(attributeMetaData.getRtexprvalue());
                        tagAttributeInfo.setRequired(attributeMetaData.getRequired());
                        tagAttributeInfo.setFragment(attributeMetaData.getFragment());
                        if (attributeMetaData.getDeferredValue() != null) {
                            tagAttributeInfo.setDeferredValue("true");
                            tagAttributeInfo.setExpectedTypeName(attributeMetaData.getDeferredValue().getType());
                        } else {
                            tagAttributeInfo.setDeferredValue("false");
                        }
                        if (attributeMetaData.getDeferredMethod() != null) {
                            tagAttributeInfo.setDeferredMethod("true");
                            tagAttributeInfo.setMethodSignature(attributeMetaData.getDeferredMethod().getMethodSignature());
                        } else {
                            tagAttributeInfo.setDeferredMethod("false");
                        }
                        tagInfo.addTagAttributeInfo(tagAttributeInfo);
                    }
                }
                tagLibraryInfo.addTagInfo(tagInfo);
            }
        }
        if (tldMetaData.getTagFiles() != null) {
            for (TagFileMetaData tagFileMetaData : tldMetaData.getTagFiles()) {
                TagFileInfo tagFileInfo = new TagFileInfo();
                tagFileInfo.setName(tagFileMetaData.getName());
                tagFileInfo.setPath(tagFileMetaData.getPath());
                tagLibraryInfo.addTagFileInfo(tagFileInfo);
            }
        }
        if (tldMetaData.getFunctions() != null) {
            for (FunctionMetaData functionMetaData : tldMetaData.getFunctions()) {
                FunctionInfo functionInfo = new FunctionInfo();
                functionInfo.setName(functionMetaData.getName());
                functionInfo.setFunctionClass(functionMetaData.getFunctionClass());
                functionInfo.setFunctionSignature(functionMetaData.getFunctionSignature());
                tagLibraryInfo.addFunctionInfo(functionInfo);
            }
        }
        if (jarPath == null && relativeLocation == null) {
            this.context.addJspTagLibrary(tagLibraryInfo);
        } else if (jarPath == null) {
            tagLibraryInfo.setLocation("");
            tagLibraryInfo.setPath(relativeLocation);
            tagLibraries.add(tagLibraryInfo);
            this.context.addJspTagLibrary(tagLibraryInfo);
            this.context.addJspTagLibrary(relativeLocation, tagLibraryInfo);
        } else {
            tagLibraryInfo.setLocation(relativeLocation);
            tagLibraryInfo.setPath(jarPath);
            tagLibraries.add(tagLibraryInfo);
            this.context.addJspTagLibrary(tagLibraryInfo);
            if (jarPath.equals("META-INF/taglib.tld")) {
                this.context.addJspTagLibrary(relativeLocation, tagLibraryInfo);
            }
        }
    }

    public void applicationServletContainerInitializerConfig() {
    }

    protected void createFragmentsOrder() {
    }

    protected void applicationExtraDescriptorsConfig() {
    }

    protected void resolveAnnotations(JBossAnnotationsMetaData annotations) {
        if (annotations != null) {
            for (JBossAnnotationMetaData annotation : annotations) {
                String className = annotation.getClassName();
                Container[] wrappers = this.context.findChildren();
                for (int i = 0; i < wrappers.length; ++i) {
                    Wrapper wrapper = (Wrapper)wrappers[i];
                    if (!className.equals(wrapper.getServletClass())) continue;
                    if (annotation.getRunAs() != null && wrapper.getRunAs() == null) {
                        wrapper.setRunAs(annotation.getRunAs().getRoleName());
                    }
                    if (annotation.getMultipartConfig() != null && wrapper.getMultipartConfig() == null) {
                        MultipartConfigMetaData multipartConfigMetaData = annotation.getMultipartConfig();
                        Multipart multipartConfig = new Multipart();
                        multipartConfig.setLocation(multipartConfigMetaData.getLocation());
                        multipartConfig.setMaxRequestSize(multipartConfigMetaData.getMaxRequestSize());
                        multipartConfig.setMaxFileSize(multipartConfigMetaData.getMaxFileSize());
                        multipartConfig.setFileSizeThreshold(multipartConfigMetaData.getFileSizeThreshold());
                        wrapper.setMultipartConfig(multipartConfig);
                    }
                    if (annotation.getServletSecurity() == null || wrapper.getServletSecurity() != null) continue;
                    ServletSecurityMetaData servletSecurityAnnotation = annotation.getServletSecurity();
                    HashSet<HttpMethodConstraintElement> methodConstraints = null;
                    ServletSecurity.EmptyRoleSemantic emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.PERMIT;
                    if (servletSecurityAnnotation.getEmptyRoleSemantic() != null) {
                        emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.valueOf((String)servletSecurityAnnotation.getEmptyRoleSemantic().toString());
                    }
                    ServletSecurity.TransportGuarantee transportGuarantee = ServletSecurity.TransportGuarantee.NONE;
                    if (servletSecurityAnnotation.getTransportGuarantee() != null) {
                        transportGuarantee = ServletSecurity.TransportGuarantee.valueOf((String)servletSecurityAnnotation.getTransportGuarantee().toString());
                    }
                    String[] roleNames = servletSecurityAnnotation.getRolesAllowed().toArray(new String[0]);
                    HttpConstraintElement constraint = new HttpConstraintElement(emptyRoleSemantic, transportGuarantee, roleNames);
                    if (servletSecurityAnnotation.getHttpMethodConstraints() != null) {
                        methodConstraints = new HashSet<HttpMethodConstraintElement>();
                        for (HttpMethodConstraintMetaData annotationMethodConstraint : servletSecurityAnnotation.getHttpMethodConstraints()) {
                            emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.PERMIT;
                            if (annotationMethodConstraint.getEmptyRoleSemantic() != null) {
                                emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.valueOf((String)annotationMethodConstraint.getEmptyRoleSemantic().toString());
                            }
                            transportGuarantee = ServletSecurity.TransportGuarantee.NONE;
                            if (annotationMethodConstraint.getTransportGuarantee() != null) {
                                transportGuarantee = ServletSecurity.TransportGuarantee.valueOf((String)annotationMethodConstraint.getTransportGuarantee().toString());
                            }
                            roleNames = annotationMethodConstraint.getRolesAllowed().toArray(new String[0]);
                            HttpConstraintElement constraint2 = new HttpConstraintElement(emptyRoleSemantic, transportGuarantee, roleNames);
                            HttpMethodConstraintElement methodConstraint = new HttpMethodConstraintElement(annotationMethodConstraint.getMethod(), constraint2);
                            methodConstraints.add(methodConstraint);
                        }
                    }
                    ServletSecurityElement servletSecurity = new ServletSecurityElement(constraint, methodConstraints);
                    wrapper.setServletSecurity(servletSecurity);
                }
            }
        }
    }

    protected void completeConfig() {
        WarMetaData warMetaData = (WarMetaData)this.deploymentUnitContext.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData metaData = warMetaData.getMergedJBossWebMetaData();
        if (this.ok && metaData != null) {
            metaData.resolveAnnotations();
            this.resolveAnnotations(metaData.getAnnotations());
        }
        if (this.ok) {
            this.resolveServletSecurity();
        }
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok && metaData != null) {
            metaData.resolveRunAs();
        }
        if (this.ok && !this.authenValves.isEmpty()) {
            HashMap<String, Valve> authenvalves = new HashMap<String, Valve>();
            for (String name : this.authenValves.keySet()) {
                AuthenticatorValve authenvalve = this.authenValves.get(name);
                Valve valve = null;
                try {
                    valve = (Valve)authenvalve.classz.newInstance();
                }
                catch (InstantiationException e) {
                    this.ok = false;
                    break;
                }
                catch (IllegalAccessException e) {
                    this.ok = false;
                    break;
                }
                if (authenvalve.properties != null) {
                    for (String pro : authenvalve.properties.keySet()) {
                        IntrospectionUtils.setProperty((Object)valve, (String)pro, (String)authenvalve.properties.get(pro));
                    }
                }
                authenvalves.put(name, valve);
            }
            if (this.ok) {
                this.setCustomAuthenticators(authenvalves);
            }
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (!this.ok) {
            WebLogger.WEB_LOGGER.unavailable(this.context.getName());
            this.context.setConfigured(false);
        }
    }

    Injector<DistributedCacheManagerFactory> getDistributedCacheManagerFactoryInjector() {
        return this.factory;
    }
}

