/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.ScisMetaData;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.vfs.VirtualFile;

public class ServletContainerInitializerDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Map<ServletContainerInitializer, Set<Class<?>>> handlesTypes;
        Set<ServletContainerInitializer> scis;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ServiceModuleLoader loader = (ServiceModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        assert (warMetaData != null);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException(WebMessages.MESSAGES.failedToResolveModule(deploymentUnit));
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        ScisMetaData scisMetaData = (ScisMetaData)deploymentUnit.getAttachment(ScisMetaData.ATTACHMENT_KEY);
        if (scisMetaData == null) {
            scisMetaData = new ScisMetaData();
            deploymentUnit.putAttachment(ScisMetaData.ATTACHMENT_KEY, (Object)scisMetaData);
        }
        if ((scis = scisMetaData.getScis()) == null) {
            scis = new HashSet<ServletContainerInitializer>();
            scisMetaData.setScis(scis);
        }
        if ((handlesTypes = scisMetaData.getHandlesTypes()) == null) {
            handlesTypes = new HashMap();
            scisMetaData.setHandlesTypes(handlesTypes);
        }
        for (ModuleDependency dependency : moduleSpecification.getSystemDependencies()) {
            try {
                Module depModule = loader.loadModule(dependency.getIdentifier());
                ServiceLoader serviceLoader = depModule.loadService(ServletContainerInitializer.class);
                for (ServletContainerInitializer service : serviceLoader) {
                    scis.add(service);
                }
            }
            catch (ModuleLoadException e) {
                if (dependency.isOptional()) continue;
                throw WebMessages.MESSAGES.errorLoadingSCIFromModule(dependency.getIdentifier(), (Exception)((Object)e));
            }
        }
        List<String> order = warMetaData.getOrder();
        Map<String, VirtualFile> localScis = warMetaData.getScis();
        if (order != null && localScis != null) {
            for (String jar : order) {
                ServletContainerInitializer service;
                VirtualFile sci = localScis.get(jar);
                if (sci == null || (service = this.loadSci((ClassLoader)classLoader, sci, jar, true)) == null) continue;
                scis.add(service);
            }
        }
        HashMap<Class, HashSet<ServletContainerInitializer>> typesMap = new HashMap<Class, HashSet<ServletContainerInitializer>>();
        for (ServletContainerInitializer service : scis) {
            HandlesTypes handlesTypesAnnotation;
            Class[] typesArray;
            if (!service.getClass().isAnnotationPresent(HandlesTypes.class) || (typesArray = (handlesTypesAnnotation = service.getClass().getAnnotation(HandlesTypes.class)).value()) == null) continue;
            for (Class type : typesArray) {
                HashSet<ServletContainerInitializer> servicesSet = (HashSet<ServletContainerInitializer>)typesMap.get(type);
                if (servicesSet == null) {
                    servicesSet = new HashSet<ServletContainerInitializer>();
                    typesMap.put(type, servicesSet);
                }
                servicesSet.add(service);
                handlesTypes.put(service, new HashSet());
            }
        }
        Class[] typesArray = typesMap.keySet().toArray(new Class[0]);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null) {
            throw WebMessages.MESSAGES.unableToResolveAnnotationIndex(deploymentUnit);
        }
        for (Class type : typesArray) {
            DotName className = DotName.createSimple((String)type.getName());
            Set<ClassInfo> classInfos = this.processHandlesType(className, type, index);
            Set<Class<?>> classes = this.loadClassInfoSet(classInfos, (ClassLoader)classLoader);
            Set sciSet = (Set)typesMap.get(type);
            for (ServletContainerInitializer sci : sciSet) {
                handlesTypes.get(sci).addAll(classes);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletContainerInitializer loadSci(ClassLoader classLoader, VirtualFile sci, String jar, boolean error) throws DeploymentUnitProcessingException {
        ServletContainerInitializer service = null;
        InputStream is = null;
        try {
            is = sci.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String servletContainerInitializerClassName = reader.readLine();
            int pos = servletContainerInitializerClassName.indexOf(35);
            if (pos > 0) {
                servletContainerInitializerClassName = servletContainerInitializerClassName.substring(0, pos);
            }
            servletContainerInitializerClassName = servletContainerInitializerClassName.trim();
            service = (ServletContainerInitializer)classLoader.loadClass(servletContainerInitializerClassName).newInstance();
        }
        catch (Exception e) {
            if (error) {
                throw WebMessages.MESSAGES.errorProcessingSCI(jar, e);
            }
            WebLogger.WEB_LOGGER.skippedSCI(jar, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return service;
    }

    private Set<ClassInfo> processHandlesType(DotName typeName, Class<?> type, CompositeIndex index) throws DeploymentUnitProcessingException {
        HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
        if (type.isAnnotation()) {
            List instances = index.getAnnotations(typeName);
            for (AnnotationInstance instance : instances) {
                AnnotationTarget annotationTarget = instance.target();
                if (annotationTarget instanceof ClassInfo) {
                    classes.add((ClassInfo)annotationTarget);
                    continue;
                }
                if (annotationTarget instanceof FieldInfo) {
                    classes.add(((FieldInfo)annotationTarget).declaringClass());
                    continue;
                }
                if (annotationTarget instanceof MethodInfo) {
                    classes.add(((MethodInfo)annotationTarget).declaringClass());
                    continue;
                }
                if (!(annotationTarget instanceof MethodParameterInfo)) continue;
                classes.add(((MethodParameterInfo)annotationTarget).method().declaringClass());
            }
        } else {
            classes.addAll(index.getAllKnownSubclasses(typeName));
            classes.addAll(index.getAllKnownImplementors(typeName));
        }
        return classes;
    }

    private Set<Class<?>> loadClassInfoSet(Set<ClassInfo> classInfos, ClassLoader classLoader) throws DeploymentUnitProcessingException {
        HashSet classes = new HashSet();
        for (ClassInfo classInfo : classInfos) {
            try {
                Class<?> type = classLoader.loadClass(classInfo.name().toString());
                classes.add(type);
            }
            catch (Exception e) {
                WebLogger.WEB_LOGGER.cannotLoadDesignatedHandleTypes(classInfo, e);
            }
        }
        return classes;
    }
}

