/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.infinispan.CacheException;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.loaders.remote.logging.Log;
import org.infinispan.loaders.remote.wrapper.DefaultEntryWrapper;
import org.infinispan.loaders.remote.wrapper.EntryWrapper;
import org.infinispan.loaders.remote.wrapper.HotRodEntryMarshaller;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;
import org.infinispan.util.logging.LogFactory;

public class RemoteCacheStoreConfig
extends AbstractCacheStoreConfig {
    private volatile String remoteCacheName;
    private boolean rawValues;
    private boolean hotRodWrapping;
    private static final Log log = (Log)LogFactory.getLog(RemoteCacheStoreConfig.class, Log.class);
    private final Properties hotRodClientProperties = new Properties();
    private ExecutorFactory asyncExecutorFactory = null;
    private EntryWrapper<?, ?> entryWrapper = new DefaultEntryWrapper();

    public RemoteCacheStoreConfig() {
        this.setCacheLoaderClassName(RemoteCacheStore.class.getName());
    }

    public void setRemoteCacheName(String remoteCacheName) {
        this.remoteCacheName = remoteCacheName;
        this.setProperty("remoteCacheName", remoteCacheName);
    }

    public String getRemoteCacheName() {
        return this.remoteCacheName;
    }

    public void setRawValues(boolean rawValues) {
        this.rawValues = rawValues;
        this.setProperty("rawValues", Boolean.toString(rawValues));
    }

    public boolean isRawValues() {
        return this.rawValues;
    }

    public boolean isHotRodWrapping() {
        return this.hotRodWrapping;
    }

    public void setHotRodWrapping(boolean hotRodWrapping) {
        this.hotRodWrapping = hotRodWrapping;
        this.setProperty("hotRodWrapping", Boolean.toString(hotRodWrapping));
        if (hotRodWrapping) {
            this.setRawValues(true);
            this.getHotRodClientProperties().put("infinispan.client.hotrod.marshaller", HotRodEntryMarshaller.class.getName());
            try {
                this.setEntryWrapper((EntryWrapper)Util.getInstanceStrict((String)"org.infinispan.loaders.remote.wrapper.HotRodEntryWrapper", (ClassLoader)this.getClassLoader()));
            }
            catch (Exception e) {
                throw log.cannotLoadHotRodEntryWrapper(e);
            }
        }
    }

    public void setUseDefaultRemoteCache(boolean useDefaultRemoteCache) {
        if (useDefaultRemoteCache) {
            this.setRemoteCacheName("___defaultcache");
        }
        this.setProperty("useDefaultRemoteCache", Boolean.toString(useDefaultRemoteCache));
    }

    public boolean isUseDefaultRemoteCache() {
        return "___defaultcache".equals(this.getRemoteCacheName());
    }

    public Properties getHotRodClientProperties() {
        this.hotRodClientProperties.putAll((Map<?, ?>)this.properties);
        return this.hotRodClientProperties;
    }

    public void setHotRodClientProperties(Properties props) {
        this.hotRodClientProperties.putAll((Map<?, ?>)props);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public ExecutorFactory getAsyncExecutorFactory() {
        return this.asyncExecutorFactory;
    }

    public void setAsyncExecutorFactory(ExecutorFactory asyncExecutorFactory) {
        this.asyncExecutorFactory = asyncExecutorFactory;
    }

    public EntryWrapper<?, ?> getEntryWrapper() {
        return this.entryWrapper;
    }

    public void setEntryWrapper(EntryWrapper<?, ?> entryWrapper) {
        this.entryWrapper = entryWrapper;
    }

    public void setHotRodClientPropertiesFile(String hotRodClientPropertiesFile) {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream inputStream = fileLookup.lookupFile(hotRodClientPropertiesFile, this.getClassLoader());
        try {
            this.hotRodClientProperties.load(inputStream);
        }
        catch (IOException e) {
            log.error("Issues while loading properties from file " + hotRodClientPropertiesFile, e);
            throw new CacheException((Throwable)e);
        }
        finally {
            Util.close((Closeable)inputStream);
        }
    }

    private void setProperty(String key, String value) {
        Properties p = this.getProperties();
        try {
            p.setProperty(key, value);
        }
        catch (UnsupportedOperationException e) {
            TypedProperties writableProperties = new TypedProperties(p);
            writableProperties.setProperty(key, value);
            this.setProperties((Properties)writableProperties);
        }
    }
}

