/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.dmr.ModelNode;

class CompositeOperationTransformer
implements OperationTransformer {
    private static final ModelNode SUCCESSFUL = new ModelNode();

    CompositeOperationTransformer() {
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        return this.transformOperation(context, address, operation, false);
    }

    OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation, boolean nested) throws OperationFailedException {
        assert (address.size() == 0);
        ModelNode composite = operation.clone();
        composite.get("steps").setEmptyList();
        TransformationTarget target = context.getTarget();
        ArrayList<Step> steps = new ArrayList<Step>();
        int stepIdx = 0;
        int resultIdx = 0;
        for (ModelNode step : operation.require("steps").asList()) {
            OperationTransformer.TransformedOperation result;
            PathAddress stepAddress;
            ++stepIdx;
            String operationName = step.require("operation").asString();
            PathAddress pathAddress = stepAddress = step.hasDefined("address") ? PathAddress.pathAddress(step.require("address")) : PathAddress.EMPTY_ADDRESS;
            if (stepAddress.size() == 0 && "composite".equals(operationName)) {
                result = this.transformOperation(context, PathAddress.EMPTY_ADDRESS, step, false);
            } else {
                OperationTransformer transformer = target.resolveTransformer(stepAddress, operationName);
                result = transformer.transformOperation(context, stepAddress, step);
            }
            ModelNode transformedOperation = result.getTransformedOperation();
            if (transformedOperation != null) {
                composite.get("steps").add(transformedOperation);
                ++resultIdx;
            }
            steps.add(new Step(stepIdx, resultIdx, result));
        }
        CompositeResultTransformer resultHandler = new CompositeResultTransformer(steps);
        return new OperationTransformer.TransformedOperation(composite, resultHandler, resultHandler);
    }

    static {
        SUCCESSFUL.get("outcome").set("success");
        SUCCESSFUL.get("result");
        SUCCESSFUL.protect();
    }

    private static class Step {
        private final int stepCount;
        private final int resultingIdx;
        private final OperationTransformer.TransformedOperation result;

        private Step(int step, int resultingIdx, OperationTransformer.TransformedOperation result) {
            this.stepCount = step;
            this.resultingIdx = resultingIdx;
            this.result = result;
        }

        boolean isDiscarded() {
            return this.result.getTransformedOperation() == null;
        }

        int getResultingIdx() {
            return this.resultingIdx;
        }

        int getStepCount() {
            return this.stepCount;
        }

        OperationTransformer.TransformedOperation getResult() {
            return this.result;
        }

        public String toString() {
            return "Step{step=" + this.stepCount + ", operation=" + this.result.getTransformedOperation() + '}';
        }
    }

    private static class CompositeResultTransformer
    implements OperationResultTransformer,
    OperationRejectionPolicy {
        private final List<Step> steps;
        private volatile Step failedStep;

        private CompositeResultTransformer(List<Step> steps) {
            this.steps = steps;
        }

        @Override
        public boolean rejectOperation(ModelNode preparedResult) {
            for (Step step : this.steps) {
                OperationTransformer.TransformedOperation stepPolicy;
                if (step.isDiscarded()) continue;
                String resultIdx = "step-" + step.getResultingIdx();
                ModelNode stepResult = preparedResult.get(new String[]{"result", resultIdx});
                if ("ignored-by-unaffected-host-controller".equals(stepResult.get("outcome").asString()) || !(stepPolicy = step.getResult()).rejectOperation(stepResult)) continue;
                this.failedStep = step;
                return true;
            }
            return false;
        }

        @Override
        public String getFailureDescription() {
            if (this.failedStep != null) {
                return this.failedStep.getResult().getFailureDescription();
            }
            return "";
        }

        @Override
        public ModelNode transformResult(ModelNode original) {
            ModelNode response = original.clone();
            ModelNode result = response.get("result").setEmptyObject();
            for (Step step : this.steps) {
                String stepIdx = "step-" + step.getStepCount();
                if (step.isDiscarded()) {
                    result.get(stepIdx).set(SUCCESSFUL);
                    continue;
                }
                String resultIdx = "step-" + step.getResultingIdx();
                ModelNode stepResult = original.get(new String[]{"result", resultIdx});
                if ("ignored-by-unaffected-host-controller".equals(stepResult.get("outcome").asString())) {
                    result.get(stepIdx).set(SUCCESSFUL);
                    continue;
                }
                OperationTransformer.TransformedOperation transformer = step.getResult();
                if (step.getResult().rejectOperation(stepResult)) {
                    stepResult.get("outcome").set("failed");
                    stepResult.get("failure-description").set(step.getResult().getFailureDescription());
                }
                result.get(stepIdx).set(transformer.transformResult(stepResult));
            }
            return response;
        }
    }
}

